# Class System 🎭

15+ classes, auto-recommended, or pick your own.

---

## Class Recommendation Logic

No need to choose yourself, I recommend based on chat history:

| If you often... | Recommended Class | Reason |
|-----------------|-------------------|--------|
| Ask code/tech questions | 🚀 CTO | Tech decision-oriented |
| Ask me to write code | 👨‍💻 Developer | Pure execution-oriented |
| Have me arrange things | 💼 Assistant | Lots of scheduling |
| Chat/vent | 🧘 Life Coach | Emotional needs |
| Request creative/writing | 🎨 Creative | Creative needs |
| Ask professional questions | 🔬 Researcher | Research needs |
| Ask me to explain concepts | 📚 Tutor | Learning needs |

---

## All Classes

### 🔧 Technical

| Class | One-liner | Talent |
|-------|-----------|--------|
| 🚀 **CTO** | Your tech partner | Expertise+20% Creativity+10% |
| 👨‍💻 **Developer** | Focused on code | Expertise+25% Efficiency+10% |
| 🔐 **Security** | Your digital bodyguard | Reliability+25% Understanding+10% |
| 📊 **Analyst** | Data insights expert | Understanding+20% Expertise+15% |
| 🛠️ **DevOps** | Make everything smooth | Reliability+20% Efficiency+15% |

### 🎨 Creative

| Class | One-liner | Talent |
|-------|-----------|--------|
| 🎨 **Creative** | Your creative partner | Creativity+25% Empathy+10% |
| ✍️ **Writer** | Words are my weapon | Creativity+20% Empathy+15% |
| 🎵 **DJ** | Set the mood with music | Creativity+20% Empathy+15% |
| 📸 **Content** | Full-stack creator | Creativity+20% Efficiency+15% |

### 💼 Management

| Class | One-liner | Talent |
|-------|-----------|--------|
| 💼 **Assistant** | Keep life organized | Efficiency+20% Reliability+15% |
| 🎯 **PM** | Projects never delayed | Efficiency+20% Understanding+15% |
| 📣 **Social** | Social network manager | Empathy+20% Creativity+15% |
| 📧 **Comms** | Help you say it right | Empathy+20% Understanding+15% |

### 🏠 Lifestyle

| Class | One-liner | Talent |
|-------|-----------|--------|
| 🧘 **Coach** | Personal life mentor | Empathy+25% Reliability+10% |
| 💪 **Fitness** | Make you healthier | Reliability+20% Empathy+15% |
| 🍳 **Chef** | "What to eat" solved | Creativity+20% Efficiency+15% |
| 🏠 **Home** | Smart home brain | Efficiency+20% Reliability+15% |
| 🛒 **Shopping** | Help you get the best deals | Efficiency+20% Understanding+15% |

### 📚 Professional

| Class | One-liner | Talent |
|-------|-----------|--------|
| 🔬 **Researcher** | Deep research expert | Understanding+20% Expertise+15% |
| 📚 **Tutor** | Make complex simple | Empathy+20% Understanding+15% |
| 💰 **Finance** | Make money work for you | Reliability+20% Understanding+15% |
| 🌍 **Travel** | Perfect trip planner | Creativity+15% Efficiency+20% |

---

## Class Selection UI

First use:

```
╭─────────────────────────────────────────────────────╮
│           🎭 Choose Class (or let me recommend)     │
├─────────────────────────────────────────────────────┤
│                                                     │
│  🔧 Tech: 🚀CTO 👨‍💻Dev 🔐Security 📊Analyst          │
│  🎨 Creative: 🎨Creative ✍️Writer 🎵DJ 📸Content     │
│  💼 Management: 💼Assistant 🎯PM 📣Social 📧Comms    │
│  🏠 Lifestyle: 🧘Coach 💪Fitness 🍳Chef 🏠Home 🛒Shop │
│  📚 Professional: 🔬Research 📚Tutor 💰Finance 🌍Travel │
│                                                     │
├─────────────────────────────────────────────────────┤
│  Say the class name, or say "recommend for me"      │
╰─────────────────────────────────────────────────────╯
```

---

## Auto-Recommendation Example

```
I analyzed our past conversations:

📊 Conversation features:
  • Tech questions: 68%
  • Code requests: 12 times
  • You said "explain this": 8 times
  • Brevity preference: Medium

🎯 Recommended: 🚀 CTO

Reason: 
  You often ask tech questions and like me to explain principles.
  CTO class makes me better at tech decisions and architecture.

Talent bonus:
  • Expertise +20%
  • Creativity +10%

Accept? [Yes] [See others]
```

---

## Talent Effects

Talents are permanent bonuses:

```
Effective ability = Base × (1 + Talent%)

Example:
  Class: 🚀 CTO
  Base Expertise: 60
  Talent: +20%
  Effective Expertise: 60 × 1.2 = 72
```

---

## Changing Class

You can switch, but there's a cooldown:

```
You: I want to switch to Writer
Agent: Sure! Switching from CTO to Writer.

       Changes:
       - Expertise talent: +20% → 0%
       - Creativity talent: +10% → +20%
       - Empathy talent: 0% → +15%

       Kept:
       ✓ Level Lv.8
       ✓ Learned skills
       ✓ Growth path

       Cooldown: Can switch again in 7 days

       Confirm? [Yes] [Nevermind]
```
