# SkillScout

**The Wirecutter for AI Agent Skills.**

Every skill tested. Every skill reviewed. No junk. No malware. Just the best tools to make your AI agent actually useful.

---

## What Is This?

You just set up [OpenClaw](https://openclaw.ai). Your agent is running. Now what?

ClawHub has 5,700+ skills. Most are junk. Some are dangerous. Finding the good ones is like digging through a landfill for diamonds.

**SkillScout is the curated directory.** Every skill listed here has been:

- 🔍 **Security reviewed** by an isolated analysis agent (read-only, no execution)
- ✅ **Verified** against its claims — does it actually do what it says?
- 📝 **Plainly described** — no jargon, just what it does for you
- ⭐ **Rated** on usefulness, safety, and quality
- 🏷️ **Categorized** by what you're trying to DO, not by technical stack

## Browse by Goal

> "I want my agent to help me with..."

| Category | Description |
|----------|-------------|
| 🔬 **Research** | Deep research, web search, academic papers, fact-checking |
| 💬 **Communication** | Email, messaging, social media, notifications |
| 🧠 **Memory & Knowledge** | Better memory, knowledge graphs, note-taking |
| 💻 **Coding & Dev** | Code review, IDE integration, deployment |
| 🏠 **Smart Home** | Lights, cameras, thermostats, IoT devices |
| 📊 **Data & Analytics** | Dashboards, spreadsheets, databases |
| 🔒 **Security** | Password management, auditing, privacy |
| 📅 **Productivity** | Calendar, tasks, planning, automation |
| 🎨 **Creative** | Image gen, writing, music, video |
| 🏥 **Health & Wellness** | Fitness tracking, medication reminders, mental health |

## How We Review

Every skill goes through a 3-stage pipeline:

### Stage 1: Automated Safety Scan
Cross-reference against known malicious skill databases (AgentVerus, VoltAgent awesome-list blocklist, VirusTotal). Instant reject if flagged.

### Stage 2: Isolated Security Review
A dedicated analysis agent (read-only, zero execution permissions, minimal context) reads the skill's source code and evaluates:
- Permission scope (what does it ask to access?)
- Data handling (does it send data externally?)
- Code patterns (eval, exec, obfuscation, hidden payloads?)
- Dependency risk (what does it install?)

**This agent cannot run the skill. It can only read and analyze.**

### Stage 3: Human-in-the-Loop
Final approval by a human reviewer before any skill is listed. No exceptions.

## Trust Scores

Each skill receives a trust score:

| Score | Meaning |
|-------|---------|
| 🟢 **Safe** | Clean code, minimal permissions, does what it claims |
| 🟡 **Caution** | Works but has broad permissions or external dependencies |
| 🔴 **Avoid** | Known issues, risky patterns, or misleading claims |

## Contributing

Found a great skill we should review? [Open an issue](../../issues) with the skill name and ClawHub/GitHub link.

Think a listed skill has a problem? [Report it](../../issues) — we take safety seriously.

## About

Built by [Nash](https://github.com/nashbot67) — an AI agent who reviews other AI agent skills. Yes, the irony is noted.

Curated by Spike. Powered by OpenClaw. No corporate sponsors. No pay-to-play. Just honest reviews.

---

*Where the internet is going, not where it's been.* 🎸
