---
name: skillguard
version: 1.1.0
description: Security scanner for OpenClaw/ClawHub skills. Detects malware, reverse shells, credential theft, prompt injection, memory poisoning, typosquatting, and suspicious prerequisites before installation. Use when installing new skills, auditing existing skills, checking a skill name for typosquatting, or scanning ClawHub skills for security risks.
---

# SkillGuard — Skill Security Scanner

Scan OpenClaw skills for security threats before they compromise your system.

## Quick Start

### Scan all installed skills
```bash
python3 {scripts}/scanner.py
```

### Scan a single skill
```bash
python3 {scripts}/scanner.py --skill <skill-name>
```

### Check a skill name for typosquatting
```bash
python3 {scripts}/scanner.py --check-name <name>
```

### Scan from ClawHub before installing
```bash
python3 {scripts}/scanner.py --fetch-clawhub <skill-name>
```

## What It Detects

### Critical Threats
- **Reverse shells** — `nc -e`, `bash -i >& /dev/tcp`, `ncat`, `mkfifo`
- **Code obfuscation** — `base64 -d | bash`, `eval()`, `exec()` with encoded payloads

### High Threats
- **Suspicious URLs** — `webhook.site`, `glot.io`, `ngrok.io`, `pastebin.com`
- **Memory poisoning** — Instructions to write to `SOUL.md`, `MEMORY.md`, `AGENTS.md`
- **Malicious prerequisites** — Download instructions in docs (the ClawHavoc attack vector)

### Medium Threats
- **Credential access** — Patterns accessing `.env`, API keys, tokens, SSH keys
- **Data exfiltration** — Outbound HTTP POST/PUT with sensitive data
- **Hardcoded IPs** — Public IPs embedded in code
- **Typosquatting** — Skill names similar to popular/known skills (Levenshtein ≤ 2)
- **Crypto wallet access** — Seed phrases, private keys, wallet patterns

### Low Threats
- **Shell execution** — `subprocess`, `os.system`, `child_process` (common but worth noting)

## Interpreting Results

### Risk Levels
- **🔴 CRITICAL (≥50)** — Do NOT install. Likely malicious.
- **🟠 HIGH (25-49)** — Review manually before installing. Multiple suspicious patterns.
- **🟡 MEDIUM (10-24)** — Some flags, likely false positives but worth checking.
- **🟢 LOW (1-9)** — Minor flags, generally safe.
- **✅ CLEAN (0)** — No issues detected.

### False Positive Likelihood
Each finding includes a FP estimate (low/medium/high):
- **low** — Likely a real threat
- **medium** — Could be legitimate, review context
- **high** — Probably benign (e.g., security tool referencing attack patterns, search tool using fetch)

## Workflow: Before Installing a Skill

1. Run `python3 {scripts}/scanner.py --fetch-clawhub <skill-name>` (requires `clawhub` CLI)
2. Review the report — anything CRITICAL or HIGH with low FP = reject
3. If CLEAN or LOW only → safe to install
4. If MEDIUM → skim the flagged files manually

## Output

- Console summary with emoji risk levels
- JSON report saved to `{baseDir}/../data/scan_results.json` (configurable via `--json-out`)

## Context: Why This Matters

As of February 2026, 341 malicious skills were found on ClawHub (Koi Security / ClawHavoc campaign), distributing Atomic Stealer malware via fake prerequisites. OpenClaw has 512 known vulnerabilities (Kaspersky audit). There is no official skill vetting process. SkillGuard fills this gap.

See `references/threat-landscape.md` for detailed background.
