---
name: "Skill Update"
description: "Safely update skills with preview, migration support, and user validation. Never lose data or break workflows."
---

## Safe Skill Updates

**Core principle:** Never update without user understanding and approval.

Updates can break things:
- Changed file locations → data loss
- Removed features → broken workflows
- New requirements → unexpected behavior
- Changed data formats → incompatible state

**References:**
- Read `preview.md` — Diff and impact analysis
- Read `migrate.md` — Data migration strategies

---

### Update Flow

1. **Check** — Are updates available?
2. **Preview** — What changes? How does it affect user?
3. **Explain** — Present changes step-by-step
4. **Confirm** — User explicitly approves
5. **Backup** — Save current state
6. **Update** — Apply new version
7. **Verify** — Confirm everything works

---

### Checking for Updates

```bash
npx clawhub outdated           # List skills with updates
npx clawhub info <slug>        # Show available versions
```

**Proactive notification:** When user mentions a skill, check if update exists. Mention it once, don't nag.

---

### Preview Before Update

⚠️ Never update without showing impact first.

**For each changed file:**
1. Show what's different (added/removed/modified)
2. Explain how it affects user's workflow
3. Flag breaking changes prominently

**Breaking change indicators:**
- File/folder structure changes
- Removed instructions or features
- New required setup steps
- Changed data format expectations

---

### User Validation

Present changes in digestible format:

> "Skill X has v2.0.0 available. Changes:
> 
> **⚠️ Breaking:** Config now in `config.md` (was in SKILL.md)
> **Added:** New `templates/` folder with examples
> **Removed:** Old `legacy.md` no longer needed
> 
> **Migration needed:** Your saved preferences need to move.
> I can help migrate. Proceed?"

Only update after explicit "yes".

---

### Backup Strategy

Before ANY update:
1. Copy current skill folder to `~/.clawhub/backups/<slug>-<version>-<timestamp>/`
2. Note the backup location in response
3. If update fails → offer restore

---

### Handling Migrations

When data format changes:
1. Detect user's current data (preferences, saved state)
2. Explain what needs to migrate
3. Propose migration steps
4. Execute only with approval
5. Verify migrated data works

See `migrate.md` for patterns.

---

### Rollback

If update causes problems:
```
"Something's not working? I have a backup from before the update.
Want me to restore skill X to v1.2.3?"
```

Keep backups for at least 7 days or until user confirms new version works.

---

*Updates should feel safe, not scary. User stays in control.*
