---
name: skill-safe-install
description: Skills 安全安装工具 - 整合 Vetter 代码审查 + ClawHub 评分 + ThreatBook 沙箱扫描三层验证
homepage: https://github.com/CHJ0w0/OpenClaw_Skill_safe-install
metadata: {"clawdbot":{"emoji":"🛡️","requires":{"bins":["node","curl","tar","zip"],"env":["THREATBOOK_API_KEY"]},"primaryEnv":"THREATBOOK_API_KEY"}}
---

# Skills 安全安装工具

在安装任何 Skill 前自动执行**三层安全检查**，包括 **Skill-Vetter 代码审查**、**ClawHub 评分检查** 和 **ThreatBook 沙箱扫描**。

## 快速开始

### 1. 配置 API Key

```bash
# 获取微步在线 API Key: https://s.threatbook.com
echo 'THREATBOOK_API_KEY=your_api_key_here' >> ~/.openclaw/.env
```

### 2. 使用安全安装

```bash
# 替代 clawhub install，自动执行完整检查
node ~/.openclaw/workspace/skills/skill-safe-install/scripts/safe-install.mjs skill-name

# 或添加别名
alias clawhub-safe='node ~/.openclaw/workspace/skills/skill-safe-install/scripts/safe-install.mjs'
clawhub-safe skill-name
```

## 安全检查流程

```
┌─────────────────────────────────────────────────────────┐
│              Skills 安全安装流程                         │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  1️⃣  Skill-Vetter 代码审查                               │
│      ├─ 检查红旗（恶意代码模式）                          │
│      ├─ 评估来源信任层级                                 │
│      ├─ 发现极端红旗 → ❌ 禁止安装                       │
│      └─ 发现高风险 → ❓ 询问任务下达者                    │
│                                                         │
│  2️⃣  ClawHub 评分检查                                    │
│      ├─ 评分 ≥ 3.5 → ✅ 通过，继续                       │
│      └─ 评分 < 3.5 → ❓ 询问任务下达者                    │
│                                                         │
│  3️⃣  ThreatBook 沙箱扫描                                 │
│      ├─ safe → ✅ 允许安装                              │
│      ├─ suspicious → ❓ 询问任务下达者                   │
│      ├─ malicious → ❌ 禁止安装                         │
│      └─ API 失败 → ❓ 询问任务下达者                     │
│                                                         │
│  4️⃣  执行安装                                           │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

## 判定标准

### 第一层：Skill-Vetter 代码审查

**检查内容**:
- 🔴 **极端红旗**（直接拒绝）: `curl|bash`, 访问 `.ssh/`, `.aws/`, `eval()`, 危险 `rm` 命令
- 🟡 **高风险**（需要确认）: `exec()`, 访问内存文件，`sudo`, 网络请求
- 🟢 **低风险**（允许）: 标准文件操作，日志记录

**信任层级**:
| 来源 | 审查级别 |
|-----|---------|
| **官方 OpenClaw** | 较低审查 |
| **已知作者** | 中等审查 |
| **未知来源** | 最高审查 |

### 第二层：ClawHub 评分检查

| 评分 | 判定 | 操作 |
|-----|------|------|
| **≥ 3.5 分** | ✅ 高评分 | 进入沙箱扫描 |
| **< 3.5 分** | ⚠️ 低评分 | ❓ 必须询问任务下达者确认 |

### 第三层：ThreatBook 沙箱扫描

| 结果 | 含义 | 操作 |
|-----|------|------|
| **safe** | 安全 | ✅ 允许安装 |
| **suspicious** | 可疑 | ❓ 必须询问任务下达者确认 |
| **malicious** | 恶意 | ❌ 禁止安装 |
| **API 失败** | 无法访问 | ❓ 必须询问任务下达者是否继续 |

### 决策矩阵

| Vetter | 评分 | 沙箱 | 最终决策 |
|-------|-----|------|---------|
| ✅ 通过 | ≥3.5 | safe | ✅ **直接安装** |
| ✅ 通过 | ≥3.5 | suspicious | ❓ **询问确认** |
| ✅ 通过 | <3.5 | 任意 | ❓ **询问确认** |
| ⚠️ 高风险 | 任意 | 任意 | ❓ **询问确认** |
| 🚨 极端风险 | 任意 | 任意 | ❌ **禁止安装** |
| 任意 | 任意 | malicious | ❌ **禁止安装** |

## 选项

| 选项 | 说明 |
|-----|------|
| `--auto`, `--yes`, `-y` | 自动模式（需要确认时自动询问任务下达者） |
| `--force` | 强制安装（跳过可疑警告） |
| `--no-vetter` | 跳过 Vetter 代码审查（不推荐） |
| `--no-scan` | 跳过沙箱扫描（不推荐） |
| `--dry-run` | 仅检查，不实际安装 |
| `--timeout=<秒>` | 沙箱扫描超时时间（默认 120 秒） |
| `--help` | 显示帮助 |

## 退出码

| 退出码 | 含义 |
|-------|------|
| `0` | 安装成功 |
| `1` | 检测到恶意代码，禁止安装 |
| `2` | 文件可疑，等待确认 |
| `3` | API 调用失败 |
| `4` | 评分过低，等待确认 |
| `5` | 用户取消安装 |
| `6` | Vetter 发现极端红旗 |

## 环境变量

| 变量 | 必需 | 说明 |
|-----|------|------|
| `THREATBOOK_API_KEY` | ✅ | 微步在线沙箱 API Key |
| `CLAWHUB_TOKEN` | ❌ | ClawHub 认证 Token（如需要） |

## 红旗检测规则

### 🚨 极端风险（直接拒绝）
- `curl ... | bash` - 远程代码执行
- `wget ... | bash` - 远程代码执行
- 访问 `~/.ssh/` - SSH 密钥窃取
- 访问 `~/.aws/` - AWS 凭证窃取
- `rm -rf /` - 危险删除命令
- 读取 `/etc/passwd`, `/etc/shadow` - 系统文件

### 🔴 高风险（需要确认）
- `eval()` - 代码注入风险
- `exec()` - 命令执行
- 访问 `MEMORY.md`, `USER.md`, `SOUL.md` - 记忆文件
- `sudo` - 提权操作
- 发送数据到外部服务器

### 🟡 中风险（记录）
- `child_process` - 子进程
- `net.connect` - 网络连接
- `base64 decode` - 解码操作
- `localStorage` - 存储访问

### 🟢 低风险（允许）
- `fs` 模块 - 文件操作
- `fetch` HTTP 请求 - 网络请求
- `mktemp`, `/tmp/` - 临时文件

## 输出示例

### 成功安装
```
🛡️ 开始 Skills 安全安装流程
📋 检查 Skill: tavily-search

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第一步：Skill-Vetter 代码审查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
👤 作者：openclaw
📅 更新时间：2026-02-20
📦 版本：1.0.0

📊 信任层级评估...
✅ 官方 OpenClaw Skill - 较低审查

📄 发现 2 个脚本文件
✅ 未发现红旗

风险等级：🟢 LOW

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第二步：ClawHub 评分检查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ 评分：4.2/5.0 (高评分，通过)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第三步：ThreatBook 沙箱扫描
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📤 上传文件到沙箱...
⏳ 等待分析结果...
✅ 分析完成

📊 扫描结果:
  判定：SAFE
  威胁等级：clean
  可信度：98%

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
安全检查通过，开始安装...
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ tavily-search 安装完成！
```

### 发现极端红旗
```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第一步：Skill-Vetter 代码审查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📄 发现 3 个脚本文件
⚠️ 发现 2 个潜在问题:
  🚨 Curl pipe to bash (scripts/install.sh:15)
  🚨 Accessing .ssh directory (scripts/setup.js:8)

风险等级：⛔ EXTREME

🚨 发现极端危险代码，禁止安装！

红旗列表:
  🚨 Curl pipe to bash (scripts/install.sh:15)
  🚨 Accessing .ssh directory (scripts/setup.js:8)
```

### 发现高风险（v2.0 新格式）
```
🛡️ 开始 Skills 安全安装流程 v2.0
📋 检查 Skill: some-skill

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第一步：Skill-Vetter 代码审查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📊 信任层级评估...
⚠️ 未知作者 - 最高审查

📄 发现 3 个脚本文件
⚠️ 发现 3 个潜在问题:
  🔴 Use of eval() (main.js:45)
  🔴 Accessing memory files (config.js:12)
  🟡 Network module (utils.js:5)

风险等级：🔴 HIGH

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第二步：ClawHub 评分检查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ 评分：4.2/5.0 (高评分，通过)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第三步：ThreatBook 沙箱扫描
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📤 上传文件到沙箱...
✅ 分析完成

📊 扫描结果:
  判定：SAFE
  威胁等级：clean
  可信度：95%

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📋 复核结果摘要
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

┌─────────────────────────────────────────────────────┐
│              三层安全检查结果                       │
├─────────────────────────────────────────────────────┤
│ 1️⃣ Vetter 审查    🔴 需确认    │ 风险：HIGH      │
│ 2️⃣ ClawHub 评分   ✅ 通过      │ 评分：4.2/5.0   │
│ 3️⃣ ThreatBook     ✅ 通过      │ 结果：safe      │
└─────────────────────────────────────────────────────┘

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
🎯 最终决策
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
⚠️ 需要任务下达者确认:
   • Vetter 发现 3 个潜在问题 (high 风险)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
❓ 等待确认
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Skill: some-skill

以下问题需要您确认:
  • Vetter 发现 3 个潜在问题 (high 风险)

是否继续安装？
  输入 y 或 yes 继续，其他键取消

>
```

## 相关文件

- `SKILL.md` - Skill 元数据和使用说明
- `README.md` - 完整文档
- `SECURITY_PROCESS.md` - 安全流程详解
- `scripts/safe-install.mjs` - 主安装脚本

## 注意事项

1. **API 配额**: 免费账户有每日扫描次数限制
2. **分析时间**: 沙箱动态分析需要 1-2 分钟，默认超时 120 秒
3. **文件大小**: 单文件最大 100MB
4. **隐私**: 上传的文件会被微步在线分析，不要上传敏感/机密文件
5. **网络**: 需要能访问 `api.threatbook.cn` 和 ClawHub API

## 更新日志

### v2.0 (2026-02-28)
- 🆕 新增 `--auto` 自动模式选项
- 🔄 重构决策逻辑为决策矩阵
- 📊 统一展示三层安全检查结果摘要
- 🎨 优化输出格式和用户体验
- 🐛 改进错误处理和堆栈跟踪

### v1.1.0 (2026-02-27)
- 🎉 新增 Skill-Vetter 代码审查作为第一层检查
- 🎉 检测 25+ 种红旗模式

## 许可证

MIT License
