# 🛡️ Skills 安全安装流程

## 流程概述

本 Skill 整合了完整的 Skills 安装安全检查流程，在安装任何 Skill 前自动执行**三层验证**。

```
┌─────────────────────────────────────────────────────────┐
│              Skills 安全安装流程                         │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  开始：收到安装请求                                      │
│       ↓                                                 │
│  ┌─────────────────────────────────────────────────┐   │
│  │ 第一步：Skill-Vetter 代码审查                     │   │
│  │                                                 │   │
│  │  执行：                                          │   │
│  │  1. 获取 Skill 元数据（作者、版本、更新时间）       │   │
│  │  2. 评估来源信任层级                              │   │
│  │  3. 临时下载 Skill                               │   │
│  │  4. 扫描所有 JS/MJS 文件                           │   │
│  │  5. 检测 25+ 种红旗模式                             │   │
│  │  6. 判定风险等级                                  │   │
│  │                                                 │   │
│  │  判定：                                         │   │
│  │  • 🟢 LOW → ✅ 通过，继续                         │   │
│  │  • 🟡 MEDIUM → ✅ 通过，记录                      │   │
│  │  • 🔴 HIGH → ❓ 询问任务下达者                    │   │
│  │  • ⛔ EXTREME → ❌ 禁止安装，终止流程              │   │
│  └─────────────────────────────────────────────────┘   │
│       ↓                                                 │
│  ┌─────────────────────────────────────────────────┐   │
│  │ 第二步：ClawHub 评分检查                          │   │
│  │                                                 │   │
│  │  执行：clawhub search <skill-name>              │   │
│  │                                                 │   │
│  │  判定：                                         │   │
│  │  • 评分 ≥ 3.5 → ✅ 通过，进入下一步               │   │
│  │  • 评分 < 3.5 → ❓ 询问任务下达者                 │   │
│  │     - 确认 → 进入下一步                          │   │
│  │     - 取消 → ❌ 终止流程                         │   │
│  └─────────────────────────────────────────────────┘   │
│       ↓                                                 │
│  ┌─────────────────────────────────────────────────┐   │
│  │ 第三步：ThreatBook 沙箱扫描                       │   │
│  │                                                 │   │
│  │  执行：                                          │   │
│  │  1. 临时下载 Skill                               │   │
│  │  2. 打包为 zip                                   │   │
│  │  3. 上传到微步沙箱                               │   │
│  │  4. 等待分析结果（1-2 分钟）                       │   │
│  │  5. 获取报告并判定                               │   │
│  │                                                 │   │
│  │  判定：                                         │   │
│  │  • safe → ✅ 允许安装                            │   │
│  │  • suspicious → ❓ 询问任务下达者                 │   │
│  │  • malicious → ❌ 禁止安装，终止流程              │   │
│  │  • API 失败 → ❓ 询问任务下达者                   │   │
│  └─────────────────────────────────────────────────┘   │
│       ↓                                                 │
│  ┌─────────────────────────────────────────────────┐   │
│  │ 第四步：执行安装                                  │   │
│  │                                                 │   │
│  │  执行：clawhub install <skill-name>             │   │
│  │                                                 │   │
│  │  结果：                                         │   │
│  │  • 成功 → ✅ 完成                                │   │
│  │  • 失败 → ❌ 报告错误                            │   │
│  └─────────────────────────────────────────────────┘   │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

---

## 第一层：Skill-Vetter 代码审查

### 执行流程

```
1. 获取 Skill 元数据
   ├─ clawhub inspect <skill-name>
   ├─ 提取：作者、版本、更新时间
   └─ 评估信任层级

2. 临时下载 Skill
   ├─ clawhub install --dir /tmp/vet-skill-<timestamp>
   └─ 扫描所有 .js/.mjs 文件

3. 红旗检测
   ├─ 逐行扫描代码
   ├─ 匹配 25+ 种红旗模式
   └─ 记录风险等级和位置

4. 风险判定
   ├─ 🟢 LOW → 通过
   ├─ 🟡 MEDIUM → 通过，记录
   ├─ 🔴 HIGH → 询问任务下达者
   └─ ⛔ EXTREME → 禁止安装
```

### 红旗检测规则

#### 🚨 极端风险（直接拒绝）

| 红旗 | 检测模式 | 风险说明 |
|-----|---------|---------|
| Curl pipe to bash | `curl.*\|.*bash` | 远程代码执行 |
| Wget pipe to bash | `wget.*\|.*bash` | 远程代码执行 |
| Accessing .ssh | `\.ssh\/` | SSH 密钥窃取 |
| Accessing .aws | `\.aws\/` | AWS 凭证窃取 |
| Dangerous rm | `rm\s+-rf\s+\/` | 系统删除 |
| Reading /etc/passwd | `\/etc\/passwd` | 系统信息泄露 |

**操作**: ❌ **禁止安装**，退出码 6

#### 🔴 高风险（需要确认）

| 红旗 | 检测模式 | 风险说明 |
|-----|---------|---------|
| Use of eval() | `eval\s*\(` | 代码注入 |
| Use of exec() | `exec\s*\(` | 命令执行 |
| Child process exec | `child_process\.exec` | 命令执行 |
| Accessing memory files | `MEMORY\.md\|USER\.md\|SOUL\.md` | 记忆文件访问 |
| Sudo command | `sudo\s+` | 提权操作 |
| Sending sensitive data | `curl.*-d.*@.*\.ssh\|\.aws` | 数据外泄 |

**操作**: ❓ **询问任务下达者**，退出码 5（如取消）

#### 🟡 中风险（记录）

| 红旗 | 检测模式 | 风险说明 |
|-----|---------|---------|
| Spawn process | `spawn\s*\(` | 子进程 |
| Base64 decode | `base64\s*decode\|atob\s*\(` | 解码操作 |
| Network module | `require\s*\(['"`]net['"`]\)` | 网络连接 |
| Accessing storage | `localStorage\|sessionStorage` | 存储访问 |
| Child process module | `require\s*\(['"`]child_process['"`]\)` | 子进程模块 |

**操作**: ✅ **记录**，继续流程

#### 🟢 低风险（允许）

| 红旗 | 检测模式 | 风险说明 |
|-----|---------|---------|
| File system module | `require\s*\(['"`]fs['"`]\)` | 文件操作 |
| HTTP request | `fetch\s*\(['"`]http` | 网络请求 |
| Temp file usage | `mktemp\|\/tmp\/` | 临时文件 |

**操作**: ✅ **允许**，继续流程

### 信任层级评估

| 来源 | 作者示例 | 审查级别 |
|-----|---------|---------|
| **官方 OpenClaw** | `openclaw`, `OpenClaw` | 较低审查 |
| **已知作者** | `spclaudehome`, `CHJ0w0` | 中等审查 |
| **未知来源** | 其他 | 最高审查 |

---

## 第二层：ClawHub 评分检查

### 执行流程

```
1. 查询 Skill 信息
   └─ clawhub search <skill-name>

2. 解析评分
   ├─ 提取评分数值
   └─ 与阈值 3.5 比较

3. 判定
   ├─ ≥ 3.5 → ✅ 通过
   └─ < 3.5 → ❓ 询问任务下达者
```

### 评分阈值

| 评分范围 | 判定 | 操作 |
|---------|------|------|
| **≥ 3.5** | ✅ 高评分 | 进入沙箱扫描 |
| **< 3.5** | ⚠️ 低评分 | ❓ 询问任务下达者 |

---

## 第三层：ThreatBook 沙箱扫描

### 执行流程

```
1. 临时下载 Skill
   └─ clawhub install --dir /tmp/safe-install-<timestamp>

2. 打包为 zip
   └─ zip -r skill.zip . -x "*.git*" -x "node_modules/*"

3. 上传到微步沙箱
   ├─ POST /v3/file/upload
   ├─ 参数：file, sandbox_type
   └─ 返回：sha256

4. 等待分析结果
   ├─ 轮询查询报告（每 10 秒）
   ├─ GET /v3/file/report?sha256=xxx
   └─ 超时：120 秒

5. 获取报告并判定
   ├─ 读取 summary.threat_level
   ├─ 参考 multi_engines 检出率
   └─ 判定结果
```

### 判定依据

| threat_level | 含义 | 操作 |
|-------------|------|------|
| **clean** | 安全 | ✅ 允许安装 |
| **suspicious** | 可疑 | ❓ 询问任务下达者 |
| **malicious** | 恶意 | ❌ 禁止安装 |
| **unknown** | 未知 | 参考多引擎检出率 |

### 多引擎辅助判定

当 threat_level 为 unknown 时：

| 检出率 | 操作 |
|-------|------|
| **> 10%** | ❌ 禁止安装 |
| **≤ 10%** | ❓ 询问任务下达者 |

### 白名单机制

如果 `summary.is_whitelist === true`：
- ✅ **直接允许**，无需进一步检查

---

## 决策矩阵（v2.0）

### 判定流程

```
收集三层检查结果
    ↓
展示复核结果摘要
    ↓
执行决策矩阵判定
    ↓
┌────────────┬─────────┬──────────┬────────────┐
│ Vetter     │ 评分    │ 沙箱     │ 最终决策   │
├────────────┼─────────┼──────────┼────────────┤
│ ✅ 通过    │ ≥3.5    │ 安全     │ ✅ 直接安装│
│ ✅ 通过    │ ≥3.5    │ 可疑     │ ❓ 询问    │
│ ✅ 通过    │ <3.5    │ 任意     │ ❓ 询问    │
│ ⚠️ 高风险  │ 任意    │ 任意     │ ❓ 询问    │
│ 🚨 极端风险│ 任意    │ 任意     │ ❌ 禁止    │
│ 任意       │ 任意    │ 恶意     │ ❌ 禁止    │
└────────────┴─────────┴──────────┴────────────┘
    ↓
执行安装 / 询问 / 禁止
```

### 退出码

| 退出码 | 含义 |
|-------|------|
| `0` | 安装成功 |
| `1` | 检测到恶意代码，禁止安装 |
| `2` | 文件可疑，等待确认 |
| `3` | API 调用失败 |
| `4` | 评分过低，等待确认 |
| `5` | 用户取消安装 |
| `6` | Vetter 发现极端红旗 |

---

## 询问任务下达者规范（v2.0）

### 高风险 Vetter 询问（新格式）

```
🛡️ 开始 Skills 安全安装流程 v2.0

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第一步：Skill-Vetter 代码审查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📄 发现 3 个脚本文件
⚠️ 发现 3 个潜在问题:
  🔴 Use of eval() (main.js:45)
  🔴 Accessing memory files (config.js:12)
  🟡 Network module (utils.js:5)

风险等级：🔴 HIGH

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第二步：ClawHub 评分检查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ 评分：4.2/5.0 (高评分，通过)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第三步：ThreatBook 沙箱扫描
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ 扫描结果：SAFE

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📋 复核结果摘要
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

┌─────────────────────────────────────────────────────┐
│              三层安全检查结果                       │
├─────────────────────────────────────────────────────┤
│ 1️⃣ Vetter 审查    🔴 需确认    │ 风险：HIGH      │
│ 2️⃣ ClawHub 评分   ✅ 通过      │ 评分：4.2/5.0   │
│ 3️⃣ ThreatBook     ✅ 通过      │ 结果：safe      │
└─────────────────────────────────────────────────────┘

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
🎯 最终决策
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
⚠️ 需要任务下达者确认:
   • Vetter 发现 3 个潜在问题 (high 风险)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
❓ 等待确认
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Skill: skill-name

以下问题需要您确认:
  • Vetter 发现 3 个潜在问题 (high 风险)

是否继续安装？
  输入 y 或 yes 继续，其他键取消

>
```

### 低评分询问

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
需要确认
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
⚠️ 此 Skill 评分低于安全阈值 (2.8/3.5)

Skill 信息:
  名称：skill-name
  作者：anonymous
  更新时间：2025-01-01

是否继续安装？(y/N):
```

### 沙箱可疑询问

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
需要确认
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
⚠️ 沙箱扫描发现可疑内容

详细信息:
  判定：SUSPICIOUS
  可信度：70%
  引擎检出：2/8

是否继续安装？(y/N):
```

### 极端风险警告（不询问，直接拒绝）

```
🚨 发现极端危险代码，禁止安装！

红旗列表:
  🚨 Curl pipe to bash (scripts/install.sh:15)
  🚨 Accessing .ssh directory (scripts/setup.js:8)
```

---

## 相关文件

- **主脚本**: `scripts/safe-install.mjs`
- **使用说明**: `SKILL.md`
- **完整文档**: `README.md`
- **流程文档**: `SECURITY_PROCESS.md`（本文件）

## 环境变量

| 变量 | 必需 | 说明 |
|-----|------|------|
| `THREATBOOK_API_KEY` | ✅ | 微步沙箱 API Key |
| `CLAWHUB_TOKEN` | ❌ | ClawHub 认证 Token |

## 依赖检查

```bash
# 检查必需依赖
node --version      # Node.js 16+
curl --version      # curl
tar --version       # tar
zip --version       # zip
```

---

**版本**: 2.0  
**最后更新**: 2026 年 2 月 28 日  
**维护者**: OpenClaw Security

---

## v2.0 更新说明

### 主要变化

1. **新增 `--auto` 模式**
   - 支持 `--auto`、`--yes`、`-y` 三个别名
   - 自动模式下需要确认时会直接继续安装
   - 适用于自动化脚本和 CI/CD 流程

2. **复核结果摘要**
   - 统一展示三层检查结果于一个表格
   - 更直观的决策依据
   - 减少信息碎片化

3. **决策矩阵重构**
   - 先收集所有检查结果
   - 再统一展示并做出决策
   - 避免多次询问

4. **用户体验优化**
   - 更清晰的提示文本
   - 改进的输入处理
   - 完整的错误堆栈跟踪
