# 🛡️ Skills 安全安装工具

在安装任何 Skill 前自动执行**三层安全检查**，包括 **Skill-Vetter 代码审查**、**ClawHub 评分检查** 和 **ThreatBook 沙箱扫描**。

## 核心特性

- ✅ **自动触发** - 安装前自动执行检查，无需手动操作
- ✅ **三层验证** - Vetter 代码审查 + ClawHub 评分 + ThreatBook 沙箱扫描
- ✅ **红旗检测** - 25+ 种恶意代码模式识别（极端/高/中/低风险）
- ✅ **智能决策** - 根据决策矩阵自动判断或询问任务下达者
- ✅ **完整流程** - 整合所有检查步骤于单一工具
- ✅ **详细报告** - 清晰的检查结果和判定依据

## 安装与配置

### 1. 获取微步在线 API Key

访问 [微步云沙箱](https://s.threatbook.com) 注册账号并获取 API Key。

### 2. 配置环境变量

```bash
# 添加到 ~/.openclaw/.env
echo 'THREATBOOK_API_KEY=your_api_key_here' >> ~/.openclaw/.env
```

### 3. 添加 Shell 别名（推荐）

```bash
# 添加到 ~/.bashrc
alias clawhub-safe='node ~/.openclaw/workspace/skills/skill-safe-install/scripts/safe-install.mjs'

# 使别名生效
source ~/.bashrc
```

## 使用方法

### 基本用法

```bash
# 使用脚本路径
node ~/.openclaw/workspace/skills/skill-safe-install/scripts/safe-install.mjs tavily-search

# 使用别名（配置后）
clawhub-safe tavily-search
```

### 选项

| 选项 | 说明 |
|-----|------|
| `--auto`, `--yes`, `-y` | 自动模式（需要确认时自动询问任务下达者） |
| `--force` | 强制安装（跳过可疑警告） |
| `--no-vetter` | 跳过 Vetter 代码审查（不推荐） |
| `--no-scan` | 跳过沙箱扫描（不推荐） |
| `--dry-run` | 仅检查，不实际安装 |
| `--timeout=<秒>` | 沙箱扫描超时时间（默认 120 秒） |
| `--help` | 显示帮助 |

### 示例

```bash
# 标准安装（三层检查）
clawhub-safe tavily-search

# 自动模式（需要确认时自动询问）
clawhub-safe some-skill --auto

# 仅检查不安装
clawhub-safe some-skill --dry-run

# 强制安装（跳过警告）
clawhub-safe risky-skill --force

# 跳过 Vetter（不推荐）
clawhub-safe trusted-skill --no-vetter

# 延长超时时间
clawhub-safe large-skill --timeout=180
```

## 安全检查流程

```
┌─────────────────────────────────────────────────────────┐
│              Skills 安全安装流程                         │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  1️⃣  Skill-Vetter 代码审查                               │
│      ├─ 检查 25+ 种红旗模式                               │
│      ├─ 评估来源信任层级                                 │
│      ├─ 极端风险 → ❌ 禁止安装                           │
│      └─ 高风险 → ❓ 询问任务下达者                        │
│                                                         │
│  2️⃣  ClawHub 评分检查                                    │
│      ├─ 评分 ≥ 3.5 → ✅ 通过，继续                       │
│      └─ 评分 < 3.5 → ❓ 询问任务下达者                    │
│                                                         │
│  3️⃣  ThreatBook 沙箱扫描                                 │
│      ├─ safe → ✅ 允许安装                              │
│      ├─ suspicious → ❓ 询问任务下达者                   │
│      ├─ malicious → ❌ 禁止安装                         │
│      └─ API 失败 → ❓ 询问任务下达者                     │
│                                                         │
│  4️⃣  执行安装                                           │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

## 判定标准

### 第一层：Skill-Vetter 代码审查

**红旗检测规则**:

| 风险等级 | 检测内容 | 操作 |
|---------|---------|------|
| **🟢 LOW** | 标准文件操作、日志记录 | ✅ 通过 |
| **🟡 MEDIUM** | 网络请求、子进程、base64 解码 | ✅ 通过，记录 |
| **🔴 HIGH** | eval()、访问记忆文件、sudo | ❓ 询问任务下达者 |
| **⛔ EXTREME** | curl\|bash、访问.ssh/.aws、危险 rm | ❌ 禁止安装 |

**信任层级**:

| 来源 | 审查级别 |
|-----|---------|
| **官方 OpenClaw** | 较低审查 |
| **已知作者** (spclaudehome, CHJ0w0) | 中等审查 |
| **未知来源** | 最高审查 |

### 第二层：ClawHub 评分检查

| 评分 | 判定 | 操作 |
|-----|------|------|
| **≥ 3.5 分** | ✅ 高评分 | 进入沙箱扫描 |
| **< 3.5 分** | ⚠️ 低评分 | ❓ 必须询问任务下达者确认 |

### 第三层：ThreatBook 沙箱扫描

| 结果 | 含义 | 操作 |
|-----|------|------|
| **safe** | 安全 | ✅ 允许安装 |
| **suspicious** | 可疑 | ❓ 必须询问任务下达者确认 |
| **malicious** | 恶意 | ❌ 禁止安装 |
| **API 失败** | 无法访问 | ❓ 必须询问任务下达者是否继续 |

### 决策矩阵

| Vetter | 评分 | 沙箱 | 最终决策 |
|-------|-----|------|---------|
| ✅ 通过 | ≥3.5 | safe | ✅ **直接安装** |
| ✅ 通过 | ≥3.5 | suspicious | ❓ **询问确认** |
| ✅ 通过 | <3.5 | 任意 | ❓ **询问确认** |
| ⚠️ 高风险 | 任意 | 任意 | ❓ **询问确认** |
| 🚨 极端风险 | 任意 | 任意 | ❌ **禁止安装** |
| 任意 | 任意 | malicious | ❌ **禁止安装** |

## 输出示例

### 成功安装

```
🛡️ 开始 Skills 安全安装流程
📋 检查 Skill: tavily-search

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第一步：Skill-Vetter 代码审查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
👤 作者：openclaw
📅 更新时间：2026-02-20
📦 版本：1.0.0

📊 信任层级评估...
✅ 官方 OpenClaw Skill - 较低审查

📄 发现 2 个脚本文件
✅ 未发现红旗

风险等级：🟢 LOW

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第二步：ClawHub 评分检查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ 评分：4.2/5.0 (高评分，通过)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第三步：ThreatBook 沙箱扫描
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📤 上传文件到沙箱...
⏳ 等待分析结果...
✅ 分析完成

📊 扫描结果:
  判定：SAFE
  威胁等级：clean
  可信度：98%

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
安全检查通过，开始安装...
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ tavily-search 安装完成！
```

### 发现极端红旗

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第一步：Skill-Vetter 代码审查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📄 发现 3 个脚本文件
⚠️ 发现 2 个潜在问题:
  🚨 Curl pipe to bash (scripts/install.sh:15)
  🚨 Accessing .ssh directory (scripts/setup.js:8)

风险等级：⛔ EXTREME

🚨 发现极端危险代码，禁止安装！

红旗列表:
  🚨 Curl pipe to bash (scripts/install.sh:15)
  🚨 Accessing .ssh directory (scripts/setup.js:8)
```

### 发现高风险（v2.0 新格式）

```
🛡️ 开始 Skills 安全安装流程 v2.0
📋 检查 Skill: some-skill

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第一步：Skill-Vetter 代码审查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📊 信任层级评估...
⚠️ 未知作者 - 最高审查

📄 发现 3 个脚本文件
⚠️ 发现 3 个潜在问题:
  🔴 Use of eval() (main.js:45)
  🔴 Accessing memory files (config.js:12)
  🟡 Network module (utils.js:5)

风险等级：🔴 HIGH

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第二步：ClawHub 评分检查
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
✅ 评分：4.2/5.0 (高评分，通过)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
第三步：ThreatBook 沙箱扫描
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📤 上传文件到沙箱...
✅ 分析完成

📊 扫描结果:
  判定：SAFE
  威胁等级：clean
  可信度：95%

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📋 复核结果摘要
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

┌─────────────────────────────────────────────────────┐
│              三层安全检查结果                       │
├─────────────────────────────────────────────────────┤
│ 1️⃣ Vetter 审查    🔴 需确认    │ 风险：HIGH      │
│ 2️⃣ ClawHub 评分   ✅ 通过      │ 评分：4.2/5.0   │
│ 3️⃣ ThreatBook     ✅ 通过      │ 结果：safe      │
└─────────────────────────────────────────────────────┘

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
🎯 最终决策
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
⚠️ 需要任务下达者确认:
   • Vetter 发现 3 个潜在问题 (high 风险)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
❓ 等待确认
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Skill: some-skill

以下问题需要您确认:
  • Vetter 发现 3 个潜在问题 (high 风险)

是否继续安装？
  输入 y 或 yes 继续，其他键取消

>
```

## 退出码

| 退出码 | 含义 |
|-------|------|
| `0` | 安装成功 |
| `1` | 检测到恶意代码，禁止安装 |
| `2` | 文件可疑，等待确认 |
| `3` | API 调用失败 |
| `4` | 评分过低，等待确认 |
| `5` | 用户取消安装 |
| `6` | Vetter 发现极端红旗 |

## 环境变量

| 变量 | 必需 | 默认值 | 说明 |
|-----|------|--------|------|
| `THREATBOOK_API_KEY` | ✅ | - | 微步在线沙箱 API Key |
| `CLAWHUB_TOKEN` | ❌ | - | ClawHub 认证 Token |

## 集成到工作流

### 方式 1：覆盖 clawhub install

在 `~/.bashrc` 中添加：

```bash
clawhub() {
  if [ "$1" = "install" ] && [ -n "$2" ]; then
    node ~/.openclaw/workspace/skills/skill-safe-install/scripts/safe-install.mjs "$2" "${@:3}"
  else
    command clawhub "$@"
  fi
}
```

这样所有 `clawhub install` 命令都会自动执行安全检查。

### 方式 2：CI/CD 集成

在自动化部署流程中使用 `--dry-run` 模式进行预检：

```yaml
# GitHub Actions 示例
- name: Security Check
  run: |
    node scripts/safe-install.mjs ${{ matrix.skill }} --dry-run
```

## 注意事项

1. **API 配额**: 免费账户有每日扫描次数限制，请合理使用
2. **分析时间**: 沙箱动态分析需要 1-2 分钟，默认超时 120 秒
3. **文件大小**: 单文件最大 100MB
4. **隐私**: 上传的文件会被微步在线分析，不要上传敏感/机密文件
5. **网络**: 需要能访问 `api.threatbook.cn` 和 ClawHub API

## 故障排除

### 问题：API Key 无效

```
⚠️ 扫描失败：Required:apikey.
```

**解决**: 检查 `THREATBOOK_API_KEY` 是否正确配置到 `~/.openclaw/.env`

### 问题：扫描超时

```
⚠️ 扫描失败：扫描超时
```

**解决**: 使用 `--timeout=180` 延长超时时间

### 问题：clawhub 命令不存在

```
/bin/sh: clawhub: command not found
```

**解决**: 确保已安装 ClawHub CLI：
```bash
npm install -g clawhub
```

## 相关文件

- `SKILL.md` - Skill 元数据和使用说明
- `README.md` - 完整文档（本文件）
- `SECURITY_PROCESS.md` - 安全流程详解
- `scripts/safe-install.mjs` - 主安装脚本

## 更新日志

### v2.0 (2026-02-28)
- 🆕 新增 `--auto` 自动模式选项（`--yes` / `-y`）
- 🔄 重构决策逻辑为决策矩阵
- 📊 统一展示三层安全检查结果摘要
- 🎨 优化输出格式和用户体验
- 🐛 改进错误处理和堆栈跟踪
- 📝 优化确认提示交互

### v1.1.0 (2026-02-28)
- 🎉 新增 Skill-Vetter 代码审查作为第一层检查
- 🎉 检测 25+ 种红旗模式（极端/高/中/低风险）
- 🎉 实现信任层级评估（官方/已知作者/未知）
- 🎉 更新决策矩阵为三层验证
- 🎉 新增退出码 6（极端红旗禁止安装）
- 🎉 添加 --no-vetter 选项（不推荐）

### v1.0.0 (2026-02-27)
- 🎉 初始版本
- ✅ 整合 ClawHub 评分检查和 ThreatBook 沙箱扫描
- ✅ 实现完整决策矩阵
- ✅ 支持自动询问任务下达者

## 许可证

MIT License

## 相关链接

- [微步在线云沙箱](https://s.threatbook.com)
- [ClawHub](https://clawhub.com)
- [OpenClaw 文档](https://docs.openclaw.ai)
- [GitHub 仓库](https://github.com/CHJ0w0/OpenClaw_Skill_safe-install)
