---
name: skill-review
version: 0.2.3
description: >
  Scrape ClawHub skill pages for Security Scan (VirusTotal/OpenClaw) + Runtime
  Requirements + Comments for all of Oliver's local skills, and write a markdown
  report.
homepage: https://github.com/odrobnik/skill-review-skill
metadata:
  openclaw:
    emoji: "🔎"
    requires:
      bins: ["python3"]
      python: ["playwright"]
      env: ["VIRUSTOTAL_API_KEY"]
---

# Skill Review (ClawHub Security Scan scraper)

Use this when you want to **review ClawHub Security Scan results** for your skills.

## What it does

- Enumerates local skills under `~/Developer/Skills` (folders that contain `SKILL.md`).
- For each skill, opens the ClawHub page `https://clawhub.ai/<owner>/<slug>`.
- Extracts:
  - Security Scan (VirusTotal status + report link, OpenClaw status/confidence/reason)
  - Runtime requirements block
  - Comments block
- Writes a single markdown report under `/tmp/`.

## Key config behavior (no surprises)

- Each local skill’s `SKILL.md` frontmatter `name:` is treated as the **ClawHub slug**.
- Supports non-standard cases via `--slug-map path/to/map.json`.

## Run

```bash
python3 scripts/skill_review.py \
  --owner odrobnik \
  --skills-dir ~/Developer/Skills \
  --out /tmp/clawhub-skill-review.md
```

### Optional: slug map

If a local folder name doesn’t match the ClawHub slug, pass a mapping file:

```json
{
  "snapmaker": "snapmaker-2"
}
```

```bash
python3 scripts/skill_review.py --slug-map ./slug-map.json
```

## Requirements

- Installs/uses Playwright internally (Python package + Chromium).
  
If it’s missing, follow the error message; typical setup:

```bash
python3 -m pip install playwright
python3 -m playwright install chromium
```
