---
name: "Skill Publish"
description: "Safely publish skills to ClawHub. Sanitize, format, verify, and publish without modifying your local files."
---

## Publish Skills Safely

Transform any knowledge into a publishable skill. Sanitize personal data, format correctly, verify before publishing.

**Key principle:** Never modify user's original files. Create clean publish-ready version separately.

**References:**
- `sanitize.md` — Security checklist and personal data removal
- `transform.md` — Convert any format to proper skill structure
- `verify.md` — Pre-publish verification process

---

### When to Use

- User wants to publish existing skill/instructions to ClawHub
- User wants to share knowledge they've developed locally
- User has content in any format that should become a public skill

### The Process

1. **Understand** — What knowledge/skill exists? Where is it?
2. **Transform** — Convert to proper skill format (see `transform.md`)
3. **Sanitize** — Remove personal/dangerous content (see `sanitize.md`)
4. **Verify** — Confirm with user before publishing (see `verify.md`)
5. **Publish** — Only after explicit approval

### Critical Rules

⚠️ **Never modify original files** — Create separate publish version
⚠️ **Never publish without sanitization** — Check `sanitize.md`
⚠️ **Never publish without user approval** — Always verify first
⚠️ **When in doubt, include more** — User can remove, harder to add later

### Asking the User

Before transforming, clarify:
- What should be PUBLIC vs kept private?
- Any specific names/references to remove?
- Target audience (beginners, experts, specific domain)?
- Desired slug/name for ClawHub?

---

**Always run `sanitize.md` checklist before any publish.**
