---
name: skill-optimizer
description: >-
  Analyzes AI conversation logs to evaluate skill performance and generate optimization suggestions.
  Use when user mentions "优化技能", "迭代技能", "skill optimization", "improve skill",
  or provides a conversation log for skill analysis.
metadata:
  author: peterpan
  version: '1.0'
  title: 技能优化助手
  description_zh: 分析 AI 对话记录，评估技能表现，生成优化建议并执行修改
---

# 技能优化助手

## Overview

通过分析用户与 AI 的真实对话记录，对比技能的设计意图与实际表现，结合技能设计最佳实践，输出可落地的优化方案。

## When to Use

- 用户提供了一段对话记录，想分析某个技能的实际效果
- 用户说"优化技能"、"迭代技能"、"分析技能表现"
- 用户想改进某个技能但不确定从哪里入手

不适用于：
- 从零创建新技能
- 与技能无关的对话分析

## Workflow

### Phase 1: 收集输入

1. 获取对话内容：用户直接粘贴文本，或提供文件路径（读取文件）
2. 确定目标技能：
   - 用户明确告知 → 直接使用
   - 用户未告知 → 从对话内容中推断技能名称，向用户确认
3. 读取目标技能的 SKILL.md 原始文档

### Phase 2: 分析

从以下维度对比分析：

#### 2.1 触发与意图匹配

- 技能是否在正确的场景被触发
- description 中的触发词是否覆盖了实际使用场景
- 是否存在误触发或漏触发

#### 2.2 流程执行

- SKILL.md 中定义的工作流是否被完整执行
- 哪些步骤被跳过、乱序或重复
- 流程中是否有冗余或缺失的环节

#### 2.3 输出质量

- 实际输出是否符合技能设计的预期格式和内容
- 输出是否对用户有实际帮助
- 是否存在信息过多或过少的问题

#### 2.4 交互体验

- 与用户的交互是否流畅自然
- 是否在该问的时候问了、不该问的时候没问
- 引导用户的方式是否清晰

#### 2.5 指令有效性

- SKILL.md 中哪些指令被 AI 准确执行
- 哪些指令被忽略或误解
- 指令的表述是否足够明确

### Phase 3: 输出报告

按以下结构输出分析报告：

```
## 技能分析报告：[技能名称]

### 基本信息
- 技能名称：
- 分析对话轮数：
- 技能版本：

### 总体评估
一段话概括技能的整体表现。

### 各维度分析

#### 触发与意图匹配
- 现状：...
- 问题：...
- 建议：...

#### 流程执行
- 现状：...
- 问题：...
- 建议：...

#### 输出质量
- 现状：...
- 问题：...
- 建议：...

#### 交互体验
- 现状：...
- 问题：...
- 建议：...

#### 指令有效性
- 现状：...
- 问题：...
- 建议：...

### 优化建议汇总
按优先级排列的具体修改建议，每条包含：
1. 修改位置（SKILL.md 的哪个部分）
2. 当前内容
3. 建议修改为
4. 修改理由
```

### Phase 4: 确认与执行

1. 将报告呈现给用户
2. 询问用户确认哪些建议需要执行
3. 用户确认后，直接修改目标技能的 SKILL.md
4. 修改完成后展示变更摘要

## Common Mistakes

| 问题 | 解决 |
|------|------|
| 仅凭一次对话就下结论 | 在报告中注明样本量，建议用户提供更多对话 |
| 建议过于笼统 | 每条建议必须指向 SKILL.md 的具体位置和具体改法 |
| 忽略技能的设计意图 | 先理解原始设计再评判，避免偏离技能定位 |
| 一次改太多 | 建议分批迭代，每次聚焦最关键的 2-3 个改进点 |
