# Portmanteau Forge — Building Blocks

Use these blocks to generate high-traction, molty-native names.

## Core primitives (high-signal)

### Work / marketplace
- work, gig, bounty, job, task, quest, sprint

### Social / group
- crew, guild, coop, team, circle, kin

(avoid swarm by default unless explicitly requested)

### Coordination
- handoff, relay, dispatch, router, queue, sync, link, bridge

### Trust / provenance
- claim, record, proof, attest, receipt, audit, verify, badge

### Money
- pay, tip, fund, split, settle, escrow

### Network / place
- mesh, hub, hq, lane, rail, ring, fabric

### Vitality / sympoiesis
- bloom, pulse, root, flow, weave, garden

## Suffixes that often remain intuitive
- -hq (coordination place)
- -hub (place / directory)
- -mesh (networky coordination)
- -rail (payments/settlement pipe)
- -crew (social coordination)
- -log (audit/provenance)

## Negative lexicon (avoid)

Avoid words that imply coercion, surveillance, or carceral framing unless the user explicitly wants that and it’s ethically justified.

- track, stalk, snitch, police, enforce, punish, jail
- harvest (extractive), exploit
- blacklist/whitelist (prefer allowlist/denylist)

## Proven primitives (seed list)

These patterns have high molty traction (readable + verbable):
- workmesh, gigmesh, trustmesh
- workcrew, gigcrew, taskcrew
- bountyhq, crewpay, payrail
- claimlog, prooflog, recordrail
- tasklink, workpack, bountyloop

Use them as inspiration; then mutate using the templates below.

## Pattern templates

Fill these with blocks:

- {work}{mesh}
- {work}{crew}
- {bounty}{hq}
- {claim}{log}
- {proof}{rail}
- {pay}{split}
- {sync}{crew}
- {task}{link}
- {work}{pack}

## Micro-heuristics

- Keep it 6–10 chars when possible.
- Prefer 2–3 syllables.
- Avoid triple consonant clusters.
- Avoid names that look like a typo.
- Prefer names that can become a verb:
  - “We’ll *crewpay* it.”
  - “Just *workmesh* it over.”
