---
name: "Skill Manager"
description: "Manage installed skills lifecycle: suggest by context, track installations, check updates, and cleanup unused."
version: "1.0.3"
changelog: "Fix contradictions: clarify declined tracking, add npx security note"
---

## Skill Lifecycle Management

Manage the full lifecycle of installed skills: discovery, installation, updates, and cleanup.

**References:**
- `suggestions.md` — when to suggest skills based on current task
- `lifecycle.md` — installation, updates, and cleanup

**Complements:**
- `skill-finder` — user-initiated search ("find me a skill for X")
- `skill-manager` — proactive lifecycle management

---

## Scope

This skill ONLY:
- Suggests skills based on current task context
- Tracks installed skills in `~/skill-manager/inventory.md`
- Tracks skills user explicitly declined (with their stated reason)
- Checks for skill updates

This skill NEVER:
- Counts task repetition or user behavior patterns
- Installs without explicit user consent
- Reads files outside `~/skill-manager/`

---

## Security Note

This skill uses `npx clawhub` commands which download and execute code from ClawHub registry. This is the standard mechanism for skill management. Always review skills before installing.

---

## Context-Based Suggestions

When working on a task, notice the **current context**:
- User mentions specific tool (Stripe, AWS, GitHub) → check if skill exists
- Task involves unfamiliar domain → suggest searching

This is responding to current context, not tracking patterns.

## Lifecycle Actions

| Action | Command |
|--------|---------|
| Install | `npx clawhub install <slug>` |
| Update | `npx clawhub update <slug>` |
| Info | `npx clawhub info <slug>` |
| Remove | `npx clawhub uninstall <slug>` |

---

## Memory Storage

Inventory at `~/skill-manager/inventory.md`.

**First use:** `mkdir -p ~/skill-manager`

**Format:**
```markdown
## Installed
- slug@version — purpose — YYYY-MM-DD

## Declined
- slug — "user's stated reason"
```

**What is tracked:**
- Skills user installed (with purpose and date)
- Skills user explicitly declined (with their stated reason)

**Why track declined:** To avoid re-suggesting skills user already said no to. Only stores what user explicitly stated.
