---
name: clawhub
description: Install, search, update, and manage skills from ClawHub (the public OpenClaw skill registry). Use when the user wants to install a skill by slug (e.g. "clawhub install summarize"), search for skills, update installed skills, or manage ClawHub skills in any way.
---

# ClawHub Skill Manager

Install and manage skills from [ClawHub](https://clawhub.ai), the public skill registry for OpenClaw.

## Prerequisites

The `clawhub` CLI must be available on PATH. Verify with `which clawhub`. If missing, ask the user to install it manually:

```bash
npm i -g clawhub
```

Do not auto-install without user confirmation.

## Commands

### Install a skill

```bash
cd ~/.openclaw/workspace && clawhub install <slug>
```

- `<slug>` is the skill identifier from ClawHub (e.g. `summarize`, `weather`, `coding-agent`)
- Skills are installed into `./skills/` under the workspace
- A new OpenClaw session is needed to pick up the skill

### Search for skills

```bash
clawhub search "<query>"
```

### Update skills

```bash
# Update a specific skill
clawhub update <slug>

# Update all installed skills
clawhub update --all
```

### Other useful commands

```bash
clawhub info <slug>       # Show skill details
clawhub list              # List installed skills
clawhub --help            # Full CLI reference
```

## Workflow

1. Ensure `clawhub` CLI is installed (check with `which clawhub`, install if missing)
2. `cd` to the workspace directory: `~/.openclaw/workspace`
3. Run the appropriate `clawhub` command
4. Inform the user to start a new session (or restart gateway) for the skill to take effect

## Installing via WhatsApp

Users can install skills by messaging the OpenClaw agent on WhatsApp:

```
clawhub install <slug>
```

Example: `clawhub install summarize`

The agent will handle CLI installation and confirm when the skill is ready.

## Notes

- All ClawHub skills are public and open
- Treat third-party skills as untrusted — review before enabling
- Workspace skills (`<workspace>/skills/`) take highest precedence over managed and bundled skills
