# 📊 Skill Dashboard - 技能可视化控制台

**像 360 软件管家一样管理你的 AI 技能**

---

## 🚀 快速开始

### **安装**

```bash
clawhub install skill-dashboard
```

### **使用**

说以下任意触发词：

- "技能控制台"
- "我装了哪些技能？"
- "技能列表"
- "技能状态"
- "/skills"

---

## 📋 功能

### **1. 分页显示**

每次显示 5 个技能，避免刷屏。

```
📊 技能控制台 (1/5) 🌐

✅ Smart Router v1.3.2
   自动压缩（被动生效）
   [详情] [禁用] [卸载]

这 5 个技能有没有问题？
要不要看下 5 个？（回复"是"或"不用"）
```

### **2. 地球图标**

点击右上角 🌐 直达 ClawHub 技能主页。

### **3. 技能管理**

- **更新**：检测新版本，一键更新
- **卸载**：二次确认，安全卸载
- **启用/禁用**：临时禁用，随时恢复

---

## ⚠️ 安全约束

### **1. 绝不刷屏**

只有用户明确询问时才显示。

### **2. 拦截 raw 输出**

所有命令输出转化为自然语言。

### **3. 二次确认**

更新/卸载操作需要用户确认。

---

## 📁 文件结构

```
skill-dashboard/
├── SKILL.md              # 技能定义
├── dashboard.js          # 主逻辑
├── pagination.js         # 分页逻辑
├── skill-state.json      # 状态缓存
└── commands/             # 命令处理
    ├── update.js         # 更新命令
    ├── uninstall.js      # 卸载命令
    └── toggle.js         # 启用/禁用命令
```

---

## 📝 更新日志

### **v1.0.0（2026-02-26）**

- ✅ 初始版本
- ✅ 分页显示（每次 5 个）
- ✅ 地球图标 + ClawHub 链接
- ✅ 人性化询问机制
- ✅ 更新/卸载/启用禁用按钮
- ✅ 安全约束（拦截 raw 输出、二次确认）

---

## 🫂 致谢

**产品洞察：** Commander（墨菲斯）  
**战略建议：** 大 G  
**技术审批：** 工程师 Grok  
**开发者：** Neo（宇宙神经系统）

**产品定位：** AI 技能领域的"360 软件管家"

---

*版本：2.0.1*  
*创建时间：2026-02-26*  
*许可证：MIT*
