---
name: skill-auditor
version: 2.1.1
description: Security scanner for ClawHub skills. Detects malicious code, obfuscated payloads, and social engineering before installation. Three-layer analysis: pattern matching, deobfuscation, and LLM intent analysis.
author: sypsyp97
---

# Skill Auditor 🔍

Audit ClawHub skills for security threats before installing them.

## Triggers

Use this skill when:
- "Audit this skill"
- "Check skill security"
- Before installing any third-party skill

## Usage

### Method 1: Pre-install audit (recommended)

```bash
# Inspect without installing
clawhub inspect <skill-name>

# Run the audit script
~/.openclaw/workspace/skills/skill-auditor/scripts/audit.sh <skill-name>
```

### Method 2: Audit an installed skill

```bash
~/.openclaw/workspace/skills/skill-auditor/scripts/audit.sh --local <skill-path>
```

## Detection Layers

### L1: Pattern Matching

| Severity | Pattern | Risk |
|----------|---------|------|
| 🔴 High | `base64.*\|.*bash` | Encoded execution |
| 🔴 High | `curl.*\|.*bash` | Remote script execution |
| 🔴 High | `eval\(` / `exec\(` | Dynamic code execution |
| 🔴 High | Known C2 server IPs | Malicious communication |
| 🟡 Medium | Access to `~/.openclaw/` | Config theft |
| 🟡 Medium | Reads `$API_KEY` etc. | Credential leakage |
| 🟡 Medium | Social engineering keywords | User deception |
| 🟢 Low | Requires sudo | Elevated privileges |

### L2: Deobfuscation

Automatically decodes hidden malicious payloads:
- **Base64** — Decodes and scans for hidden commands
- **Hex** — Decodes `\x41\x42` format strings
- Checks decoded content for C2 servers and dangerous commands

### L3: LLM Analysis (optional)

Uses Gemini CLI to analyze suspicious code intent:
- Semantic understanding beyond pattern matching
- Detects novel/unknown threats
- Requires `gemini` CLI installed

## Known Indicators of Compromise (IoC)

### C2 Server IPs
```
91.92.242.30  # ClawHavoc primary server
```

### Malicious Domains
```
glot.io       # Hosts obfuscated scripts
webhook.site  # Data exfiltration endpoint
```

### Social Engineering Keywords
```
OpenClawDriver    # Non-existent "driver"
ClawdBot Driver   # Social engineering lure
Required Driver   # Tricks users into installing malware
```

## Output Format

```
═══════════════════════════════════════════
  SKILL AUDIT REPORT: <skill-name>
═══════════════════════════════════════════

🔴 HIGH RISK FINDINGS:
   [LINE 23] base64 encoded execution detected
   [LINE 45] curl|bash pattern found

🟡 MEDIUM RISK FINDINGS:
   [LINE 12] Accesses ~/.openclaw/ directory

🟢 LOW RISK FINDINGS:
   [LINE 5] Requires sudo for installation

═══════════════════════════════════════════
  VERDICT: ❌ DO NOT INSTALL
═══════════════════════════════════════════
```

## Best Practices

1. **Always audit before install** — Never skip the security check
2. **Trust no skill blindly** — Including highly starred or popular ones
3. **Check updates** — Skill updates may introduce malicious code
4. **Report suspicious skills** — Send to steipete@gmail.com

## Maintenance

**Update this skill when new threats are discovered:**

1. New malicious IP → Add to `MALICIOUS_IPS`
2. New malicious domain → Add to `MALICIOUS_DOMAINS`
3. New social engineering lure → Add to `SOCIAL_ENGINEERING`
4. New attack pattern → Add regex detection

Update location: variable definitions at the top of `scripts/audit.sh`

## References

- [341 Malicious ClawHub Skills Incident](https://thehackernews.com/2026/02/researchers-find-341-malicious-clawhub.html)
- [OpenClaw Security Guide](https://docs.openclaw.ai/gateway/security)
