# Hats Deep Dive — Six Thinking Hats

## White Hat: Facts and Information

**Focus:** Objective data only
**Mode:** Neutral, factual

### Questions to Ask
- What information do we have?
- What information is missing?
- How reliable is our data?
- What would we need to know?

### Output Style
- Bullet points of facts
- Clear "known" vs "unknown" sections
- Sources where applicable
- No interpretation or opinion

### Common Mistakes
- Including opinions disguised as facts
- Ignoring inconvenient data
- Not identifying what's missing

---

## Red Hat: Emotions and Intuition

**Focus:** Feelings, hunches, gut reactions
**Mode:** Personal, intuitive

### Questions to Ask
- How do I feel about this?
- What's my gut saying?
- What's my immediate reaction?
- Any hunches I can't explain?

### Output Style
- Brief, direct statements
- "I feel..." not "I think because..."
- No justification required
- 30 seconds max

### Common Mistakes
- Trying to justify feelings
- Dismissing intuition as irrational
- Spending too long analyzing emotions

---

## Black Hat: Caution and Risks

**Focus:** Critical thinking, what could go wrong
**Mode:** Cautious but constructive

### Questions to Ask
- What could go wrong?
- What are the risks?
- What obstacles exist?
- Why might this fail?

### Output Style
- List of specific risks
- Likelihood and impact where possible
- Factual concerns, not negativity
- Paired with potential mitigations

### Common Mistakes
- Being negative instead of critical
- Using it to kill ideas instead of improve them
- Not pairing with Yellow hat

---

## Yellow Hat: Benefits and Value

**Focus:** Optimism, advantages, best case
**Mode:** Positive, constructive

### Questions to Ask
- What are the benefits?
- What value does this create?
- What's the best case scenario?
- Why might this work?

### Output Style
- List of advantages
- Value propositions
- Positive outcomes
- Reasons for optimism

### Common Mistakes
- Unrealistic optimism
- Ignoring obvious problems
- Not being specific about benefits

---

## Green Hat: Creativity and Alternatives

**Focus:** New ideas, possibilities, alternatives
**Mode:** Creative, generative

### Questions to Ask
- What else is possible?
- What alternatives exist?
- How might we do this differently?
- What if we tried...?

### Output Style
- Multiple options (minimum 3)
- No judgment yet
- Build on others' ideas
- Quantity first, quality later

### Common Mistakes
- Judging ideas too early
- Settling for first idea
- Not pushing past obvious options

---

## Blue Hat: Process and Control

**Focus:** Managing the thinking process
**Mode:** Meta, organizational

### Questions to Ask
- What's our goal here?
- Which hat should we use next?
- What have we learned so far?
- What's the conclusion?

### Output Style
- Clear summaries
- Process decisions
- Next steps
- Final recommendations

### Common Mistakes
- Skipping the summary
- Not defining the problem clearly
- Forgetting to conclude

---

## Alternative Sequences

### For New Ideas
1. Blue (frame)
2. Green (generate)
3. Yellow (find value)
4. Black (find risks)
5. White (check facts)
6. Blue (decide)

### For Problem Solving
1. Blue (define problem)
2. White (gather data)
3. Black (identify causes)
4. Green (solutions)
5. Yellow (evaluate)
6. Blue (conclude)

### For Quick Decisions
1. Blue (frame)
2. White + Yellow + Black (rapid assessment)
3. Red (gut check)
4. Blue (decide)
