# Siri Commands Reference

## Communication
- "Call [name]" / "FaceTime [name]" / "FaceTime Audio [name]"
- "Send a message to [name]: [content]"
- "Read my messages"
- "Reply [message]"
- "Send an email to [name] about [subject]"

## Timers, Alarms, Reminders
- "Set a timer for [duration]"
- "Set an alarm for [time]" / "Wake me up at [time]"
- "Cancel my [time] alarm"
- "Remind me to [task] at [time/location]"
- "Show my reminders"
- "What's on my calendar today?"
- "Schedule [event] for [date] at [time]"

## Music & Media
- "Play [song/artist/playlist]"
- "Play something I like"
- "Skip this song" / "Pause" / "Resume"
- "What song is this?"
- "Play [podcast] podcast"
- "Set volume to [percent]"
- "Play [show] on [Netflix/Apple TV]"

## Information
- "What's the weather?"
- "How's traffic to [location]?"
- "Navigate to [destination]"
- "What time is it in [city]?"
- "Convert [amount] [currency] to [currency]"
- "How much is [calculation]?"
- "Translate [phrase] to [language]"
- "Define [word]"
- "Search for [query]"

## Device Control
- "Turn on Do Not Disturb"
- "Set brightness to [percent]"
- "Take a selfie" (opens camera, countdown)
- "Turn on flashlight"
- "Open [app]"
- "Take a screenshot"

## Productivity
- "Create a note: [content]"
- "Add [item] to my shopping list"
- "Show me my photos from [date/location]"
- "Find my iPhone" (requires Find My setup)

## Discovery Commands
- "What can you do?"
- "What can I do here?"
- "What can I do with [app name]?"

---

## Tips for Natural Commands

**Being Specific Helps:**
- ❌ "Text John" → Which John?
- ✅ "Text John Smith"

**Add Context:**
- ❌ "Set an alarm"
- ✅ "Set an alarm for 7 AM tomorrow"

**Chaining Usually Fails:**
- ❌ "Turn off lights and play music and lock the door"
- ✅ Create a Shortcut for multi-step sequences

---

## CarPlay & AirPods

**CarPlay:**
- Siri activates with steering wheel button
- Maps commands: "Take me home", "Find gas stations"
- "Hey Siri" available when enabled on phone

**AirPods:**
- "Hey Siri" works hands-free with AirPods Pro/Max
- Squeeze stem (AirPods Pro) or tap (AirPods Max) to activate
- Announce notifications: Settings > Siri > Announce Notifications

---

## Voice Settings

**Change Siri Voice:**
Settings > Siri & Search > Siri Voice > Select variety and voice

**Languages:**
- Siri supports 20+ languages
- Can set different language than device language
- Some features limited to English (US)

**Type to Siri:**
Settings > Accessibility > Siri > Type to Siri

**Siri History:**
Settings > Siri & Search > Siri & Dictation History > Delete
