# Singapore Visitor Tips

> Practical advice for visiting Singapore. Day trips, weather, transport, etiquette, and everything you need to know. Updated 2025-2026.

---

## ESSENTIAL QUICK FACTS

| Item | Details |
|------|---------|
| **Currency** | Singapore Dollar (SGD/S$). 1 USD ≈ S$1.35 |
| **Language** | English widely spoken (official), plus Mandarin, Malay, Tamil |
| **Voltage** | 230V, UK-style 3-pin plugs (Type G) |
| **Time Zone** | SGT (UTC+8), no daylight saving |
| **Emergency** | Police: 999, Ambulance/Fire: 995 |
| **Tipping** | NOT expected (service charge often included) |
| **Water** | Tap water is safe to drink |
| **SIM Card** | Available at airport, ~S$15-20 for tourist SIM |

---

## BEST TIME TO VISIT

### Climate Overview
Singapore has NO seasons - it's hot and humid year-round:
- **Temperature:** 25-34°C (77-93°F) daily
- **Humidity:** 70-90%
- **Rainfall:** Possible any day, usually brief heavy showers

### Monthly Breakdown

| Period | Weather | Crowds | Events | Verdict |
|--------|---------|--------|--------|---------|
| **Dec-Jan** | Monsoon (more rain) | VERY HIGH | Christmas, CNY | ❌ Most expensive |
| **Feb-Mar** | Post-monsoon | Medium | Chingay Parade | ✅ Good shoulder |
| **Apr-May** | Dry-ish | Medium | - | ✅ Good value |
| **Jun-Jul** | School holidays | HIGH | Great Sale | ❌ Crowded |
| **Aug-Oct** | Dry, possible haze | Medium | F1 (Sep) | ✅ Best weather |
| **Nov** | Pre-monsoon | Low-Medium | Deepavali | ✅ Great choice |

### Best Months Overall
**February-March** and **October-November** - Lower crowds, reasonable weather, good prices.

### Avoid If Possible
- **Chinese New Year** (late Jan/early Feb) - Many shops closed, prices spike
- **F1 Weekend** (September) - Hotels 2-3x normal price
- **June-July school holidays** - Everything crowded

### Haze Season (May-October)
Forest fires in Indonesia can cause haze. Check [haze.gov.sg](https://www.haze.gov.sg/) for PSI readings:
- PSI 0-50: Good
- PSI 51-100: Moderate
- PSI 101-200: Unhealthy - limit outdoor activities
- PSI 200+: Very unhealthy - stay indoors

---

## DEALING WITH HEAT & HUMIDITY

### The Reality
Singapore's heat is BRUTAL for visitors from temperate climates. 32°C with 85% humidity feels like 40°C+.

### Survival Tips
1. **Schedule around heat:**
   - Outdoor activities: Before 10am or after 5pm
   - Midday: Museums, malls, conservatories
   
2. **Stay hydrated:**
   - Carry water bottle everywhere (free refills at many attractions)
   - Avoid alcohol during hot hours (dehydrates)
   - Electrolyte drinks available at 7-Eleven

3. **Dress appropriately:**
   - Light, breathable fabrics (cotton, linen)
   - Light colors
   - Comfortable walking shoes (you'll walk A LOT)
   - NO jeans in daytime heat

4. **Sun protection:**
   - Umbrella (doubles for rain)
   - Sunscreen SPF 50+
   - Hat or cap

5. **Cool down spots:**
   - Any mall (free AC)
   - MRT stations
   - Libraries
   - Conservatories at Gardens by the Bay

6. **Portable fans:**
   - Sold everywhere (S$5-20)
   - Lifesaver in outdoor attractions

### Heat Exhaustion Signs
- Dizziness, headache, nausea
- Excessive sweating then sudden stop
- **What to do:** Get to AC, drink water, sit down. Seek medical help if severe.

---

## GETTING AROUND

### MRT (Mass Rapid Transit) ⭐⭐⭐⭐⭐
**The best way to get around Singapore.**

- **Hours:** ~5:30am to midnight (varies by line)
- **Cost:** S$1-3 per trip depending on distance
- **Payment:**
  - Contactless credit/debit card (just tap)
  - SimplyGo (mobile app)
  - EZ-Link card (S$10 with S$5 stored value)
  - Singapore Tourist Pass (unlimited rides)

**Tourist Pass Options:**
| Pass | Price | Validity |
|------|-------|----------|
| 1-day | S$22 | 24 hours |
| 2-day | S$29 | 48 hours |
| 3-day | S$34 | 72 hours |

*Includes unlimited MRT + buses. Worth it if doing 4+ trips/day.*

**MRT Tips:**
- Download "CitiMapper" or "MyTransport.SG" app
- Peak hours (7:30-9am, 5:30-7:30pm) = sardine can
- Stand on left of escalators, walk on right
- No eating, drinking, or durians allowed
- Fines for violations actually enforced (S$500!)

### Buses
- Same payment as MRT
- Useful for areas MRT doesn't reach
- Download bus app for routes
- Board at front, exit at rear

### Grab (Southeast Asia's Uber) ⭐⭐⭐⭐
- Download Grab app before arriving
- Payment: Credit card or cash
- Usually cheaper than taxis
- Also has GrabFood for delivery

**Typical Grab costs:**
- Airport to Marina Bay: S$25-35
- Orchard to Sentosa: S$15-25
- Cross-city: S$15-30

### Taxis
- Metered, reliable, safe
- Flag down on street or taxi stands
- Additional charges: peak hour, CBD, midnight, airport
- **Comfort/CityCab:** Largest fleet, can book via app

### Walking
- Singapore is walkable but HOT
- Underground tunnels connect many malls/MRT
- Pedestrian bridges over major roads

### Sentosa Express
- Monorail from VivoCity to Sentosa
- S$4 per trip
- Alternative: FREE walk via boardwalk (10-15 min)

---

## MONEY MATTERS

### Currency Exchange
- **Best rates:** Change Alley (Raffles Place), Lucky Plaza, Mustafa Centre
- **Avoid:** Airport changers (worst rates)
- **ATMs:** Everywhere, most accept international cards

### Payment Methods
1. **Contactless cards** - Widely accepted, even hawker centres now
2. **Cash** - Still useful for small hawker stalls, markets
3. **Mobile payments** - PayNow, GrabPay common locally
4. **Apple/Google Pay** - Works at most places

### Typical Costs (2025-2026)

| Item | Cost (SGD) |
|------|------------|
| Hawker meal | S$4-8 |
| Café coffee | S$5-8 |
| Restaurant meal | S$20-50 |
| Fine dining | S$100-300+ |
| Bottle of water | S$1-2 |
| Beer (hawker) | S$8-12 |
| Beer (bar) | S$15-25 |
| Cocktail | S$20-30 |
| MRT single trip | S$1-3 |
| Grab 10km | S$15-25 |

### Budget Daily Estimates
- **Backpacker:** S$80-120/day (hostel, hawker food, free attractions)
- **Mid-range:** S$200-350/day (3-star hotel, mix of hawker/restaurant, paid attractions)
- **Luxury:** S$500+/day (5-star hotel, fine dining, premium experiences)

### Tipping Culture
**TIPPING IS NOT EXPECTED IN SINGAPORE**
- Most restaurants add 10% service charge + 7% GST
- Taxi drivers don't expect tips (rounding up is fine)
- Hotel porters: Optional S$2-5 per bag
- Hawker centres: Never tip

### Tax Refunds (GST)
- 8% GST on most purchases (9% from 2024)
- Tourist refund available for purchases S$100+ at participating stores
- Claim at airport before departure
- Look for "Tax Free Shopping" signs

---

## HAWKER CENTRE ETIQUETTE

### The Basics
1. **Find a seat first** - Use tissue packet to "chope" (reserve) seat
2. **Order from multiple stalls** - Each stall is different vendor
3. **Tell them your table number** - Food delivered to you
4. **Pay at collection** - Cash or card at each stall
5. **Return trays** - Designated areas (fines for not doing so)

### Ordering Tips
- Point at photos if language barrier
- "Less spicy" / "No chili" - Specify clearly
- "Takeaway" vs "Here" - Say "ta bao" for takeaway

### What to Try
| Dish | Description | Price |
|------|-------------|-------|
| **Hainanese Chicken Rice** | THE national dish | S$4-6 |
| **Char Kway Teow** | Fried flat noodles with cockles | S$4-6 |
| **Laksa** | Spicy coconut curry noodle soup | S$5-7 |
| **Roti Prata** | Indian flatbread with curry | S$2-4 |
| **Satay** | Grilled meat skewers | S$0.80-1 each |
| **Chili Crab** | Singapore's famous dish | S$50-100 |
| **Kaya Toast** | Coconut jam toast + soft eggs | S$3-5 |
| **Nasi Lemak** | Coconut rice with sambal | S$4-6 |
| **Bak Kut Teh** | Peppery pork rib soup | S$7-12 |
| **Ice Kachang** | Shaved ice dessert | S$3-5 |

### Best Hawker Centres
1. **Maxwell Food Centre** - Chinatown, tourist-friendly
2. **Old Airport Road** - Local favorite, huge variety
3. **Tekka Centre** - Little India, best Indian food
4. **Lau Pa Sat** - CBD, satay street at night
5. **Chomp Chomp** - Serangoon, evening BBQ vibes

---

## DAY TRIPS FROM SINGAPORE

### Johor Bahru, Malaysia 🇲🇾
**Distance:** 1-2 hours (including border crossing)
**Why go:** Cheap shopping, cheap food, cheap massages

**Getting there:**
1. **Bus from Queen Street Terminal** - S$3-5, most common
2. **Taxi/Grab** - S$50-70, faster for small groups
3. **Train from Woodlands** - S$5, scenic but less convenient

**What to know:**
- Bring passport (immigration both ways)
- Weekend mornings = MASSIVE queues (2-3 hours)
- Best times: Tuesday-Thursday
- Malaysian ringgit (RM) needed - exchange in JB, not Singapore
- 1 SGD ≈ 3.5 RM (things feel 3x cheaper!)

**What to do:**
- KSL City Mall - shopping, food
- JB City Square - directly at customs
- Old town - heritage walk, Hiap Joo Bakery
- Spa/massage - S$20 gets excellent 2-hour treatment

### Batam, Indonesia 🇮🇩
**Distance:** 1 hour ferry from HarbourFront
**Why go:** Beach resorts, seafood, spas, golf

**Getting there:**
- Ferries every 30-60 minutes
- Round-trip: S$40-60
- Book at terminal or online (Batamfast, Sindo Ferry)

**What to know:**
- Visa-free for most nationalities
- Indonesian rupiah needed (ATMs available)
- 1 SGD ≈ 11,000 IDR
- Book resort packages for best value

**What to do:**
- Nagoya Hill shopping
- Seafood restaurants (fraction of Singapore prices)
- Spa resorts
- Golf courses

### Bintan, Indonesia 🇮🇩
**Distance:** 1 hour ferry from Tanah Merah
**Why go:** Proper beach resort experience

**Getting there:**
- Bintan Resort Ferries from Tanah Merah
- Round-trip: S$60-80
- Book ferry + resort package

**What to know:**
- More upscale than Batam
- Several international resort chains
- Good for golf, water sports

### Malacca, Malaysia 🇲🇾
**Distance:** 4-5 hours by bus
**Why go:** UNESCO heritage city, amazing food, Portuguese history

**Getting there:**
- Bus from Golden Mile Complex (S$20-30 one-way)
- Can do as very long day trip or overnight

**What to do:**
- Jonker Street night market
- A Famosa fort
- Peranakan heritage museums
- Nyonya food

### Desaru, Malaysia 🇲🇾
**Distance:** 2-3 hours by car/bus
**Why go:** Beach resort, much nicer beaches than Singapore

**Getting there:**
- Grab/taxi to Desaru (S$80-120)
- Or bus + ferry combination

---

## SINGAPORE LAWS & CUSTOMS

### Things That Are ILLEGAL
(Yes, they enforce these)

| Offense | Fine |
|---------|------|
| Littering | S$300 first offense, up to S$1,000 |
| Jaywalking | S$50 |
| Eating/drinking on MRT | S$500 |
| Smoking in prohibited areas | S$1,000 |
| Chewing gum (importing) | S$100,000 or 2 years jail |
| E-cigarettes/vaping | Prohibited entirely |
| Drugs | DEATH PENALTY for trafficking |
| Vandalism | Caning + jail |
| Feeding pigeons | S$500 |

### Seriously About Drugs
Singapore has ZERO tolerance. Trafficking can result in mandatory death sentence. Even small amounts of cannabis = prison. This applies to transit passengers too. If you have traces in your system, you can be tested and prosecuted.

### Smoking Rules
- Prohibited in all indoor spaces
- Prohibited in outdoor dining areas
- Prohibited within 5m of building entrances
- Look for designated smoking areas (yellow boxes)

### Alcohol Laws
- Legal drinking age: 18
- No alcohol sales: 10:30pm-7am (retail)
- Public drinking banned in some areas after 10:30pm
- Liquor Control Zones (Geylang, Little India) - extra restrictions

### LGBTQ+ Visitors
- Singapore decriminalized gay sex in 2022
- Generally tolerant but conservative society
- Pride events exist but low-key
- Same-sex relationships not legally recognized
- Public displays of affection may draw stares

### Dress Code
- Generally casual but modest
- Cover shoulders/knees for temples and mosques
- Some upscale restaurants require smart casual
- Clubs may have dress codes (no sandals/shorts)

---

## CULTURAL ETIQUETTE

### General Manners
- Remove shoes before entering homes
- Use right hand for giving/receiving (especially with Muslims/Indians)
- Don't point with your finger - use whole hand
- "Face" is important - don't embarrass people publicly
- Queuing is sacred - never cut lines

### At Temples & Mosques
- Remove shoes
- Dress modestly (cover shoulders and knees)
- Mosque: Women should cover head
- Hindu temples: Don't touch statues
- Photography usually OK but ask first

### Dining Etiquette
- Communal dishes are normal - use serving spoons
- Don't stick chopsticks upright in rice (funeral symbol)
- Slurping noodles is acceptable
- It's polite to leave a small amount on plate

### Business Culture
(If you're there for work)
- Exchange business cards with two hands
- Punctuality valued
- Conservative dress expected
- Hierarchy respected

---

## PRACTICAL TIPS

### Communication
- **Wi-Fi:** Free at most malls, cafes, and attractions
- **Tourist SIM:** S$15-20 at airport, 100GB data for 7-15 days
- **eSIM:** Airalo, Holafly work well

### Useful Apps
| App | Purpose |
|-----|---------|
| Grab | Ride-hailing, food delivery |
| Google Maps | Navigation (works well here) |
| MyTransport.SG | Public transport |
| Singapo | Official tourist app |
| Klook | Attraction tickets & tours |
| Burpple | Restaurant discovery |

### Toilets
- Generally clean and free
- MRT stations have toilets
- Shopping malls have excellent facilities
- Hawker centres - varies, usually acceptable

### Electricity
- 230V, 50Hz
- UK-style Type G plugs (3 rectangular pins)
- Bring adapter if coming from US/EU
- Available at electronics shops if forgotten

### Health & Safety
- **Hospitals:** Excellent healthcare (but expensive for foreigners)
- **Pharmacy:** Guardian, Watsons everywhere
- **Travel insurance:** HIGHLY recommended
- **Common issues:** Heat exhaustion, food sensitivity
- **Mosquitoes:** Dengue exists - use repellent

### Water
**Tap water is safe to drink** - Singapore has excellent water treatment. Save money by refilling bottles.

### Shopping Tips
- **GST refund:** Available for purchases over S$100
- **Great Singapore Sale:** June-August
- **Bargaining:** Only at markets, not fixed-price stores
- **Fake goods:** Illegal and raids happen

---

## AIRPORT TIPS (Changi)

### Arrival
1. Complete SG Arrival Card online (up to 3 days before)
2. Use automated immigration gates (foreigners eligible)
3. No more passport stamps - digital entry

### Getting to City
| Method | Time | Cost |
|--------|------|------|
| MRT | 45-60 min | S$2-3 |
| Bus | 60-90 min | S$2-3 |
| Taxi | 25-40 min | S$25-40 |
| Grab | 25-40 min | S$25-40 |
| Airport Shuttle | 30-45 min | S$10 |

### Jewel Changi (Don't Miss!)
- Connected to Terminal 1
- World's tallest indoor waterfall
- Shopping, dining, activities
- Free to visit (paid attractions extra)
- Perfect way to spend pre-flight time

### Departure Tips
- Arrive 3 hours early for international flights
- Automated check-in/bag drop at most terminals
- Great duty-free shopping
- Excellent lounges (Priority Pass accepted)

---

## EMERGENCY CONTACTS

| Service | Number |
|---------|--------|
| Police | 999 |
| Ambulance / Fire | 995 |
| Non-emergency Police | 1800-255-0000 |
| Tourist Hotline | 1800-736-2000 |
| Hospital (SGH) | 6222-3322 |
| Lost passport (UK) | 6424-4200 |
| Lost passport (US) | 6476-9100 |

---

## QUICK REFERENCE CARD

```
ESSENTIAL PHRASES (Not really needed - everyone speaks English!)
Hello: Hello / Ni hao / Selamat
Thank you: Thank you / Xie xie / Terima kasih
How much?: How much? / Duo shao qian?
Delicious!: Shiok! (Singlish)
Can discount?: Can cheaper?
No spicy: No spicy / Bu yao la

COMMON SINGLISH
Lah - Emphasis (Don't worry lah)
Can - Yes (Can or not? Can.)
Shiok - Awesome/delicious
Kiasu - Afraid to lose out
Chope - Reserve (seat with tissue)
Makan - Eat
Ta bao - Takeaway
```

---

*Last updated: February 2026*
