# Singapore Itineraries

> Optimized itineraries for 1, 3, and 7 days. Designed around Singapore's heat - outdoor activities in morning/evening, air-conditioned attractions during peak afternoon heat.

## Important: Beat the Heat Strategy

Singapore is HOT (31-34°C / 88-93°F) and HUMID (80%+) year-round. The heat is exhausting, especially 11am-4pm.

**Golden Rules:**
- **6:00-10:00am** → Outdoor activities (gardens, walks, nature)
- **10:00am-5:00pm** → Air-conditioned attractions (museums, malls, conservatories)
- **5:00-10:00pm** → Outdoor activities (cultural districts, hawkers, light shows)
- **Always carry:** Water bottle, umbrella (sun/rain), portable fan

---

## 1-DAY ITINERARY: Singapore Highlights

*Best for: Layovers, quick visits. See the iconic essentials.*

### Morning (6:30am - 10:30am)
**MARINA BAY AREA**

| Time | Activity | Details |
|------|----------|---------|
| 6:30am | Gardens by the Bay (outdoor) | Arrive early before heat. Walk Supertree Grove, Heritage Gardens |
| 8:00am | Breakfast | Maxwell Food Centre (MRT: Chinatown) - chicken rice, kaya toast |
| 9:30am | Merlion Park | Quick photos with the icon |
| 10:00am | Marina Bay Sands SkyPark | Buy tickets online. 360° views |

### Midday (11:00am - 4:00pm)
**ESCAPE THE HEAT**

| Time | Activity | Details |
|------|----------|---------|
| 11:00am | Gardens by the Bay Conservatories | Cloud Forest + Flower Dome (air-conditioned, stunning) |
| 1:30pm | Lunch | SuperTree dining or Marina Bay Sands food court |
| 2:30pm | Choice: | **Option A:** Shopping at Marina Bay Sands mall |
| | | **Option B:** ArtScience Museum |
| | | **Option C:** National Gallery Singapore |

### Evening (5:00pm - 10:00pm)
**CULTURE & LIGHTS**

| Time | Activity | Details |
|------|----------|---------|
| 5:00pm | Chinatown | Buddha Tooth Relic Temple, street exploration |
| 6:30pm | Dinner | Chinatown hawker centre or street food |
| 7:45pm | Supertree Light Show | Garden Rhapsody (FREE) |
| 8:30pm | Clarke Quay | Singapore River walk, evening drinks |
| 9:00pm | Spectra Light Show | Marina Bay waterfront (FREE, Fri-Sat also 10pm) |

**Total cost estimate:** S$60-100 (excluding meals/shopping)

---

## 3-DAY ITINERARY: Essential Singapore

*The sweet spot for first-time visitors. Covers all must-sees without rushing.*

### DAY 1: Marina Bay & Gardens

#### Morning (7:00am - 10:30am)
| Time | Activity | Notes |
|------|----------|-------|
| 7:00am | Singapore Botanic Gardens | UNESCO site, peaceful morning walk. National Orchid Garden opens 8:30am (S$5) |
| 9:00am | Breakfast | Nearby: Adam Road Food Centre for nasi lemak, or in gardens at Casa Verde |
| 10:00am | MRT to Marina Bay | Bayfront station |
| 10:30am | Marina Bay Sands SkyPark | Pre-booked tickets recommended |

#### Midday (11:30am - 5:00pm)
| Time | Activity | Notes |
|------|----------|-------|
| 11:30am | Gardens by the Bay | Cloud Forest first (waterfall!), then Flower Dome |
| 2:00pm | Lunch | Satay by the Bay hawker centre within gardens |
| 3:00pm | OCBC Skyway | Walk between Supertrees |
| 3:30pm | Free time | Hotel rest, mall browse, or Helix Bridge walk |

#### Evening (5:30pm - 10:00pm)
| Time | Activity | Notes |
|------|----------|-------|
| 5:30pm | Merlion Park | Photos in golden hour light |
| 6:30pm | Clarke Quay | Singapore River stroll |
| 7:00pm | Dinner | Boat Quay restaurants or Jumbo Seafood (chili crab!) |
| 7:45pm | Garden Rhapsody | Light show at Supertrees |
| 9:00pm | Spectra | Marina Bay light & water show |

### DAY 2: Sentosa Island

#### Morning (9:00am - 12:00pm)
| Time | Activity | Notes |
|------|----------|-------|
| 9:00am | Cable car to Sentosa | From Mount Faber or HarbourFront. Book round-trip (S$35) |
| 9:30am | **Choice A:** Universal Studios | Full morning here if going (opens 10am) |
| | **Choice B:** Beaches + SEA Aquarium | More relaxed pace |
| 11:00am | SEA Aquarium | 2-3 hours, air-conditioned |

#### Afternoon (12:30pm - 5:00pm)
| Time | Activity | Notes |
|------|----------|-------|
| 12:30pm | Lunch | Malaysian Food Street (Resorts World) |
| 2:00pm | Beach time | Siloso or Palawan Beach - beach clubs, water sports |
| 4:00pm | Skyline Luge | Fun activity, great views (S$25 for 2 rides) |
| 5:00pm | Return to mainland | Cable car for sunset views |

#### Evening (6:00pm - 10:00pm)
| Time | Activity | Notes |
|------|----------|-------|
| 6:00pm | Kampong Glam | Sultan Mosque, Arab Street |
| 7:00pm | Haji Lane | Street art, indie shops, cafes |
| 8:00pm | Dinner | Middle Eastern cuisine on Arab Street |
| 9:30pm | Drinks | Haji Lane has great rooftop bars |

### DAY 3: Culture & Departure

#### Morning (7:00am - 12:00pm)
| Time | Activity | Notes |
|------|----------|-------|
| 7:00am | Little India | Early morning is magical - temples opening, flowers being delivered |
| 7:30am | Sri Veeramakaliamman Temple | Morning prayers, beautiful atmosphere |
| 8:00am | Breakfast | Tekka Centre - roti prata, teh tarik |
| 9:30am | Chinatown | Buddha Tooth Relic Temple, heritage walk |
| 11:00am | Shopping | Chinatown markets or Pagoda Street |

#### Afternoon (12:00pm - 5:00pm)
| Time | Activity | Notes |
|------|----------|-------|
| 12:00pm | Lunch | Maxwell Food Centre (Tian Tian Chicken Rice) |
| 1:30pm | National Gallery | Art in air-conditioned comfort |
| 4:00pm | Orchard Road | Last-minute shopping, ION Orchard |

#### Evening (if not departing)
| Time | Activity | Notes |
|------|----------|-------|
| 5:30pm | Newton Food Centre | Famous hawker centre (Crazy Rich Asians location) |
| 7:00pm | Jewel Changi Airport | World's tallest indoor waterfall, shopping, departure |

**3-day cost estimate:** S$250-400 (excluding accommodation, shopping)

---

## 7-DAY ITINERARY: Complete Singapore

*Deep dive into Singapore. Includes day trips and hidden gems.*

### DAY 1: Arrival + Marina Bay
Same as 3-day itinerary Day 1, but add:
- Afternoon: ArtScience Museum "Future World" exhibition
- Evening: River cruise from Clarke Quay (S$25, 40min)

### DAY 2: Sentosa Island (Full Day)
| Time | Activity |
|------|----------|
| 9:00am | Cable car from Mount Faber |
| 10:00am-4:00pm | Universal Studios Singapore (full day) |
| 5:00pm | Siloso Beach sunset |
| 7:30pm | Wings of Time show (S$23) |
| 8:30pm | Dinner at Resorts World |

### DAY 3: Cultural Districts
| Time | Activity |
|------|----------|
| 7:00am | Little India temples + Tekka Centre breakfast |
| 10:00am | Indian Heritage Centre (S$8) |
| 12:00pm | Lunch at Komala Vilas (vegetarian) or Banana Leaf Apolo (fish head curry) |
| 2:00pm | Kampong Glam - Sultan Mosque, Malay Heritage Centre |
| 4:00pm | Haji Lane exploration |
| 7:00pm | Dinner on Arab Street |
| 9:00pm | Bugis Street night market |

### DAY 4: Nature & Wildlife
| Time | Activity |
|------|----------|
| 6:30am | MacRitchie TreeTop Walk | 8km loop, suspension bridge |
| 11:00am | Return, lunch at nearby hawker |
| 2:00pm | Singapore Zoo | 3-4 hours |
| 6:15pm | Night Safari | Arrive early for seats |
| 9:30pm | Late dinner nearby |

### DAY 5: Day Trip - Pulau Ubin
| Time | Activity |
|------|----------|
| 7:00am | MRT to Tanah Merah, bus 2 to Changi Point |
| 8:00am | Bumboat to Pulau Ubin (S$4) |
| 8:30am | Rent bicycle (S$10-15/day) |
| 9:00am | Explore: Chek Jawa Wetlands, German Girl Shrine, kampong villages |
| 1:00pm | Lunch at island kopitiam |
| 3:00pm | Return to mainland |
| 4:30pm | East Coast Park | Cycling, seafood dinner at East Coast Lagoon Food Village |
| 8:00pm | Sunset satay at East Coast |

### DAY 6: Museums & Heritage
| Time | Activity |
|------|----------|
| 9:00am | Peranakan Museum | Unique Straits Chinese culture |
| 11:00am | Katong/Joo Chiat | Peranakan shophouses, photography |
| 1:00pm | Lunch at 328 Katong Laksa |
| 3:00pm | National Museum of Singapore |
| 5:00pm | Fort Canning Park | Historical site, spice garden |
| 7:00pm | Chinatown dinner |
| 8:30pm | Rooftop drinks at 1-Altitude (world's highest alfresco bar) |

### DAY 7: Day Trip - Johor Bahru (Malaysia)
| Time | Activity |
|------|----------|
| 7:00am | Early departure | Grab/taxi to Woodlands Checkpoint |
| 8:00am | Clear immigration (can take 30-90min) |
| 9:30am | JB City Square mall | Shopping at Malaysian prices |
| 11:00am | Explore JB old town | Heritage zone, temples |
| 12:30pm | Lunch | Restoran Hua Mui (famous kaya toast), Hiap Joo Bakery |
| 2:00pm | More shopping or spa/massage (very cheap) |
| 5:00pm | Return to Singapore |
| 7:00pm | Final dinner | Newton Food Centre or favorite hawker |
| 9:00pm | Jewel Changi Airport | Final photos at Rain Vortex |

**Alternative Day 7: Batam, Indonesia**
- Ferry from HarbourFront (1 hour, S$50 round-trip)
- Cheaper massages, seafood, Indonesian shopping
- Need passport, visa-free for most nationalities

---

## SPECIALIZED ITINERARIES

### Family with Kids (3 Days)
**Day 1:**
- Morning: Gardens by the Bay (kids love Supertrees)
- Afternoon: Cloud Forest + Children's Garden (water play)
- Evening: Light show

**Day 2:**
- Full day: Universal Studios Singapore
- Evening: Sentosa beach

**Day 3:**
- Morning: Singapore Zoo (feeding times!)
- Afternoon: River Wonders (pandas!)
- Evening: Night Safari

### Foodie Focus (3 Days)
**Day 1:**
- Breakfast: Ya Kun Kaya Toast (iconic)
- Lunch: Maxwell Food Centre crawl
- Dinner: Jumbo Seafood chili crab
- Late: Geylang for frog porridge, durian

**Day 2:**
- Breakfast: Tekka Centre roti prata
- Lunch: Chinatown Complex exploration
- Afternoon: Cooking class (S$100-150)
- Dinner: Peranakan at Candlenut (Michelin-starred)

**Day 3:**
- Breakfast: Old Airport Road Food Centre
- Lunch: Hawker Chan (Michelin chicken rice)
- Dinner: Newton Food Centre
- Late: Chomp Chomp BBQ

### Budget Backpacker (3 Days)
Focus on FREE attractions:
- Gardens by the Bay outdoor
- All cultural districts
- Light shows
- Southern Ridges walk
- Botanic Gardens
- Beach time at Sentosa (free entry on foot)
- Hawker centres (S$3-6/meal)
- Free museum hours

**Budget estimate:** S$50-80/day including hostel

### Luxury Experience (3 Days)
**Day 1:**
- Stay: Marina Bay Sands (infinity pool!)
- Afternoon tea at TWG
- Dinner: Odette (3 Michelin stars)

**Day 2:**
- Private yacht charter
- Lunch: JAAN by Kirk Westaway
- Evening: 1-Altitude rooftop

**Day 3:**
- Spa day at Raffles Hotel
- Singapore Sling at Long Bar
- Dinner: Les Amis

---

## TIMING TIPS BY ATTRACTION

### What to Book in Advance
- Marina Bay Sands SkyPark (online discount)
- Universal Studios (especially weekends/holidays)
- Night Safari (specific session times)
- Popular restaurants (Odette, Burnt Ends need weeks ahead)
- Sentosa Cable Car

### No Booking Needed
- Gardens by the Bay conservatories (queues manageable)
- Most museums
- Hawker centres
- Cultural districts
- Zoo (better to go early anyway)

### Best Times to Visit Attractions
| Attraction | Best Time | Why |
|------------|-----------|-----|
| Gardens by the Bay | 6-8am OR 6-9pm | Cooler, light shows |
| Botanic Gardens | 6-9am | Peaceful, cool |
| Zoo | Opening time (8:30am) | Animals active, cooler |
| Night Safari | Arrive by 6pm | Best tram seats |
| Chinatown | 9-11am OR 5-8pm | Avoid midday heat |
| Orchard Road | After 11am | Shops open late |
| Sentosa Beach | After 4pm | Less scorching |
| MacRitchie | 7-10am | Cooler, less crowded |

---

## SAMPLE DAILY SCHEDULES BY ENERGY LEVEL

### High Energy Day
```
6:00am  Wake, quick hotel breakfast
6:30am  Outdoor activity (nature walk, gardens)
9:00am  Major attraction opens
12:00pm Hawker lunch
1:00pm  Air-conditioned attraction
4:00pm  Cultural district exploration
7:00pm  Dinner
8:00pm  Light show / nightlife
11:00pm Return to hotel
```

### Relaxed Day
```
8:00am  Sleep in, hotel breakfast
10:00am One major attraction
1:00pm  Long lunch, rest at hotel
4:00pm  Light exploration
6:00pm  Sunset spot
8:00pm  Leisurely dinner
10:00pm Evening stroll / drinks
```

---

*Last updated: February 2026*
