# Singapore Attractions Guide

> Complete guide to Singapore's attractions with honest ratings on what's worth it vs skip. Updated for 2025-2026.

## Quick Rating System
- ⭐⭐⭐⭐⭐ = Must-see, don't miss
- ⭐⭐⭐⭐ = Highly recommended
- ⭐⭐⭐ = Worth it if time permits
- ⭐⭐ = Only if interested in the topic
- ⭐ = Tourist trap / Skip

---

## ICONIC LANDMARKS

### Marina Bay Sands SkyPark ⭐⭐⭐⭐⭐
**Verdict: MUST DO**
- **What:** 56-story observation deck with 360° views of Singapore
- **Cost:** S$26 adults (2025), S$23 seniors, S$20 children 2-12
- **Hours:** Daily 9:30am-10pm (until 11pm Fri-Sun)
- **Best time:** Sunset for golden hour photos + night lights
- **Insider tip:** The famous infinity pool is HOTEL GUESTS ONLY - don't expect to swim unless staying at MBS (~S$700+/night)
- **Skip the line:** Book tickets online in advance

### Gardens by the Bay ⭐⭐⭐⭐⭐
**Verdict: MUST DO - Singapore's crown jewel**
- **What:** 101-hectare futuristic garden with Supertrees, biodomes, and stunning architecture
- **Outdoor Gardens:** FREE, open 5am-2am daily
- **Conservatories (Flower Dome + Cloud Forest):** S$32 adults
- **OCBC Skyway (Supertree walk):** S$14 adults
- **Cloud Forest:** Houses world's tallest indoor waterfall - absolutely worth it
- **FREE Light Show:** "Garden Rhapsody" at Supertree Grove - 7:45pm & 8:45pm nightly
- **Insider tip:** Do conservatories in the afternoon (escape heat), stay for sunset from Skyway, then free light show

### The Merlion ⭐⭐⭐
**Verdict: WORTH IT (but quick stop)**
- **What:** Singapore's iconic half-lion, half-fish statue spouting water
- **Cost:** FREE
- **Time needed:** 15-30 minutes for photos
- **Best time:** Evening when Marina Bay skyline lights up
- **Reality check:** It's smaller than expected - get your photo and move on
- **Insider tip:** Better views OF the Merlion from across the bay at Marina Bay Sands

### Singapore Flyer ⭐⭐⭐
**Verdict: OPTIONAL - Good but expensive**
- **What:** Giant observation wheel (165m tall, was world's largest)
- **Cost:** S$40 adults, S$28 children
- **Duration:** 30-minute rotation
- **Skip if:** You're doing SkyPark - similar views, SkyPark is more iconic
- **Worth it if:** Coming at night for twinkling city lights

---

## CULTURAL DISTRICTS

### Chinatown ⭐⭐⭐⭐⭐
**Verdict: MUST DO**
- **What:** Historic Chinese district with temples, hawkers, and heritage
- **Cost:** FREE to explore
- **Must-see:**
  - **Buddha Tooth Relic Temple** - Stunning 4-story temple, sacred tooth on 4th floor, FREE entry
  - **Chinatown Heritage Centre** - S$18, understand the immigrant experience
  - **Sri Mariamman Temple** - Singapore's oldest Hindu temple, gorgeous gopuram
  - **Thian Hock Keng Temple** - Oldest Chinese temple (1840), incredible architecture
- **Best for food:** Maxwell Food Centre (hawker), Chinatown Complex Food Centre
- **Insider tip:** Visit early morning or evening; midday is unbearably hot
- **Time needed:** 3-4 hours minimum

### Little India ⭐⭐⭐⭐⭐
**Verdict: MUST DO**
- **What:** Vibrant Indian district - colors, spices, temples, authentic culture
- **Cost:** FREE to explore
- **Must-see:**
  - **Sri Veeramakaliamman Temple** - Colorful, active Hindu temple
  - **Tekka Centre** - Best hawker food in the area, authentic Indian meals S$4-8
  - **House of Tan Teng Niah** - Instagram-famous colorful heritage house
  - **Mustafa Centre** - 24-hour shopping madness, everything you need
- **Best experience:** Visit during Deepavali (Oct/Nov) for spectacular decorations
- **Insider tip:** Best biryani and roti prata in Singapore here - way cheaper than tourist areas
- **Time needed:** 2-3 hours

### Kampong Glam (Arab Quarter) ⭐⭐⭐⭐
**Verdict: HIGHLY RECOMMENDED**
- **What:** Singapore's Malay/Arab heritage district
- **Cost:** FREE to explore
- **Must-see:**
  - **Sultan Mosque** - Stunning golden-domed mosque, free entry (dress modestly)
  - **Haji Lane** - Instagram paradise with street art, indie boutiques, cafes
  - **Arab Street** - Textiles, rugs, Turkish lamps, perfumes
- **Best for:** Street art, hipster cafes, evening drinks (Haji Lane has outdoor bars)
- **Insider tip:** Come for sunset/evening - Haji Lane transforms with live music and buzzing nightlife
- **Time needed:** 2-3 hours

### Orchard Road ⭐⭐⭐
**Verdict: WORTH IT for shoppers**
- **What:** Singapore's premier shopping boulevard - 2.2km of malls
- **For luxury:** ION Orchard, Paragon, Ngee Ann City (Takashimaya)
- **For budget:** Lucky Plaza (also great for Filipino food)
- **For food:** Newton Food Centre nearby for hawker experience
- **Skip if:** Not into shopping or luxury goods
- **Christmas:** Spectacular light displays Nov-Dec
- **Time needed:** 2-4 hours depending on shopping intensity

---

## THEME PARKS & ATTRACTIONS

### Sentosa Island ⭐⭐⭐⭐
**Verdict: HIGHLY RECOMMENDED (especially with kids)**
- **What:** Resort island with beaches, theme parks, attractions
- **Getting there:** Sentosa Express from VivoCity (S$4), FREE on foot via boardwalk, Cable Car (S$35 round-trip)
- **Entry:** FREE (just pay transport)

#### Universal Studios Singapore ⭐⭐⭐⭐
- **Cost:** S$82 adults, S$62 children (2025)
- **Best for:** Thrill-seekers, movie fans, families
- **Top rides:** Battlestar Galactica, Revenge of the Mummy, Transformers 4D
- **Time needed:** Full day (6-8 hours)
- **Skip the Express Pass:** Unless visiting during school holidays - regular lines manageable

#### S.E.A. Aquarium ⭐⭐⭐⭐
- **Cost:** S$46 adults
- **What:** One of world's largest aquariums, 100,000+ marine animals
- **Highlight:** Open Ocean habitat with massive viewing panel
- **Time needed:** 2-3 hours

#### Adventure Cove Waterpark ⭐⭐⭐
- **Cost:** S$42 adults
- **Best for:** Families with kids, hot day relief
- **Includes:** Snorkeling with fish, lazy river, slides

#### Siloso Beach ⭐⭐⭐
- **What:** Man-made beach with bars, water sports, beach clubs
- **Reality check:** Water is brownish (shipping lanes nearby) - it's about the vibe, not pristine swimming
- **Best for:** Sunset drinks, chill vibes

### Singapore Zoo + Night Safari ⭐⭐⭐⭐⭐
**Verdict: WORLD-CLASS - Don't miss**
- **Location:** Mandai (north Singapore, 30min from city)
- **Singapore Zoo:** S$50 adults - "open concept" design, animals in naturalistic habitats
- **Night Safari:** S$55 adults - UNIQUE experience, nocturnal animals, tram ride
- **River Wonders:** S$42 adults - freshwater/river-themed
- **Bird Paradise:** S$48 adults - Asia's largest bird park
- **Combo deals:** Available for multiple parks
- **Insider tip:** Do Night Safari last - it opens at 6:30pm, arrive by 6pm for best tram seats
- **Time needed:** Half day per park

### Jewel Changi Airport ⭐⭐⭐⭐⭐
**Verdict: MUST SEE (even if not flying)**
- **What:** Architectural marvel with world's tallest indoor waterfall (Rain Vortex)
- **Cost:** FREE to see Rain Vortex; Canopy Park attractions S$18-54
- **Light show:** After dark, stunning display at the waterfall
- **Getting there:** MRT direct to Changi Airport, connected to T1
- **Insider tip:** Perfect for last day before flight - arrive 4-5 hours early, explore, then check in

---

## NATURE & OUTDOOR

### Singapore Botanic Gardens ⭐⭐⭐⭐⭐
**Verdict: MUST DO - UNESCO World Heritage Site**
- **Cost:** FREE (National Orchid Garden S$5)
- **Hours:** 5am-12am daily
- **What:** 160-year-old tropical garden, Singapore's first UNESCO site
- **Must-see:**
  - **National Orchid Garden** - 1,000+ orchid species, worth the S$5
  - **Swan Lake** - Perfect for morning jog or picnic
  - **Heritage Trees** - Some over 150 years old
- **Best time:** Early morning (6-8am) before heat, or after 5pm
- **Time needed:** 2-3 hours

### Bukit Timah Nature Reserve ⭐⭐⭐⭐
**Verdict: GREAT for nature lovers**
- **Cost:** FREE
- **What:** Singapore's only primary rainforest, hike to highest point (163m)
- **Wildlife:** Macaques, flying lemurs, squirrels, birds
- **Getting there:** MRT to Beauty World, then walk/taxi
- **Insider tip:** Go weekday mornings - packed on weekends
- **Time needed:** 2-3 hours for main trail

### MacRitchie Reservoir & TreeTop Walk ⭐⭐⭐⭐
**Verdict: RECOMMENDED for nature/hiking**
- **Cost:** FREE
- **What:** 8km trail through forest to 250m suspension bridge
- **TreeTop Walk hours:** 9am-5pm (closed Mondays)
- **Difficulty:** Moderate - wear proper shoes
- **Wildlife:** Monkeys, monitor lizards, birds
- **Time needed:** 3-4 hours for full loop

### Pulau Ubin ⭐⭐⭐⭐
**Verdict: HIDDEN GEM - Real old Singapore**
- **What:** Rustic offshore island, time capsule of 1960s Singapore
- **Getting there:** Bumboat from Changi Point (S$4, 15min), depart when full
- **What to do:** Rent bikes (S$10-15/day), explore villages, visit Chek Jawa wetlands
- **Best for:** Escaping the city, nature lovers, photographers
- **Insider tip:** Bring water and snacks - limited options on island
- **Time needed:** Half day

### Southern Ridges Walk ⭐⭐⭐⭐
**Verdict: RECOMMENDED - Underrated**
- **Cost:** FREE
- **What:** 10km elevated trail connecting parks, stunning Henderson Waves bridge
- **Highlights:**
  - **Henderson Waves** - Architectural marvel bridge
  - **Mount Faber Park** - City views
  - **HortPark** - Beautiful gardens
- **Best time:** Late afternoon for sunset views
- **Time needed:** 3-4 hours end-to-end

---

## HAWKER CENTRES (UNESCO Heritage) ⭐⭐⭐⭐⭐

**Singapore's hawker culture is UNESCO Intangible Cultural Heritage - you MUST eat at hawkers.**

### Maxwell Food Centre
- **Location:** Chinatown
- **Famous for:**
  - **Tian Tian Hainanese Chicken Rice** - Michelin Bib Gourmand, expect queues (S$5-6)
  - **Zhen Zhen Porridge** - Traditional congee
  - **Maxwell Fuzhou Oyster Cake** - Crispy goodness
- **Hours:** 8am-2am (varies by stall)

### Lau Pa Sat
- **Location:** CBD/Financial district
- **Famous for:** Satay Street (evening grilled skewers)
- **Hours:** 24 hours (Satay Street from 7pm)
- **Vibe:** Tourist-friendly, good for first-timers

### Old Airport Road Food Centre
- **Location:** Near Kallang
- **What:** Locals' favorite - over 150 stalls
- **Famous for:** Rojak, fried carrot cake, wonton mee
- **Insider tip:** This is where Singaporeans actually eat - less touristy, better prices

### Chomp Chomp Food Centre
- **Location:** Serangoon Gardens
- **Hours:** 5pm-12am (evening only)
- **Famous for:** BBQ chicken wings, satay, stingray
- **Insider tip:** Peak local experience, especially on weekends

### Tekka Centre
- **Location:** Little India
- **Famous for:** Best Indian food - biryani, roti prata, fish head curry
- **Prices:** S$4-10 for full meals
- **Open:** 6:30am-10pm

---

## MUSEUMS & CULTURE

### National Gallery Singapore ⭐⭐⭐⭐
- **Cost:** S$20 adults (FREE for Singapore residents)
- **What:** World's largest collection of modern Southeast Asian art
- **Location:** Former Supreme Court and City Hall buildings
- **Time needed:** 2-3 hours
- **Insider tip:** Go for sunset rooftop views at Smoke & Mirrors bar

### National Museum of Singapore ⭐⭐⭐⭐
- **Cost:** S$15 adults
- **What:** Singapore's oldest museum, excellent history exhibits
- **Best exhibit:** Singapore History Gallery - covers 700 years
- **Time needed:** 2-3 hours

### ArtScience Museum ⭐⭐⭐
- **Cost:** Varies by exhibition (S$19-32)
- **What:** Futuristic lotus-shaped building at Marina Bay Sands
- **Best for:** "Future World" permanent digital art exhibition
- **Skip if:** Not into interactive art/digital exhibitions

### Peranakan Museum ⭐⭐⭐⭐
- **Cost:** S$16 adults
- **What:** Explore unique Peranakan (Straits Chinese) culture
- **Best for:** Understanding Singapore's multicultural heritage
- **Insider tip:** Combine with Katong neighborhood visit for Peranakan architecture

### Haw Par Villa ⭐⭐⭐ (Quirky)
- **Cost:** FREE (Hell's Museum S$18)
- **What:** Bizarre outdoor park with 1,000+ statues depicting Chinese mythology
- **Highlight:** Ten Courts of Hell - grotesque but fascinating
- **Best for:** Weird, off-beat experience
- **Time needed:** 1-2 hours

---

## WHAT TO SKIP (Tourist Traps)

### Madame Tussauds Sentosa ⭐⭐
- **Why skip:** Overpriced (S$44), same as any other Madame Tussauds worldwide
- **Do instead:** Spend time on beach or S.E.A. Aquarium

### Tiger Sky Tower (Sentosa) ⭐
- **Why skip:** Outdated, views aren't special, SkyPark is 10x better
- **Do instead:** Cable car for aerial views

### Snow City ⭐⭐
- **Why skip:** Small, gimmicky, expensive for what it is
- **Do instead:** Cloud Forest at Gardens by the Bay has cool air

### Trick Eye Museum ⭐⭐
- **Why skip:** Overpriced, gimmicky
- **Do instead:** Street art at Haji Lane (free)

### Cable Car Dining ⭐⭐
- **Why skip:** Extremely overpriced for mediocre food in a cramped cabin
- **Do instead:** Regular cable car ride + proper dinner elsewhere

---

## MONEY-SAVING TIPS

### Multi-Attraction Passes
- **Go City Singapore All-Inclusive Pass:** Best value if doing 3+ attractions/day
  - 2-day: ~S$230, 3-day: ~S$275, 5-day: ~S$340
  - Includes: Gardens by the Bay, Night Safari, Universal Studios, etc.
- **iVenture Singapore Flexi Pass:** Choose specific attractions
  - 3 attractions: ~S$115, 5 attractions: ~S$155

### Free Attractions
- Outdoor Gardens by the Bay
- Supertree Grove light show (7:45pm & 8:45pm)
- Merlion Park
- Spectra light show at Marina Bay (8pm, 9pm, 10pm Fri-Sat)
- All cultural districts (Chinatown, Little India, Kampong Glam)
- Singapore Botanic Gardens (except Orchid Garden)
- Southern Ridges Walk
- Henderson Waves
- Haw Par Villa grounds

### Timing Tips
- Book online for 10-20% off many attractions
- Weekday visits = shorter queues, sometimes lower prices
- Many museums have free/discounted hours (check websites)

---

## SEASONAL EVENTS

### Chinese New Year (Jan/Feb)
- Chinatown goes all out with decorations
- Chingay Parade - massive multicultural parade
- **Note:** Some businesses closed 2-3 days

### Deepavali (Oct/Nov)
- Little India spectacular with lights and decorations
- Cultural performances and events

### Christmas (Nov-Dec)
- Orchard Road transforms with elaborate lights
- Marina Bay events and decorations

### Singapore Food Festival (July)
- Citywide celebration of local cuisine
- Special menus, events, hawker experiences

### F1 Singapore Grand Prix (September)
- Night race around Marina Bay
- Huge concerts and events
- **Warning:** Hotel prices skyrocket

---

*Last updated: February 2026*
