# Singapore Work Visas & Immigration Guide 2024-2026

## Overview of Work Passes

| Pass Type | Target | Min Salary | COMPASS | Duration |
|-----------|--------|------------|---------|----------|
| **Employment Pass (EP)** | Professionals, managers | $5,600+ | Required | 2-5 years |
| **S Pass** | Mid-level skilled workers | $3,300+ | No | 2 years |
| **EntrePass** | Entrepreneurs | N/A | No | 1-2 years |
| **Tech.Pass** | Top tech talent | $22,500/month | No | 2 years |
| **ONE Pass** | Top global talent | $30,000/month | No | 5 years |
| **Work Permit** | Semi-skilled workers | Sector-based | No | 2 years |

---

## Employment Pass (EP) - Main Work Visa

### Eligibility Overview (2-Stage Framework)

#### Stage 1: Minimum Qualifying Salary

**Current Requirements (Jan 2025 - Dec 2026)**

| Sector | Base Salary (Age 23-) | Age 45+ |
|--------|----------------------|---------|
| **All sectors** | **$5,600** | $10,700 |
| **Financial services** | **$6,200** | $11,800 |

**From Jan 2027**

| Sector | Base Salary (Age 23-) | Age 45+ |
|--------|----------------------|---------|
| **All sectors** | **$6,000** | $11,500 |
| **Financial services** | **$6,600** | $12,700 |

**Salary by Age (Non-Financial Sector, 2025-2026)**

| Age | Min Salary |
|-----|-----------|
| 23 or below | $5,600 |
| 25 | $6,064 |
| 30 | $7,223 |
| 35 | $8,382 |
| 40 | $9,541 |
| 45+ | $10,700 |

#### Stage 2: COMPASS Framework

**Complementarity Assessment Framework** - Points-based system for EP approval.

**Pass threshold: 40 points minimum**

### COMPASS Criteria (6 Categories)

#### C1: Salary Benchmark
| Candidate Salary vs Sector | Points |
|---------------------------|--------|
| 90th percentile or above | **20** |
| 65th to <90th percentile | 10 |
| Below 65th percentile | 0 |

#### C2: Qualifications
| Qualification | Points |
|--------------|--------|
| Top 100 university (QS) / Singapore Autonomous University | **20** |
| Other degree-equivalent qualification | 10 |
| No degree | 0 |

#### C3: Diversity (Nationality Share)
*How diverse is your nationality within the company?*

| Share of candidate's nationality in firm | Points |
|------------------------------------------|--------|
| Less than 5% | **20** |
| 5% to <25% | 10 |
| 25% or more | 0 |
| < 25 PMETs in company | 10 (default) |

#### C4: Support for Local Employment
| Company's local PMET share vs sector | Points |
|-------------------------------------|--------|
| 50th percentile or above | **20** |
| 20th to <50th percentile | 10 |
| Below 20th percentile | 0 |
| < 25 PMETs in company | 10 (default) |

#### C5: Skills Bonus (Shortage Occupation List)
| Criteria | Points |
|----------|--------|
| Job on SOL + nationality <1/3 of firm | **20** |
| Job on SOL + nationality ≥1/3 of firm | 10 |

**SOL includes**: AI/ML engineers, cybersecurity specialists, data engineers, full-stack developers, product managers (specific categories)

#### C6: Strategic Economic Priorities Bonus
| Criteria | Points |
|----------|--------|
| Company has EDB/ESG partnership or NTUC endorsement | **10-20** |

### Exemptions from COMPASS

EP holders **exempt from COMPASS**:
- Monthly salary ≥ **$22,500**
- Short-term (≤ 1 month)
- Intra-corporate transferees under FTAs
- Certain government/international organization positions

### EP Application Process

| Step | Who | Timeline |
|------|-----|----------|
| Job advertising on MyCareersFuture | Employer | 14+ days before EP application |
| Submit EP application | Employer/EA | N/A |
| Processing | MOM | 10 business days |
| IPA Letter issued | MOM | If approved |
| Enter Singapore | Candidate | Within 6 months |
| Complete medical (if required) | Candidate | After arrival |
| EP issuance | Employer | Same day |
| Card registration | Candidate | At MOM |
| Card delivery | MOM | 5 working days |

### EP Fees

| Item | Cost |
|------|------|
| Application fee | $105 |
| Issuance fee | $225 |
| Multiple Journey Visa (if needed) | $30 |

### EP Duration

| Category | Duration |
|----------|----------|
| Standard | 2 years (initial), 3 years (renewal) |
| Experienced professionals | Up to 5 years |
| SOL tech occupations (experienced) | Up to 5 years |

---

## S Pass - Mid-Level Workers

### Eligibility

| Requirement | Details |
|-------------|---------|
| **Min salary** | $3,300 (general), $3,800 (financial services) |
| **Age increase** | Up to $4,800 at age 45+ |
| **Qualifications** | Optional to declare |
| **Quota** | 10-15% of company workforce |
| **Levy** | $330-650/month (employer pays) |

### S Pass Salary by Age (2025-2026)

| Age | Min Salary |
|-----|-----------|
| 23 or below | $3,300 |
| 30 | $3,850 |
| 40 | $4,350 |
| 45+ | $4,800 |

### S Pass Quota & Levy

| Sector | Quota Cap | Basic Levy | Tier 2 Levy |
|--------|-----------|------------|-------------|
| Services | 10% | $330 | $650 |
| Manufacturing | 15% | $330 | $650 |

### When S Pass vs EP?
- **S Pass**: Lower salary threshold, but quota limits and levy
- **EP**: Higher salary requirement, no quota, no levy, better for career progression

---

## Dependant's Pass (DP)

### Eligibility
EP or S Pass holders earning **≥ $6,000/month** can sponsor:
- **Spouse** (legally married)
- **Unmarried children under 21**
- **Legally adopted children**

### DP Features
- Tied to main pass holder's employment
- **Cannot work** without separate Letter of Consent (LOC)
- **LOC process**: Employer applies, processed in 3 weeks

### DP Fees
| Item | Cost |
|------|------|
| Application | $105 |
| Issuance | $225 |

---

## Long-Term Visit Pass (LTVP)

### Eligibility
EP or S Pass holders earning **≥ $6,000/month** can sponsor:
- **Common-law spouse**
- **Unmarried step-children under 21**
- **Unmarried handicapped children 21+**
- **Parents** (if earning ≥ $12,000/month)

### LTVP Features
- Similar to DP but for non-immediate family
- **Can work** with LTVP+ (Letter of Consent process similar)

### LTVP Fees
| Item | Cost |
|------|------|
| Application | $105 |
| Issuance | $225 |

---

## Permanent Residence (PR)

### Who Can Apply

| Category | Description |
|----------|-------------|
| **Professional/Technical/Skilled Worker** | EP or S Pass holder |
| **Investor** | Significant business investment in Singapore |
| **Spouse/Child of SC/PR** | Family sponsorship |
| **Aged Parent of SC** | Parent of Singapore citizen |

### PR Application Criteria (Unofficially Weighted)

| Factor | Weight (Est.) |
|--------|---------------|
| **Time in Singapore** | 2+ years EP recommended |
| **Salary level** | Higher = better |
| **Age** | Younger preferred |
| **Education** | Recognized qualifications |
| **Local integration** | Community involvement, CPF contributions |
| **Family ties** | Spouse/children who are SC/PR |
| **Industry** | Strategic industries favored |

### PR Processing

| Item | Details |
|------|---------|
| Processing time | **6-12 months** (varies greatly) |
| Approval rate | ~30% (estimated) |
| Application fee | $100 per applicant |
| Re-Entry Permit | 5 years (first), 5 years (renewal) |

### PR Benefits
- **Live & work freely** in Singapore
- **No need for work pass** renewal
- **Can sponsor family** for PR
- **Buy HDB resale** (after 3 years)
- **CPF contributions** (mandatory)
- **Lower healthcare costs** (subsidized)
- **Step toward citizenship**

### PR Obligations
- **CPF contributions**: ~17% employer + ~20% employee
- **Re-Entry Permit**: Must maintain to preserve PR status
- **NS liability**: Male children must serve National Service

### Tips for PR Application
1. Apply after 2-3 years on EP
2. Higher salary = better chances
3. Show community integration
4. Have a stable employment record
5. Work in strategic industries (tech, finance)
6. Be prepared to wait 6-12+ months

---

## Singapore Citizenship

### Eligibility

| Category | Requirement |
|----------|-------------|
| **PR for 2+ years** | Plus meeting residency requirements |
| **Spouse of SC** | PR for 2+ years, married 2+ years |
| **Child of SC** | Born abroad to SC parent |

### Citizenship Benefits
- **Passport**: 195+ visa-free destinations
- **HDB**: Buy new BTO flats
- **Full subsidies**: Healthcare, education
- **CPF bonuses**: Additional government top-ups
- **No visa issues**: Permanent right to live/work

### Citizenship Obligations
- **National Service**: All male citizens must serve 2 years
- **Reservist duties**: Until age 40-50
- **Renounce other citizenship**: Singapore doesn't recognize dual citizenship

### Processing
- **Timeline**: 6-12+ months
- **Interview**: Required for most applicants
- **Ceremony**: Take citizenship oath

---

## Other Passes

### Tech.Pass

**For established tech leaders**

| Requirement | Details |
|-------------|---------|
| **Min salary** | $22,500/month (last drawn) OR |
| **Founder** | Founded tech company valued $500M+ or raised $30M+ |
| **Leader** | Led tech team of 5+ years at $500M+ company |
| **Duration** | 2 years |
| **Benefits** | Start business, work for multiple companies, concurrently advise |

### ONE Pass (Overseas Networks & Expertise Pass)

**For exceptional global talent**

| Requirement | Details |
|-------------|---------|
| **Min salary** | $30,000/month (last 1 year) |
| **Duration** | 5 years |
| **Benefits** | Work for any employer, start businesses, spouse can work |

### PEP (Personalised Employment Pass)

*Being phased out - replaced by ONE Pass*

---

## Visa Timeline Summary

### New Arrival (EP Holder)

| Milestone | Timeline |
|-----------|----------|
| Arrive on EP | Day 0 |
| Apply for DP/LTVP (if applicable) | Anytime |
| Eligible for PR application | ~2-3 years |
| PR processing | 6-12 months |
| PR approved | ~3-4 years from arrival |
| Eligible for citizenship | PR + 2 years |
| Citizenship processing | 6-12 months |
| Singapore citizen | ~5-6 years from arrival |

### Practical Tips

1. **Before moving**: Ensure EP approved before booking flights
2. **First month**: 
   - Get NRIC (IC)
   - Open bank account
   - Get local phone number
   - Apply for DP/LTVP for family
3. **First year**:
   - Integrate into community
   - Maintain stable employment
4. **Year 2-3**:
   - Consider PR application
   - Document community involvement
5. **After PR**:
   - Understand CPF system
   - Consider citizenship timeline

---

## Quick Reference: EP Minimum Salaries

### 2025-2026 (Current)

| Age | General | Financial Services |
|-----|---------|-------------------|
| 23- | $5,600 | $6,200 |
| 25 | $6,064 | $6,709 |
| 30 | $7,223 | $7,982 |
| 35 | $8,382 | $9,255 |
| 40 | $9,541 | $10,527 |
| 45+ | $10,700 | $11,800 |

### From 2027

| Age | General | Financial Services |
|-----|---------|-------------------|
| 23- | $6,000 | $6,600 |
| 30 | ~$7,700 | ~$8,500 |
| 45+ | $11,500 | $12,700 |

---

## Resources

- **MOM (Ministry of Manpower)**: mom.gov.sg
- **ICA (Immigration)**: ica.gov.sg
- **EP Self-Assessment Tool**: mom.gov.sg/eservices/services/employment-s-pass-self-assessment-tool
- **COMPASS Calculator**: Available on MOM website
- **MyCareersFuture**: mycareersfuture.gov.sg

---

*Last Updated: February 2026*
*Sources: MOM, ICA, official government announcements*
