# Singapore Transport Guide 2024-2026
## Complete Guide to Getting Around Singapore

---

## 1. MRT (Mass Rapid Transit)

Singapore's MRT is one of the world's best metro systems - clean, efficient, air-conditioned, and extensive.

### MRT Lines (2025-2026)

| Line | Colour | Stations | Key Stops |
|------|--------|----------|-----------|
| **North-South (NS)** | Red | 27 | Marina Bay, Orchard, Woodlands |
| **East-West (EW)** | Green | 35 | Changi Airport, Raffles Place, Jurong East |
| **North-East (NE)** | Purple | 16 | Chinatown, Little India, Serangoon |
| **Circle (CC)** | Orange | 31 | Dhoby Ghaut, Botanic Gardens, HarbourFront |
| **Downtown (DT)** | Blue | 34 | Bugis, Marina Bay, Beauty World |
| **Thomson-East Coast (TE)** | Brown | 32* | Orchard, Gardens by the Bay, Marine Parade |

*TE Line still expanding through 2025-2027

### Operating Hours
- **First train:** 5:30 AM (varies by station)
- **Last train:** ~11:30 PM-12:00 AM
- **Frequency:**
  - Peak hours (7-9 AM, 5-8 PM): 2-3 minutes
  - Off-peak: 5-7 minutes
  - Late night/weekend: 7-10 minutes

### MRT Fares (2025)
Fares are distance-based:

| Distance | Adult | Senior/Student |
|----------|-------|----------------|
| Up to 3.2 km | S$1.08 | S$0.59 |
| 3.2-4.2 km | S$1.19 | S$0.66 |
| 4.2-5.2 km | S$1.29 | S$0.72 |
| 5.2-6.2 km | S$1.39 | S$0.77 |
| 10-15 km | S$1.69 | S$0.93 |
| 20-25 km | S$1.99 | S$1.10 |
| Maximum | S$2.26 | S$1.24 |

**Transfer discount:** Free transfer between MRT/bus within 45 mins

### LRT (Light Rail Transit)
Three automated LRT systems connect to MRT:
- **Bukit Panjang LRT** - connects to NS/DT lines
- **Sengkang LRT** - connects to NE line
- **Punggol LRT** - connects to NE line

---

## 2. Buses

Singapore has 300+ bus routes covering every corner of the island.

### Bus Operators
- **SBS Transit** - Most routes
- **SMRT** - Western and northern routes
- **Tower Transit** - Selected routes
- **Go-Ahead** - Eastern routes

### Bus Fares (2025)

| Distance | Adult | Senior/Student |
|----------|-------|----------------|
| Up to 3.2 km | S$1.08 | S$0.59 |
| 3.2-4.2 km | S$1.18 | S$0.65 |
| 7.2-8.2 km | S$1.48 | S$0.81 |
| Maximum | S$2.27 | S$1.24 |

**Express buses:** S$0.10-0.30 premium

### Useful Apps
- **MyTransport.SG** - Official LTA app, real-time arrivals
- **SG BusLeh** - Clean interface, nearby stops
- **Citymapper** - Best journey planner
- **Google Maps** - Works well for basic routing

### Bus Tips
- Board at front door, tap card
- Exit via rear doors, tap card again
- Press button before your stop
- Priority seats at front for elderly/pregnant
- No eating, drinking, durians

---

## 3. Payment Systems

### EZ-Link Card
The traditional stored-value card:

**Getting One:**
- Purchase at MRT stations, 7-Eleven, TransitLink offices
- Cost: S$10 (includes S$5 stored value)
- Top up at machines, 7-Eleven, online

**Top-up Options:**
- GTMs (General Ticketing Machines) at MRT
- Add Value Machines at bus interchanges
- 7-Eleven, Cheers convenience stores
- Mobile app (EZ-Link app)

### SimplyGo (Contactless)
The modern way - pay directly with your bank card or mobile wallet.

**Supported Methods:**
- Mastercard/Visa contactless cards
- Apple Pay, Google Pay, Samsung Pay
- Nets QR
- DBS PayLah!, GrabPay

**How to Set Up:**
1. Download SimplyGo app
2. Register account (Singpass or manual)
3. Add your payment card
4. Tap card directly at gantry

**Benefits:**
- No stored value to manage
- Auto-debit from bank account
- View all trips in app
- Works with multiple cards

**Important:** Same card must be used for tap-in and tap-out!

### Concession Cards
- **Senior Citizen:** 60+, up to 50% discount
- **Student:** Primary to tertiary, significant discounts
- **Workfare Transport Concession:** Low-wage workers
- **Persons with Disabilities:** Reduced fares

---

## 4. Taxis

### Taxi Companies
| Company | Booking | Call |
|---------|---------|------|
| ComfortDelGro | Comfort, CityCab apps | 6552-1111 |
| SMRT Taxis | SMRT Book a Cab app | 6555-8888 |
| Premier Taxis | - | 6363-6888 |
| HDT | - | 6478-5000 |
| Trans-Cab | - | 6555-3333 |

### Taxi Fares (2025)

**Flag-down (Standard):**
- Base fare: S$4.00-4.60
- Per km (first 10 km): S$0.26
- Per km (after 10 km): S$0.28
- Per 25 seconds waiting: S$0.26

**Surcharges:**
| Surcharge | When | Amount |
|-----------|------|--------|
| Peak hour | Mon-Fri 6-9:30 AM | 25% |
| Peak hour | Mon-Fri 6-12 AM | 25% |
| Midnight | 12-6 AM | 50% |
| City surcharge | CBD 5-12 AM | S$3 |
| Airport pickup | Changi | S$8-10 |
| Booking | Phone/app | S$2.50-8 |
| ERP charges | Various | Pass-through |

**Example Trip:** Orchard to Changi Airport
- Distance: ~20 km
- Base fare + distance: ~S$18-22
- Airport surcharge: S$8
- Peak hour (if applicable): +25%
- **Total:** S$26-35

---

## 5. Ride-Hailing (Grab, Gojek, etc.)

### Grab
The dominant ride-hailing app in Singapore (and Southeast Asia).

**Service Types:**
| Service | Description | Base Fare |
|---------|-------------|-----------|
| JustGrab | Any nearest car/taxi | S$5-8+ |
| GrabCar | Private hire car | S$8-12+ |
| GrabShare | Shared ride, cheaper | S$4-8+ |
| GrabHitch | Carpool with regular driver | S$3-6+ |
| GrabTaxi | Metered taxi via app | Meter |
| GrabPet | Pet-friendly | S$15+ |
| GrabFamily | Child seat included | S$15+ |

**Pricing:**
- Dynamic pricing (surge during peak/rain)
- Upfront fare shown before booking
- Cashless (GrabPay, cards) or cash

**Pro Tips:**
- Book 3-5 mins before you need to leave
- GrabShare is 20-30% cheaper
- GrabHitch cheapest but limited availability
- Check taxi fare for comparison

### Gojek
Indonesian competitor, often cheaper:
- GoRide (motorcycle - not available in SG)
- GoCar (4-seater)
- Similar pricing model to Grab

### TADA
- Commission-free model
- Often cheaper than Grab
- Smaller driver pool

### Ryde
- Local Singapore app
- RydePool (carpooling)
- Competitive pricing

---

## 6. Cycling

### Personal Cycling
Singapore is increasingly bike-friendly with 500+ km of cycling paths.

**Park Connector Network (PCN):**
- 340 km of dedicated paths
- Links parks, nature reserves
- Mostly flat terrain
- Popular routes:
  - East Coast Park (15 km along beach)
  - Punggol Waterway (10 km scenic)
  - Rail Corridor (24 km former railway)

**Cycling Rules:**
- Helmets optional but recommended
- Lights required at night
- Cannot ride on expressways
- Footpaths: Max 10 km/h (or designated cycling paths)
- Some MRT stations have bicycle parking

### Bike Sharing
| Service | Price | Availability |
|---------|-------|--------------|
| **SG Bike** | S$0.65/15 min | Island-wide |
| **Anywheel** | S$0.50/15 min | Island-wide |
| **HelloRide** | S$0.50/15 min | Selected areas |

**How to Use:**
1. Download app
2. Scan QR code on bike
3. Ride
4. Park in designated zones
5. Lock and end trip in app

**Note:** Bikes must be parked in designated yellow boxes or face fines

### E-scooters / PMDs
- **Banned from footpaths** (since Nov 2019)
- Only allowed on cycling paths and roads
- Registration required
- Max speed: 25 km/h

---

## 7. Car Ownership (The Expensive Truth)

Singapore is the world's most expensive place to own a car.

### Certificate of Entitlement (COE)
To own a car, you must bid for a COE at auction (twice monthly).

**COE Categories (Feb 2026 prices):**
| Category | Vehicle Type | Recent COE Price |
|----------|--------------|------------------|
| A | Cars ≤1600cc & ≤130bhp | S$95,000-115,000 |
| B | Cars >1600cc or >130bhp | S$120,000-150,000 |
| C | Goods vehicles & buses | S$75,000-95,000 |
| D | Motorcycles | S$12,000-15,000 |
| E | Open (any except motorcycle) | S$125,000-155,000 |

**COE is valid for 10 years** - then pay again or scrap the car!

### Total Cost of a New Car

**Example: Toyota Corolla 1.6**

| Component | Cost |
|-----------|------|
| Open Market Value (OMV) | S$25,000 |
| Additional Registration Fee (ARF) | S$25,000 |
| Excise Duty (20% OMV) | S$5,000 |
| GST (9%) | S$4,500 |
| COE (Cat A) | S$100,000 |
| Registration fee | S$220 |
| Number plate | S$0-50,000+ |
| **Total** | **S$160,000-170,000+** |

The same car costs ~S$30,000-35,000 in most countries!

### Ongoing Costs
| Expense | Monthly/Annual Cost |
|---------|---------------------|
| Road Tax | S$600-2,000/year |
| Insurance | S$1,500-3,000/year |
| Petrol | S$200-400/month |
| Parking (HDB) | S$110/month |
| Parking (Condo) | S$100-200/month |
| Parking (CBD) | S$300-500/month |
| ERP (tolls) | S$50-200/month |
| Maintenance | S$100-200/month |
| **Total Ownership** | **S$1,500-3,000/month** |

### Is It Worth It?
For most people: **No.**

**Consider a car if:**
- You have children and need convenience
- Work requires frequent travel to remote areas
- You can comfortably afford it (>S$200k household income)
- You really love driving

**Otherwise:** Use Grab/taxi for convenience, MRT/bus for daily commute. Many Singaporeans spend S$300-500/month on Grab and still save massively vs car ownership.

---

## 8. Driving License Conversion

### If Your Country Has Reciprocal Agreement

**Countries with direct conversion:**
Australia, Austria, Belgium, Canada, Finland, France, Germany, Hong Kong, Ireland, Italy, Japan, Malaysia, Netherlands, New Zealand, Norway, South Korea, Spain, Sweden, Switzerland, Taiwan, UK, USA

**Process:**
1. Must have valid foreign license for ≥1 year
2. Visit Traffic Police HQ (10 Ubi Avenue 3)
3. Bring:
   - Foreign license + certified translation (if not English)
   - Passport + Employment Pass
   - Passport photos
   - Eye test from optician
4. Pay S$50
5. Receive Singapore license same day

### If No Reciprocal Agreement

Must pass:
1. **Basic Theory Test (BTT)** - 50 MCQs, 45 to pass
2. **Final Theory Test (FTT)** - 50 MCQs, 45 to pass (if no license) 
3. **Practical Driving Test** - On-road test

Register at driving school (ComfortDelGro, SSDC, BBDC) or private instructor.

### International Driving Permit (IDP)
- Valid for 12 months in Singapore
- Must convert to local license after 12 months
- Cannot be renewed indefinitely

---

## 9. Quick Reference: Transport Costs

### Monthly Transport Budget (Typical Scenarios)

| Profile | Mode | Monthly Cost |
|---------|------|--------------|
| CBD worker, lives near MRT | MRT + occasional Grab | S$100-150 |
| Family, multiple trips | MRT + bus + weekend Grab | S$200-300 |
| Frequent Grab user | Grab primarily | S$400-600 |
| Car owner | Full car costs | S$1,500-3,000 |

### Distance Examples (MRT)

| From → To | Time | Fare |
|-----------|------|------|
| Changi Airport → Orchard | 45 min | S$2.13 |
| Orchard → Marina Bay | 15 min | S$1.09 |
| Jurong East → Raffles Place | 35 min | S$1.79 |
| Woodlands → CBD | 45 min | S$2.00 |

---

## 10. Key Apps & Resources

### Must-Have Apps
- **SimplyGo** - Link payment cards
- **MyTransport.SG** - Official LTA app
- **Grab** - Ride-hailing
- **Google Maps** - Journey planning
- **Citymapper** - Best multimodal planner

### Useful Websites
- **LTA.gov.sg** - Official transport info
- **TransitLink.com.sg** - Fares & routes
- **OneMotoring.lta.gov.sg** - Driving services

---

*Last updated: February 2026*
