# Singapore Resident Guide 2024-2026
## Complete Guide to Moving and Setting Up Life in Singapore

---

## 1. Before You Arrive

### Visa & Immigration
Singapore offers several visa types for residents:

| Visa Type | Who It's For | Duration | Processing |
|-----------|--------------|----------|------------|
| **Employment Pass (EP)** | Professionals earning ≥S$5,000/month (S$5,500+ for finance) | 1-2 years, renewable | 3-8 weeks |
| **S Pass** | Mid-skilled workers earning ≥S$3,150/month | Up to 2 years | 3 weeks |
| **Personalised Employment Pass (PEP)** | High earners (S$22,500/month+) | 3 years, non-renewable | 8 weeks |
| **EntrePass** | Entrepreneurs starting a business | 1 year, renewable | 8 weeks |
| **Dependant's Pass** | Spouse/children of EP/S Pass holders | Tied to main pass | 3 weeks |

**Application Process:**
1. Employer submits application via MOM website
2. Receive In-Principle Approval (IPA)
3. Enter Singapore within 6 months
4. Complete medical examination
5. Collect pass at MOM Services Centre

### What to Bring
- **Documents:** Original degree certificates, employment contracts, marriage/birth certificates
- **Electronics:** Singapore uses Type G plugs (UK-style, 230V)
- **Medication:** Bring prescriptions; some drugs are controlled
- **Clothing:** Light, breathable fabrics only (it's always summer)

---

## 2. Finding Housing

### Housing Types

| Type | Monthly Rent (2025) | Who It's For |
|------|---------------------|--------------|
| **HDB Room** | S$800-1,500 | Budget singles |
| **HDB Whole Unit** | S$2,000-4,000 | Families, couples |
| **Condo** | S$3,000-8,000 | Professionals, families |
| **Landed Property** | S$10,000-50,000+ | High earners, large families |
| **Serviced Apartment** | S$5,000-15,000 | Short-term, corporate |

### Key Platforms

**PropertyGuru (www.propertyguru.com.sg)**
- Largest property portal in Singapore
- 40,000+ rental listings
- Filter by MRT station, district, price
- Agent contact built-in
- Mobile app available

**99.co (www.99.co)**
- Modern interface, AI-powered search
- "Commute time" filter (show properties within X mins of office)
- No-agent listings available
- Price trends and insights

**Other Options:**
- **Carousell Property** - Direct owner listings
- **Facebook Groups** - "Singapore Expats", "Singapore Room Rental"
- **Agency Websites** - ERA, PropNex, OrangeTee

### Rental Process Step-by-Step

1. **Search Online** (1-2 weeks before arrival)
   - Set budget, preferred areas, property type
   - Shortlist 10-15 properties

2. **Schedule Viewings** (arrive in Singapore)
   - View properties in person (never rent sight-unseen)
   - Check for water pressure, air-con condition, natural light
   - Note distance to MRT, amenities

3. **Make an Offer**
   - Negotiate rent (5-10% negotiable in soft market)
   - Agree on lease terms (1-2 years typical)
   - Discuss what's included (furniture, maintenance)

4. **Letter of Intent (LOI)**
   - Sign LOI with 1 month's rent as good faith deposit
   - Deposit becomes part of security deposit if successful

5. **Tenancy Agreement (TA)**
   - Review carefully (diplomatic clause, early termination, pet policy)
   - Typical terms: 2-month security deposit, 1-month advance rent
   - Stamp duty: 0.4% of total rent (tenant pays half usually)

6. **Move In**
   - Document property condition with photos/video
   - Collect keys, remote controls, access cards
   - Get building management contacts

### Districts to Consider

| District | Character | Rent Level | Good For |
|----------|-----------|------------|----------|
| **District 9-10** (Orchard, River Valley) | Central, shopping | $$$$$ | Singles, professionals |
| **District 15** (East Coast, Katong) | Beach vibes, F&B | $$$$ | Families, expats |
| **District 11** (Newton, Novena) | Central, medical hub | $$$$ | Medical professionals |
| **District 5** (Clementi, West Coast) | Near NUS, greenery | $$$ | Academics, families |
| **District 19** (Serangoon, Kovan) | Suburban, food paradise | $$ | Families, budget |
| **District 22** (Jurong) | Industrial turning hip | $$ | Budget, West workers |

---

## 3. Setting Up Utilities

### SP Group (Electricity & Gas)
**Website:** www.spgroup.com.sg

**Opening an Account:**
1. Visit SP Group website
2. Create an account with Singpass (foreigners: FIN number)
3. Select "Open Utilities Account"
4. Provide: Tenancy agreement, passport, employment pass
5. Choose billing preferences (email recommended)
6. Account active within 1-2 business days

**Costs (2025):**
- Electricity: ~S$0.32/kWh
- Gas: ~S$0.21/kWh
- Average monthly bill: S$150-250 (depending on AC usage)

**Deposit:** S$300-500 (waived for Singpass users)

### Water (PUB)
- Usually bundled with SP Group
- Water tariff: S$2.74/1,000 litres
- Waterborne fee: S$0.64/1,000 litres
- Sanitary appliance fee: S$3/fitting/month

---

## 4. Internet & Broadband

### Major Providers

| Provider | Plan | Speed | Price/Month |
|----------|------|-------|-------------|
| **Singtel** | Fibre Broadband | 1Gbps | S$44.90 |
| **Singtel** | Fibre Broadband | 2Gbps | S$59.90 |
| **StarHub** | Home Broadband | 1Gbps | S$39.99 |
| **StarHub** | Home Broadband | 2Gbps | S$49.99 |
| **M1** | HomePac | 3Gbps | S$34.90 |
| **M1** | HomePac | 10Gbps | S$54.90 |
| **MyRepublic** | GAMER Pro | 1Gbps | S$37.99 |
| **ViewQwest** | Fibre | 2Gbps | S$49.99 |

**Best Value:** M1 offers best speeds for price; MyRepublic good for gamers (low latency)

**Setup Process:**
1. Check if building has fibre (most do)
2. Sign up online or call provider
3. Router delivered within 3-5 days
4. Self-install or schedule technician visit
5. Typical contract: 24 months (early termination fees apply)

**No Contract Options:**
- Circles.Life Broadband: Month-to-month
- SIMBA Telecom: Flexible plans

---

## 5. Mobile Plans

### Postpaid Plans (2025)

| Provider | Plan | Data | Price/Month |
|----------|------|------|-------------|
| **Singtel** | XO Plus 68 | 70GB | S$44.90 |
| **Singtel** | XO Plus 98 | 120GB | S$64.90 |
| **StarHub** | Mobile+ | 60GB | S$38/month |
| **M1** | Bespoke SIM-only | 60GB | S$25 |
| **M1** | Bespoke SIM-only | 350GB | S$55 |
| **Circles.Life** | Power Up | 100GB | S$28 |
| **GOMO** | SIM-only | 60GB | S$20 |
| **Giga** | Basic | 30GB | S$10 |

**Recommended for Expats:**
1. **Circles.Life** - No contract, app-based, good data
2. **GOMO** - Singtel network, no-frills, great value
3. **M1 Bespoke** - Customizable, good roaming

**For Tourists/Short-Term:**
- Singtel hi!Tourist SIM: S$18 for 100GB (7 days)
- StarHub Travel SIM: S$32 for 100GB (12 days)

**Getting a SIM:**
1. Visit any provider store (bring passport + employment pass)
2. Or order online with delivery
3. Port number from overseas (check if provider supports)
4. Activation instant for postpaid

---

## 6. Banking

### Major Local Banks

**DBS Bank** (www.dbs.com.sg)
- Largest bank in Southeast Asia
- Best digital banking app
- Extensive ATM network
- **Account types:** DBS Multiplier (cashback), POSB Everyday

**OCBC Bank** (www.ocbc.com.sg)
- Strong for investments
- Good for families (Frank account for kids)
- **Account types:** 360 Account, FRANK

**UOB Bank** (www.uob.com.sg)
- Strong in property financing
- Good rewards for dining
- **Account types:** One Account, EVOL

### Opening an Account (Foreigners)

**Requirements:**
- Passport
- Employment Pass / S Pass / Dependant's Pass
- Proof of address (tenancy agreement or utility bill)
- Initial deposit: S$0-500 depending on account

**Process:**
1. **Online Pre-registration** (recommended)
   - DBS: Fill form online → visit branch for verification
   - OCBC/UOB: Similar process

2. **Branch Visit** (15-30 mins)
   - Bring all documents
   - Verify identity
   - Sign forms
   - Receive debit card immediately or by mail

3. **Activation** (same day)
   - Download mobile app
   - Set up digital banking
   - Link to PayNow (mobile number)

### Digital Banks (Full Licenses)

| Bank | Min Deposit | Cards | Best For |
|------|-------------|-------|----------|
| **GXS Bank** (Grab-Singtel) | S$0 | Virtual | Grab users, cashback |
| **Trust Bank** (Standard Chartered) | S$0 | Virtual + Physical | Groceries (NTUC link) |
| **MariBank** (SeaMoney) | S$0 | Virtual | Shopee users |

**Digital Bank Advantages:**
- No minimum balance
- Higher savings interest (up to 2.5%)
- Fast account opening (minutes via app)
- Great for secondary accounts

### Multi-Currency Accounts
- **DBS Multi-Currency Account:** Hold 13 currencies
- **Wise:** Best for frequent forex
- **YouTrip:** Best for travel spending

---

## 7. Essential Apps to Download

### Daily Life
- **Singpass** - Digital ID (ESSENTIAL)
- **MyTransport.SG** - Bus/MRT arrivals
- **SimplyGo** - Transport payments
- **Grab** - Ride-hailing, food delivery
- **foodpanda** - Food delivery
- **WhatsApp** - Everyone uses it

### Shopping & Deals
- **Shopee** - Online marketplace
- **Lazada** - Online marketplace
- **Carousell** - Second-hand goods
- **Qoo10** - Korean/Japanese goods

### Government Services
- **LifeSG** - One-stop government app
- **TraceTogether** - Health services
- **Healthy365** - Health tracking, rewards

---

## 8. First Week Checklist

- [ ] Collect Employment Pass at MOM
- [ ] Open bank account
- [ ] Get mobile SIM
- [ ] Set up utilities account (SP Group)
- [ ] Register for Singpass
- [ ] Get EZ-Link card or set up SimplyGo
- [ ] Register with embassy (optional but recommended)
- [ ] Explore neighbourhood, find nearby:
  - Supermarket (FairPrice, Cold Storage, Giant)
  - Hawker centre
  - Clinic (register with GP)
  - MRT station

---

## Key Contacts

| Service | Contact |
|---------|---------|
| Police/Ambulance | 999 |
| Fire | 995 |
| Non-emergency Police | 1800-255-0000 |
| MOM (Employment Pass) | 6438-5122 |
| ICA (Immigration) | 6391-6100 |
| SP Group | 1800-222-2333 |

---

*Last updated: February 2026*
