# Singapore Neighborhoods Index

> Quick comparison guide for choosing where to live in Singapore

## Overview Map: Singapore's Regions

Singapore divides into three market segments for property:
- **CCR (Core Central Region)** - Districts 9, 10, 11, Downtown Core, Sentosa
- **RCR (Rest of Central Region)** - Surrounding central areas
- **OCR (Outside Central Region)** - Suburban areas

---

## Quick Comparison Table

| Area | Vibe | HDB Rent (3BR) | Condo Rent (2BR) | Commute to CBD | Best For |
|------|------|----------------|------------------|----------------|----------|
| **Marina Bay/CBD** | Corporate, upscale | N/A | $5,500-8,000 | 0-5 min | Finance professionals, singles |
| **Raffles Place/Tanjong Pagar** | Business + heritage | $2,800-3,500 | $4,500-7,000 | 0-10 min | Young professionals |
| **Orchard/Newton** | Shopping, expat hub | $3,000-4,000 | $5,000-8,000 | 10-15 min | Expats, luxury seekers |
| **River Valley/Robertson** | Nightlife, F&B | $2,800-3,500 | $4,500-6,500 | 10-15 min | Young professionals, singles |
| **Tiong Bahru** | Hipster, heritage | $2,500-3,200 | $4,000-5,500 | 10-15 min | Creatives, couples |
| **Katong/Joo Chiat** | Peranakan, foodie | $2,200-2,800 | $3,500-5,000 | 20-30 min | Foodies, families |
| **East Coast** | Beach lifestyle | $2,400-3,000 | $3,800-5,500 | 20-30 min | Expats, active lifestyle |
| **Bedok** | Suburban comfort | $2,000-2,600 | $3,000-4,200 | 25-35 min | Families, value seekers |
| **Tampines** | Self-sufficient hub | $1,900-2,400 | $2,800-4,000 | 30-40 min | Families, convenience |
| **Novena/Toa Payoh** | Central + affordable | $2,200-2,800 | $3,500-4,800 | 15-20 min | Families, professionals |
| **Bishan/Ang Mo Kio** | Family heartland | $2,000-2,600 | $3,200-4,500 | 20-25 min | Families with kids |
| **Holland Village** | Expat enclave | $2,800-3,500 | $4,200-6,000 | 15-20 min | Expats, social lifestyle |
| **Buona Vista/One-North** | Tech hub | $2,400-3,000 | $3,800-5,200 | 15-25 min | Tech workers, researchers |
| **Clementi/West Coast** | NUS area, quiet | $2,100-2,700 | $3,200-4,500 | 25-35 min | Academics, families |
| **Jurong** | Industrial turning hub | $1,800-2,400 | $2,600-3,800 | 35-45 min | Budget-conscious |
| **Woodlands** | Near JB, affordable | $1,600-2,200 | $2,400-3,500 | 45-55 min | Budget seekers, JB commuters |
| **Yishun** | Improving suburb | $1,700-2,300 | $2,500-3,600 | 40-50 min | Budget families |
| **Sembawang** | Quiet north | $1,600-2,100 | $2,300-3,400 | 45-55 min | Peace seekers |

*Rents as of 2025-2026; actual prices vary by specific unit and market conditions*

---

## Rental Price Ranges by Property Type (2025-2026)

### HDB Flats (Public Housing)
| Room Type | CCR/Mature | RCR | OCR/Non-Mature |
|-----------|------------|-----|----------------|
| 2-Room | $1,800-2,500 | $1,500-2,200 | $1,200-1,800 |
| 3-Room | $2,500-3,500 | $2,200-2,800 | $1,800-2,400 |
| 4-Room | $3,000-4,000 | $2,600-3,200 | $2,200-2,800 |
| 5-Room | $3,500-4,500 | $3,000-3,800 | $2,600-3,200 |
| Executive | $4,000-5,000 | $3,500-4,200 | $3,000-3,600 |

### Condominiums
| Size | CCR | RCR | OCR |
|------|-----|-----|-----|
| Studio/1BR | $3,500-5,500 | $2,800-4,000 | $2,200-3,200 |
| 2BR | $5,000-8,000 | $3,800-5,500 | $2,800-4,200 |
| 3BR | $6,500-12,000 | $5,000-7,500 | $3,800-5,500 |
| 4BR+ | $10,000-25,000+ | $7,000-12,000 | $5,000-8,000 |

### Landed Properties
| Type | Prime Districts | Other Areas |
|------|-----------------|-------------|
| Terrace | $8,000-15,000 | $5,000-10,000 |
| Semi-D | $12,000-25,000 | $8,000-15,000 |
| Bungalow | $20,000-50,000+ | $12,000-25,000 |
| GCB (Good Class Bungalow) | $35,000-80,000+ | N/A |

---

## Market Trends (January 2026)

Based on SRX market data:

### HDB Resale
- Prices increased **1.2%** month-on-month
- Year-on-year increase: **2.4%**
- 2,351 units transacted in January 2026
- 146 million-dollar HDB flats sold
- Highest transaction: **S$1,560,000** (5-room at Pinnacle @ Duxton)

### Condo Resale
- Overall prices decreased **0.8%** in December 2025
- Year-on-year increase: **3.9%**
- CCR prices down 2.7%, RCR down 1.1%, OCR up 1.3%

### Condo Rental
- Prices increased **0.2%** month-on-month
- Year-on-year increase: **1.6%**
- About 6,005 units rented in December 2025

### HDB Rental
- Prices increased **0.1%** month-on-month
- Year-on-year increase: **1.5%**
- About 2,768 HDB flats rented in December 2025

---

## Quick Decision Matrix

### By Budget (Monthly Rent)

| Budget | Best Areas | Property Type |
|--------|------------|---------------|
| < $2,000 | Woodlands, Yishun, Sembawang, Jurong | HDB 2-3 room |
| $2,000-3,000 | Bedok, Tampines, Ang Mo Kio, Clementi | HDB 3-4 room |
| $3,000-4,500 | Toa Payoh, Bishan, East Coast | HDB 4-5 room / OCR condo |
| $4,500-6,000 | Holland V, Tiong Bahru, Katong | RCR condo |
| $6,000-10,000 | Orchard, River Valley, Marina Bay | CCR condo |
| $10,000+ | Sentosa, prime D9/D10/D11 | Luxury condo/Landed |

### By Lifestyle

| Lifestyle | Recommended Areas |
|-----------|-------------------|
| **Beach & Sports** | East Coast, Bedok, Katong |
| **Nightlife & F&B** | River Valley, Robertson Quay, Club Street |
| **Shopping** | Orchard, Bugis, Somerset |
| **Nature & Parks** | Bishan, Bukit Timah, Sembawang |
| **Food Culture** | Tiong Bahru, Katong, Geylang, Old Airport Road |
| **Expat Community** | Holland Village, East Coast, Orchard |
| **Local Immersion** | Toa Payoh, Bedok, Ang Mo Kio |
| **Tech Scene** | One-North, Buona Vista, Paya Lebar |

### By Life Stage

| Stage | Best Areas |
|-------|------------|
| **Single Professional** | CBD, Tanjong Pagar, River Valley, Tiong Bahru |
| **Young Couple** | Tiong Bahru, Katong, Holland Village |
| **Family (Young Kids)** | Bishan, Bukit Timah, East Coast, Novena |
| **Family (School-Age)** | Near good schools - varies by school choice |
| **Retirees** | East Coast, Sembawang, quieter suburbs |

---

## MRT Lines Quick Reference

| Line | Color | Key Stations | Areas Served |
|------|-------|--------------|--------------|
| **North-South (NSL)** | Red | Jurong East, Orchard, City Hall, Woodlands | West-Central-North |
| **East-West (EWL)** | Green | Pasir Ris, Tampines, Bugis, Jurong | East-Central-West |
| **Circle (CCL)** | Orange | Dhoby Ghaut, Holland V, Harbourfront | Central loop |
| **Downtown (DTL)** | Blue | Bukit Panjang, Botanic Gardens, Chinatown, Expo | Northwest-Central-East |
| **North-East (NEL)** | Purple | Punggol, Serangoon, Dhoby Ghaut, Harbourfront | Northeast-Central |
| **Thomson-East Coast (TEL)** | Brown | Woodlands North, Orchard, Marina Bay, Gardens | North-Central-East Coast |

---

## Essential Links

- **Property Portals**: PropertyGuru, 99.co, SRX.com.sg
- **HDB Official**: hdb.gov.sg
- **URA Property Data**: ura.gov.sg/property-market-information
- **MRT Map**: lta.gov.sg/content/ltagov/en/getting_around/public_transport/rail_network.html

---

*Last updated: February 2026*
*Sources: SRX Flash Reports, HDB, URA, LTA*
