# Central Singapore & CBD

> Marina Bay, Raffles Place, Tanjong Pagar, Downtown Core

## Overview

The Central Business District (CBD) is Singapore's financial heart—a gleaming forest of skyscrapers housing major banks, law firms, and multinational headquarters. Living here means being at the center of everything: world-class dining, iconic landmarks, and zero commute if you work in finance or professional services.

---

## Sub-Areas

### Marina Bay
**The showcase of modern Singapore**

- **Character**: Ultra-modern, touristy, prestigious
- **Landmarks**: Marina Bay Sands, Gardens by the Bay, ArtScience Museum, The Fullerton
- **Housing**: Almost exclusively luxury condos and serviced apartments
- **Who Lives Here**: C-suite executives, wealthy expats, short-term corporate assignees
- **Typical Rent**:
  - 1BR condo: $4,500-6,500/month
  - 2BR condo: $6,500-10,000/month
  - 3BR condo: $10,000-18,000/month

**Key Developments**:
- Marina One Residences
- The Sail @ Marina Bay
- Marina Bay Residences
- V on Shenton

**MRT Stations**:
- Marina Bay (NSL, CCL, TEL)
- Bayfront (DTL, CCL)
- Downtown (DTL)
- Raffles Place (NSL, EWL)

**Commute to CBD**: You're already here! 0-5 minutes walk.

---

### Raffles Place
**The original financial district**

- **Character**: Corporate during day, quieter at night
- **Landmarks**: Singapore River, Boat Quay, The Fullerton Hotel, Cavenagh Bridge
- **Housing**: Limited residential options, mostly in nearby areas
- **Who Lives Here**: Finance professionals who want a literal 0-minute commute
- **Typical Rent**:
  - 1BR condo: $4,000-5,500/month
  - 2BR condo: $5,500-8,000/month

**Nearby Developments**:
- One Shenton
- 76 Shenton
- The Clift

**MRT Stations**:
- Raffles Place (NSL, EWL) - 0 min to office
- Telok Ayer (DTL) - 3 min walk

---

### Tanjong Pagar
**Heritage meets modern living**

- **Character**: Best of both worlds—corporate area with heritage shophouses, excellent F&B
- **Landmarks**: Tanjong Pagar Railway Station (heritage), Guoco Tower, Amoy Street
- **Housing**: Mix of older condos, new launches, and shophouse conversions
- **Who Lives Here**: Young professionals, lawyers, startup founders, couples
- **Why Popular**: Walkable to CBD, vibrant dining scene, upcoming Greater Southern Waterfront

**Typical Rent**:
- HDB (rare): $2,800-3,500/month (4-room)
- 1BR condo: $3,500-5,000/month
- 2BR condo: $4,500-7,000/month
- 3BR condo: $6,500-10,000/month
- Shophouse unit: $3,500-6,000/month

**Key Developments**:
- Wallich Residence (tallest residential in Singapore)
- Altez
- Icon
- Skysuites @ Anson
- The Pinnacle @ Duxton (iconic HDB)

**MRT Stations**:
- Tanjong Pagar (EWL)
- Maxwell (TEL)
- Shenton Way (TEL)

**Commute to CBD**: 5-10 minutes walk/MRT

---

### Chinatown/Outram
**Cultural heritage + accessibility**

- **Character**: Historic, touristy but charming, affordable dining
- **Landmarks**: Buddha Tooth Relic Temple, Chinatown Heritage Centre, People's Park
- **Housing**: Mix of older HDB, condos, and shophouse conversions
- **Who Lives Here**: Mix of locals, expats who appreciate culture, budget-conscious professionals

**Typical Rent**:
- HDB: $2,200-3,000/month (3-room)
- 1BR condo: $3,000-4,500/month
- 2BR condo: $4,000-5,500/month

**Key Developments**:
- The Clift
- Spottiswoode Residences
- Everton residences

**MRT Stations**:
- Chinatown (NEL, DTL)
- Outram Park (NEL, EWL, TEL)

---

## Lifestyle & Amenities

### Dining
- **Fine Dining**: Odette, Burnt Ends, Jaan (sky-high views)
- **Casual**: Amoy Street Food Centre, Lau Pa Sat, Maxwell Food Centre
- **Bars**: Boat Quay strip, Club Street, Telok Ayer
- **Coffee**: Common Man Coffee Roasters, Oriole Coffee

### Shopping
- **Malls**: Marina Bay Sands Shoppes, Suntec City, Raffles City
- **Daily Needs**: Limited supermarkets, mainly FairPrice Finest or specialty grocers

### Recreation
- **Parks**: Gardens by the Bay, Marina Barrage, Fort Canning
- **Fitness**: Premium gyms in office buildings, True Fitness, Fitness First
- **Water Activities**: Marina Bay waterfront, kayaking

### Healthcare
- **Hospitals**: Singapore General Hospital (Outram), Raffles Hospital
- **Clinics**: Many private clinics in office buildings

---

## Schools Nearby

Not a primary area for families, but accessible to:
- **International**: ISS International (nearby), UWCSEA (Dover, 20 min)
- **Local**: River Valley Primary, Cantonment Primary

---

## Pros & Cons

### Pros ✓
- Zero commute if you work in CBD
- World-class dining and entertainment
- Iconic views and prestigious address
- Best public transport connectivity
- Walking distance to everything
- Singapore's showcase—impressive for visitors

### Cons ✗
- **Very expensive** rent and dining
- Can feel sterile/corporate, especially weekends
- Limited supermarkets and daily amenities
- Tourist crowds around Marina Bay
- Noise from entertainment areas (Boat Quay, Club Street)
- Not family-friendly (few schools, playgrounds)
- Limited green space for daily use

---

## Who Should Live Here

**Ideal for:**
- Finance and legal professionals with CBD offices
- Singles and couples prioritizing convenience over space
- Those on generous corporate housing allowances
- Short-term assignees (1-2 years)
- People who value prestige and views

**Not ideal for:**
- Families with children
- Budget-conscious renters
- Those seeking community/neighborhood feel
- People who need a car (parking is expensive)
- Those who prefer quiet evenings

---

## Rental Market Tips

1. **Negotiate hard** - CBD has high vacancy rates, especially for larger units
2. **Check noise levels** - Boat Quay/Club Street areas can be loud on weekends
3. **Ask about A/C costs** - Floor-to-ceiling glass = high cooling bills
4. **Serviced apartments** - Often better value for short stays (<6 months)
5. **Pinnacle @ Duxton** - If you can get it, it's the best HDB value in CBD area

---

## Getting Around

### From Marina Bay to:
| Destination | MRT | Taxi/Grab |
|-------------|-----|-----------|
| Orchard Road | 10 min | 10-15 min |
| Changi Airport | 40 min | 25 min |
| Sentosa | 20 min | 15 min |
| Holland Village | 25 min | 20 min |
| Jurong East | 35 min | 30 min |

---

## Average Monthly Budget

| Category | Single | Couple |
|----------|--------|--------|
| Rent (1BR/2BR condo) | $4,500-5,500 | $6,000-8,000 |
| Utilities | $100-150 | $150-200 |
| Food (eating out) | $800-1,200 | $1,200-1,800 |
| Transport | $50-100 | $100-150 |
| Entertainment | $300-500 | $400-700 |
| **Total** | **$5,750-7,450** | **$7,850-10,850** |

---

## Recent Developments (2024-2026)

- **Greater Southern Waterfront** transformation ongoing
- **Thomson-East Coast Line** fully operational through CBD
- **Tanjong Pagar** increasingly popular as "new CBD" with better lifestyle mix
- Rental prices stabilizing after post-COVID surge
- More co-living options emerging for young professionals

---

*Last updated: February 2026*
