# Singapore Local Services Guide 2024-2026
## Government Services, Healthcare & Essential Systems

---

## 1. Singpass (Digital ID)

### What is Singpass?
Singpass is Singapore's national digital identity system - essential for accessing all government services and many private services.

### Who Needs It?
- Singapore Citizens
- Permanent Residents
- Employment Pass / S Pass holders
- Dependant's Pass holders
- Long-Term Visit Pass holders
- Student Pass holders (certain)

### Registration Process

#### For EP/S Pass Holders
**Step 1: Receive Foreign Identification Number (FIN)**
- Issued when your pass is approved
- Found on your In-Principle Approval letter

**Step 2: Register Online**
1. Visit **www.singpass.gov.sg**
2. Click "Register for Singpass"
3. Enter your FIN and personal details
4. Verify your identity via:
   - In-person at a Singpass counter (fastest)
   - Video call verification
   - Post (takes 5-7 business days)

**Step 3: Download Singpass App**
- Available on iOS and Android
- Set up biometric login (Face ID / fingerprint)
- Enable 2FA (mandatory)

**Step 4: Activate Account**
- First login online to set password
- App will prompt for setup

### Singpass Features

| Feature | Use For |
|---------|---------|
| **Login** | Access 2,700+ government & business services |
| **Myinfo** | Pre-fill forms with verified personal data |
| **Digital IC** | Show ID on phone instead of physical card |
| **Sign** | Digitally sign documents |
| **Verify** | Prove identity in person (QR code) |

### Common Services via Singpass
- MOM services (employment pass renewal)
- IRAS (tax filing)
- CPF (retirement funds)
- HDB (housing applications)
- ICA (passport renewal, immigration)
- SP Group (utilities)
- Bank account opening
- Medical records (HealthHub)

### Singpass Locations for In-Person Registration
- Singpass counters at Community Centres
- ServiceSG centres (various locations)
- CPF Service Centres

---

## 2. Government Services Portal

### Key Government Websites

| Agency | Website | Purpose |
|--------|---------|---------|
| **MOM** | mom.gov.sg | Employment, work passes |
| **ICA** | ica.gov.sg | Immigration, PR, citizenship |
| **IRAS** | iras.gov.sg | Taxes |
| **HDB** | hdb.gov.sg | Public housing |
| **MOH** | moh.gov.sg | Healthcare |
| **NEA** | nea.gov.sg | Environment, hawker centres |
| **LTA** | lta.gov.sg | Transport |
| **SP Group** | spgroup.com.sg | Utilities |

### LifeSG App
One-stop app for government services:
- Profile information
- Guide to life events (having a baby, getting married, etc.)
- Benefits calculator
- Service reminders

---

## 3. Postal Services (SingPost)

### Post Office Locations
- 50+ post offices island-wide
- Located in heartland malls, MRT stations
- Hours: Typically 8:30 AM - 6:00 PM (Mon-Fri), 8:30 AM - 1:00 PM (Sat)

### Domestic Mail

| Service | Cost | Delivery |
|---------|------|----------|
| Regular letter (1st local) | S$0.40 | 1-2 days |
| Regular letter (2nd local) | S$0.28 | 2-3 days |
| Registered mail | S$2.60+ | 1-2 days |
| Local courier (Speedpost) | S$5.50+ | Same/next day |

### International Mail

| Service | Cost (to USA/UK) | Delivery |
|---------|------------------|----------|
| Airmail letter | S$1.50+ | 5-7 days |
| Registered mail | S$5.50+ | 5-7 days |
| Speedpost Express | S$40-80 | 2-4 days |
| EMS (Express) | S$30-60 | 3-5 days |

### Alternatives to SingPost
| Provider | Best For |
|----------|----------|
| DHL | International express |
| FedEx | International express |
| Ninja Van | E-commerce, local |
| Lalamove | Same-day local |
| Grab Express | Same-day local |

### POPStation (Parcel Lockers)
- 24/7 self-collection lockers
- Found at HDB void decks, MRT stations
- Free collection from many e-commerce deliveries

---

## 4. Healthcare System

### Healthcare Structure

| Tier | Examples | Purpose |
|------|----------|---------|
| **Primary** | Polyclinics, GP clinics | First-line care |
| **Secondary** | Restructured hospitals | Specialist care |
| **Tertiary** | National centres | Complex/specialized |

### Public Healthcare

#### Polyclinics
Government primary care clinics (18 locations):
- **Consultation fee:** S$25.50 (subsidized citizens) to S$55 (foreigners)
- Services: General illness, chronic disease, dental, vaccinations
- Appointment via HealthHub app or walk-in (longer wait)

**Main Operators:**
- SingHealth Polyclinics
- National Healthcare Group Polyclinics

#### Public Hospitals

| Hospital | Location | Specialties |
|----------|----------|-------------|
| Singapore General Hospital (SGH) | Outram | Largest, full-service |
| National University Hospital (NUH) | Kent Ridge | Teaching hospital |
| Tan Tock Seng Hospital (TTSH) | Novena | Infectious disease |
| Changi General Hospital (CGH) | Simei | Eastern region |
| Khoo Teck Puat Hospital (KTPH) | Yishun | Northern region |
| Ng Teng Fong General Hospital | Jurong | Western region |

**Costs (Foreigners):**
- A&E visit: S$150-300
- Outpatient specialist: S$100-200
- Inpatient (ward): S$200-500/day
- Inpatient (private room): S$500-1,500/day

### Private Healthcare

#### Private Hospitals
| Hospital | Notes |
|----------|-------|
| Mount Elizabeth | Premium, CBD location |
| Gleneagles | Premium, Orchard area |
| Raffles Hospital | Large, comprehensive |
| Thomson Medical | Women & children focus |
| Parkway East | Eastern region |

**Costs:** 2-3x public hospital rates

#### GP Clinics
- Found everywhere (HDB void decks, malls)
- Consultation: S$30-60
- Walk-in, no appointment usually needed
- After-hours clinics available (24/7)

### Healthcare Registration

**For Employment Pass Holders:**
1. No mandatory registration
2. Can access any clinic/hospital
3. **Recommended:** Register with a GP near home
4. Download **HealthHub** app for medical records

**For PRs:**
1. Enroll in MediShield Life (compulsory)
2. Contribute to CPF MediSave
3. Can use subsidized public healthcare

### Health Insurance

**MediShield Life** (PRs & Citizens only):
- Basic hospitalization insurance
- Government-administered
- Premiums deducted from CPF

**Private Insurance Options:**
| Provider | Notes |
|----------|-------|
| AIA | Large, comprehensive |
| Prudential | Popular for expatriates |
| Great Eastern | Local major |
| Cigna | International coverage |
| Bupa | International coverage |

**What to Look For:**
- Outpatient coverage
- Specialist coverage
- Hospital coverage (public/private)
- Pre-existing conditions policy
- Evacuation coverage (for travel)

---

## 5. CPF (Central Provident Fund)

### What is CPF?
Singapore's mandatory savings scheme for retirement, healthcare, and housing.

### Who Contributes?
- Singapore Citizens: Yes (mandatory)
- PRs: Yes (mandatory)
- Employment Pass holders: **No** (not eligible)
- S Pass holders: **No** (not eligible)

### CPF for PRs

**Contribution Rates (2025):**
| Age | Employee | Employer | Total |
|-----|----------|----------|-------|
| ≤55 | 20% | 17% | 37% |
| 55-60 | 16% | 15% | 31% |
| 60-65 | 10.5% | 11.5% | 22% |
| >65 | 7.5% | 9% | 16.5% |

**CPF Accounts:**
| Account | Purpose | Allocation (≤55) |
|---------|---------|------------------|
| Ordinary (OA) | Housing, education, investment | 23% |
| Special (SA) | Retirement | 6% |
| MediSave (MA) | Healthcare | 8% |

**PRs Converting:**
- First 2 years: Reduced contribution rates
- Year 3+: Full rates

### What CPF Can Be Used For (PRs)
- Buy HDB flat / private property
- Pay for hospitalization
- Education (local universities)
- Retirement payouts (from 55+)
- Investment (CPFIS)

---

## 6. Housing for PRs

### HDB Eligibility (PRs)
PRs can buy **resale HDB flats** (not new BTO):
- Must form an eligible family nucleus
- Subject to quota limits (to ensure diversity)
- 5-year Minimum Occupation Period (MOP)

**Quota Limits:**
- Malay quota: ~25%
- Chinese quota: ~87%
- Indian/Others quota: ~13%

If quota is reached in a block, PRs of that ethnicity cannot buy there.

### Property Purchase Process (PRs)
1. Apply for HLE (HDB Loan Eligibility) or bank loan
2. Engage property agent
3. Find flat within budget and quota
4. Pay Option Fee (S$1,000-5,000)
5. Exercise Option (within 21 days)
6. Complete purchase (~8 weeks)

### Additional Buyer's Stamp Duty (ABSD)
PRs pay extra stamp duty on property:

| Buyer Type | ABSD Rate |
|------------|-----------|
| PR buying 1st property | 5% |
| PR buying 2nd property | 30% |
| Foreigner buying any | 60% |

**Example:** S$1,000,000 condo for PR = S$50,000 ABSD (first property)

---

## 7. Education System

### For EP/PR Families

#### Local Schools (PRs)
PR children can attend local public schools:
- Primary: S$230/month
- Secondary: S$440/month
- Junior College: S$560/month

**Admission:** Subject to availability, citizens prioritized

#### International Schools
Foreigners and PRs often choose international schools:

| School | Curriculum | Annual Fee |
|--------|------------|------------|
| Singapore American School (SAS) | American | S$45,000 |
| United World College (UWCSEA) | IB | S$55,000 |
| Tanglin Trust School | British | S$40,000 |
| Australian International School | Australian/IB | S$35,000 |
| Canadian International School | Canadian/IB | S$38,000 |
| German European School | German/IB | S$28,000 |
| ISS International School | IB | S$35,000 |

**Waitlists:** Popular schools have 1-2 year waitlists. Apply early!

---

## 8. Driving & Vehicle Services

### OneMotoring (onemotoring.lta.gov.sg)
Online portal for all vehicle-related services:
- Road tax renewal
- Vehicle transfer
- COE bidding
- Check demerit points
- Book driving test

### License Services
| Service | Where | Cost |
|---------|-------|------|
| Foreign license conversion | Traffic Police HQ | S$50 |
| New license application | Driving centre | S$25 |
| License renewal | Online or Post Office | S$50 |
| IDP application | AA Singapore | S$20 |

---

## 9. Essential Apps to Download

### Government
| App | Purpose |
|-----|---------|
| **Singpass** | Digital ID (essential!) |
| **LifeSG** | One-stop government services |
| **HealthHub** | Medical records, appointments |
| **myENV** | Weather, air quality |
| **MyTransport.SG** | Public transport info |
| **SimplyGo** | Transport payments |
| **OneService** | Report municipal issues |
| **Police@SG** | Crime reporting, e-services |

### Daily Life
| App | Purpose |
|-----|---------|
| **Grab** | Transport, food, payments |
| **DBS/OCBC/UOB** | Banking |
| **GrabPay/PayNow** | Digital payments |
| **Shopee** | Online shopping |
| **FairPrice** | Grocery shopping |
| **WhatsApp** | Everyone uses it |

### Utilities
| App | Purpose |
|-----|---------|
| **SP Group** | Electricity/gas bills |
| **SimplyGo** | Transport card management |
| **SingPost** | Track parcels |

---

## 10. Emergency Services

### Emergency Numbers
| Service | Number |
|---------|--------|
| Police / Ambulance / Fire | 999 |
| Ambulance / Fire | 995 |
| Non-Emergency Police | 1800-255-0000 |
| Non-Emergency Ambulance | 1777 |

### Other Helplines
| Service | Number |
|---------|--------|
| Samaritans of Singapore (SOS) | 1800-221-4444 |
| IMH Mental Health Helpline | 6389-2222 |
| AWARE Women's Helpline | 1800-777-5555 |
| ComCare (social assistance) | 1800-222-0000 |
| Immigration (ICA) | 6391-6100 |
| MOM (employment) | 6438-5122 |

### Hospitals with 24/7 A&E
- Singapore General Hospital
- Tan Tock Seng Hospital
- National University Hospital
- Changi General Hospital
- All major hospitals

---

## 11. Community & Social Services

### Community Centres (CCs)
Every neighborhood has a CC offering:
- Courses (languages, cooking, fitness)
- Event spaces
- Government service counters
- Community activities
- Singpass registration

**Find your CC:** www.pa.gov.sg

### Libraries
**National Library Board** operates 26 public libraries:
- Free membership (register online)
- Borrow books, magazines, DVDs
- Study spaces
- Digital resources (eBooks, magazines, newspapers)
- Programs and events

**Hours:** Typically 10 AM - 9 PM (varies)

### Citizen Services
**ServiceSG Centres** (one-stop government service):
- Locations in various malls
- Help with multiple agencies
- Walk-in available
- Translation services

---

## 12. Settling In Checklist

### Week 1
- [ ] Collect Employment Pass
- [ ] Open bank account
- [ ] Get mobile phone
- [ ] Set up Singpass
- [ ] Apply for utilities
- [ ] Download essential apps

### Month 1
- [ ] Register for healthcare (find GP)
- [ ] Get EZ-Link card / set up SimplyGo
- [ ] Explore neighborhood
- [ ] Join expat groups / communities
- [ ] Register with embassy (optional)

### First 6 Months
- [ ] File taxes (if applicable)
- [ ] Understand EP renewal process
- [ ] Consider health insurance
- [ ] Build emergency fund (3-6 months expenses)
- [ ] Explore PR application (if long-term)

---

## 13. Useful Resources

### Official Government
- **gov.sg** - Main government portal
- **mom.gov.sg** - Employment matters
- **ica.gov.sg** - Immigration
- **singpass.gov.sg** - Digital ID

### Expat Communities
- **Internations.org** - Expat events, networking
- **MeetUp.com** - Interest groups
- **Facebook Groups** - "Singapore Expats", "Expats in Singapore"
- **HWZ Forums** - Local discussions

### News & Information
- **The Straits Times** - Main newspaper
- **CNA** - Channel NewsAsia
- **Today Online** - Free news
- **Reddit r/singapore** - Local discussions

---

*Last updated: February 2026*
