# Singapore Healthcare Guide

## Overview: World-Class Healthcare System

Singapore consistently ranks among the world's best healthcare systems:
- **WHO Ranking**: 6th globally (2000, latest official ranking)
- **Bloomberg Efficiency**: Most efficient healthcare system (2014)
- **Life Expectancy**: 84.8 years (highest in the world as of 2019)
- **Economist Intelligence Unit**: 2nd out of 166 countries for outcomes

### Key Characteristics
- Mixed public-private system
- High quality, relatively affordable for citizens/PRs
- Expensive for foreigners without insurance
- Medical tourism destination
- Government subsidies based on means testing

---

## Healthcare Providers: Public vs Private

### Public Healthcare System

Organized into **three healthcare clusters**:

| Cluster | Major Hospitals | Specialty |
|---------|-----------------|-----------|
| **SingHealth** | Singapore General Hospital (SGH), KK Women's & Children's, Changi General | Largest cluster, cancer center |
| **National Healthcare Group** | Tan Tock Seng (TTSH), Khoo Teck Puat (KTPH) | Infectious diseases, rehabilitation |
| **National University Health System** | National University Hospital (NUH), Ng Teng Fong General | Academic medicine, transplants |

**Total: 11 public hospitals**
- 9 general hospitals
- 2 specialized (KK Women's & Children's, Institute of Mental Health)

### Public vs Private Comparison

| Aspect | Public | Private |
|--------|--------|---------|
| **Cost** | Subsidized (50-80% for citizens) | Full price, often 3-5x public |
| **Wait Time** | Can be long for non-urgent | Minimal wait |
| **Ward Classes** | A/B1/B2/C (different amenities) | Usually single rooms |
| **Doctor Choice** | Limited | Full choice |
| **Appointment Booking** | Can take weeks | Usually within days |
| **Quality** | Excellent | Excellent |

### Major Private Hospital Groups

| Group | Hospitals | Notes |
|-------|-----------|-------|
| **Parkway Pantai** | Mount Elizabeth, Gleneagles, Parkway East | Premium, expat-focused |
| **Raffles Medical Group** | Raffles Hospital | Central location, comprehensive |
| **Thomson Medical** | Thomson Medical Centre | Women's & children's specialty |

---

## Primary Care: Polyclinics vs GP Clinics

### Government Polyclinics
- **Number**: 23 across Singapore
- **Cost**: S$15-20 per visit (citizens/PRs)
- **Services**: General consultation, chronic disease management, vaccinations, dental
- **Wait time**: Often 1-2 hours
- **Advantages**: Cheapest option, integrated with public hospital system

### Private GP Clinics
- **Cost**: S$40-100+ per visit
- **Services**: Similar to polyclinics, faster
- **Wait time**: Usually under 30 minutes
- **Advantages**: Convenience, speed, relationships with doctor

### For Expats
- Most use private GPs
- Polyclinics technically available but minimal subsidies
- Many expats use medical center networks (Raffles Medical, Parkway Shenton, International Medical Clinic)

---

## Healthcare Costs (2025)

### Outpatient Care

| Service | Public (Subsidized) | Private |
|---------|---------------------|---------|
| GP consultation | S$15-25 | S$40-120 |
| Specialist consultation | S$40-100 | S$150-400 |
| X-ray | S$20-50 | S$80-200 |
| Blood tests (basic) | S$20-50 | S$50-200 |
| Dental cleaning | S$25-45 | S$80-200 |
| Dental extraction | S$30-80 | S$150-500 |

### Inpatient Care (Daily Rates)

| Ward Class | Cost/Day | Amenities |
|------------|----------|-----------|
| **Class C** | S$35-50 | 8+ beds, no aircon, highest subsidy |
| **Class B2** | S$50-80 | 5-6 beds, aircon |
| **Class B1** | S$200-400 | 4 beds, aircon, TV |
| **Class A** | S$450-700 | Single room |
| **Private Hospital** | S$500-1,500+ | Single room, premium |

### Common Procedure Costs

| Procedure | Public (B2 class) | Private |
|-----------|-------------------|---------|
| Natural delivery | S$3,000-5,000 | S$10,000-20,000 |
| C-section | S$8,000-12,000 | S$18,000-35,000 |
| Appendectomy | S$4,000-7,000 | S$15,000-25,000 |
| Knee replacement | S$15,000-25,000 | S$40,000-60,000 |
| Cardiac bypass | S$30,000-50,000 | S$80,000-150,000 |
| MRI scan | S$300-500 | S$800-1,500 |

---

## National Healthcare Schemes (Citizens/PRs Only)

### The 3Ms System

#### 1. MediSave (Mandatory Savings)
- **What**: Medical savings account under CPF
- **Contribution**: 8-10.5% of wages (employer+employee)
- **Cap**: S$68,500 (2024)
- **Use for**: Hospital bills, approved outpatient procedures, premiums
- **Family pooling**: Can use for immediate family members

#### 2. MediShield Life (Basic Insurance)
- **What**: Universal catastrophic health insurance
- **Coverage**: Large hospital bills, some outpatient treatments
- **Premiums**: Age-based, payable from MediSave
- **Lifetime coverage**: No claim limits, no exclusions for pre-existing
- **Annual claim limit**: S$150,000 for B2/C wards

#### 3. MediFund (Safety Net)
- **What**: Government endowment fund for the needy
- **For whom**: Singaporeans who've exhausted MediSave/MediShield
- **Coverage**: Last resort assistance

### Integrated Shield Plans (IP)
- Private insurance that sits on top of MediShield Life
- Provides higher coverage (private hospitals, Class A wards)
- Offered by: AIA, Great Eastern, Income, Prudential, Singlife, etc.
- **Premiums**: S$200-2,000+/year depending on age and coverage

---

## Healthcare for Expats

### The Reality
- **No access to MediSave/MediShield** (unless PR)
- **No subsidies** at public hospitals
- **Private insurance essential**

### Insurance Options

#### Employer-Provided
Most expat packages include:
- Hospitalization coverage
- Outpatient coverage (often with panel clinics)
- Check: limits, deductibles, panel restrictions

#### Private Insurance Providers

| Provider | Type | Approximate Annual Premium |
|----------|------|----------------------------|
| Cigna Global | International | S$5,000-15,000 (family) |
| BUPA Global | International | S$5,000-18,000 (family) |
| Allianz Partners | International | S$4,000-12,000 (family) |
| AXA | Local/International | S$3,000-10,000 (family) |
| Great Eastern | Local | S$2,000-8,000 (family) |

### What to Look For in Expat Insurance
1. **Direct billing** vs reimbursement
2. **Hospital network** (Mt Elizabeth, Raffles, Gleneagles access)
3. **Outpatient coverage** limits
4. **Maternity coverage** (usually 12-month waiting period)
5. **Evacuation coverage** for complex cases
6. **Pre-existing conditions** exclusions
7. **Mental health** coverage
8. **Dental/vision** (often separate)

### Typical Expat Healthcare Costs WITHOUT Insurance

| Scenario | Cost |
|----------|------|
| GP visit + common cold meds | S$60-100 |
| Specialist consultation | S$200-400 |
| Emergency room visit (minor) | S$500-1,500 |
| 3-day hospital stay (private) | S$5,000-15,000 |
| Natural childbirth (private) | S$15,000-25,000 |
| C-section (private) | S$25,000-40,000 |

---

## Medical Tourism

Singapore attracts ~500,000 medical tourists annually, primarily from:
- Indonesia
- Malaysia
- China
- Middle East
- Myanmar

### Why Singapore?
- World-class facilities
- English-speaking doctors
- Transparent pricing
- Short waiting times
- Clean, safe environment

### Popular Medical Tourism Procedures
- Cancer treatment
- Cardiac surgery
- Orthopedics
- Fertility treatment (IVF)
- Health screenings
- Cosmetic surgery

### Costs vs Other Countries

| Procedure | Singapore | USA | Thailand |
|-----------|-----------|-----|----------|
| Heart bypass | S$40K-60K | S$150K+ | S$20K-30K |
| Hip replacement | S$25K-40K | S$80K+ | S$15K-20K |
| Face lift | S$15K-25K | S$30K+ | S$5K-10K |

---

## Emergency Services

### Emergency Numbers
- **Ambulance/Fire**: 995
- **Police**: 999
- **Non-emergency ambulance**: 1777

### Emergency Departments
- Available at all public hospitals
- Private EDs: Mt Elizabeth, Raffles, Gleneagles
- Triage system: life-threatening cases prioritized

### Typical ED Wait Times
- **P1 (Critical)**: Immediate
- **P2 (Emergency)**: 15-30 minutes
- **P3 (Urgent)**: 1-2 hours
- **P4 (Non-urgent)**: 2-4+ hours

### ED Costs
| Type | Public (unsubsidized) | Private |
|------|----------------------|---------|
| Consultation only | S$120-200 | S$300-500 |
| With tests/treatment | S$300-1,000 | S$500-2,000+ |

---

## Specialist Care

### Common Wait Times (Public)
| Specialty | Wait Time |
|-----------|-----------|
| General surgery | 2-4 weeks |
| Orthopedics | 4-8 weeks |
| Cardiology | 3-6 weeks |
| Oncology | 1-2 weeks (urgent) |
| Dermatology | 4-12 weeks |
| Psychiatry | 4-8 weeks |

### Private Specialist Access
- Usually within 1-7 days
- Cost: S$200-500 per consultation
- Some require GP referral for insurance claims

---

## Mental Health

### Public Options
- **Institute of Mental Health (IMH)**: Main public psychiatric hospital
- **Community mental health teams**: Outreach programs
- Wait times can be long (weeks to months)

### Private Options
- **Psychiatrists**: S$200-500 per session
- **Psychologists**: S$150-350 per session
- **Counselors**: S$100-200 per session

### Insurance Coverage
- Historically poor
- Improving: MediShield Life now covers some psychiatric conditions
- Private insurance varies widely

### Resources
- **Singapore Association for Mental Health**: 1800-283-7019
- **IMH Helpline**: 6389-2222
- **Samaritans of Singapore**: 1800-221-4444

---

## Pregnancy & Childbirth

### Types of Care
1. **Public hospital** (subsidized if citizen/PR)
2. **Private hospital** (full cost)
3. **Hybrid**: Public OB-GYN, private delivery

### Costs Breakdown

| Item | Public (B2) | Private |
|------|-------------|---------|
| Prenatal visits (9 months) | S$500-1,000 | S$2,000-4,000 |
| Natural delivery | S$3,000-5,000 | S$10,000-20,000 |
| C-section (elective) | S$6,000-10,000 | S$18,000-35,000 |
| Epidural | S$500-1,000 | S$1,500-3,000 |
| NICU (per day) | S$500-1,000 | S$1,500-3,000 |

### Popular Private Hospitals for Delivery
1. Mount Elizabeth (Orchard & Novena)
2. Thomson Medical Centre
3. Raffles Hospital
4. Gleneagles

### Maternity Leave
- **Mothers**: 16 weeks (citizens), 8 weeks (others)
- **Fathers**: 2 weeks (citizens), varies (others)

---

## Dental Care

### Public Dental Clinics
- Available at polyclinics
- Heavily subsidized for citizens/PRs
- Long waits for non-emergency

### Private Dental
- **Checkup + cleaning**: S$80-200
- **Filling**: S$100-300
- **Root canal**: S$600-1,500
- **Crown**: S$800-2,000
- **Braces**: S$3,500-8,000
- **Implant**: S$3,000-6,000

### Recommended Approach
- Regular cleanings at private clinics
- Major work: get quotes from multiple dentists
- Insurance often excludes dental or has low limits

---

## Practical Healthcare Tips for Expats

### Getting Set Up
1. **Find a GP** near home/work before you need one
2. **Register with a panel clinic** if employer has corporate plan
3. **Keep insurance card/details** accessible
4. **Download app** (Parkway/Raffles apps for appointments)

### Cost Saving Tips
1. **Use public polyclinics** for minor issues (unsubsidized but still cheaper)
2. **Telemedicine**: Doctor Anywhere, WhiteCoat, MyDoc (S$25-40)
3. **Generic medications**: Ask pharmacist
4. **Health screenings**: Public hospitals often cheaper
5. **Dental tourism**: Some go to JB Malaysia for major work (30-50% cheaper)

### When to Seek Care Where

| Situation | Where to Go |
|-----------|-------------|
| Minor illness | Private GP or polyclinic |
| After-hours non-emergency | 24-hour clinic (Raffles, Shenton) |
| True emergency | ED (public faster for serious; private for convenience) |
| Specialist need | Private if insured; public if cost-sensitive |
| Chronic disease | Polyclinic for cost; private for convenience |
| Major surgery | Depends on insurance; public quality is excellent |

---

## Summary: Key Takeaways

1. **Quality is excellent** across both public and private systems
2. **Insurance is essential** for expats - don't rely on paying out of pocket
3. **Public healthcare** is surprisingly good and cheaper even without subsidies
4. **Wait times** are the main trade-off between public and private
5. **Comprehensive employer coverage** is a major factor in job negotiations
6. **PRs get access** to MediSave/MediShield - significant benefit
7. **Mental health** services are improving but still limited
8. **Maternity** is expensive at private hospitals - plan accordingly
