# Singapore Dining Practical Guide

Everything you need to know about eating in Singapore — from finding halal food to navigating alcohol rules.

---

## 🕌 Halal Options

Singapore has a significant Muslim population (~14%), so halal food is widely available.

### Halal Hawker Centres
Many hawker centres have dedicated halal sections or certified stalls.

| Hawker Centre | Halal Options |
|---------------|---------------|
| **Tekka Centre** | Most stalls halal (Little India) |
| **Kampong Glam** | Arab Street area, many halal |
| **Adam Road Food Centre** | Nasi lemak heaven |
| **Geylang Serai Market** | Malay food paradise |
| **Changi Village Hawker Centre** | Nasi lemak, Indian |

### Popular Halal Dishes

| Dish | Where to Find |
|------|---------------|
| **Nasi Lemak** | The Coconut Club, Ponggol, Boon Lay Power |
| **Mee Rebus** | Geylang Serai, Adam Road |
| **Murtabak** | Zam Zam, Singapore Zam Zam |
| **Roti Prata** | Most Indian-Muslim stalls |
| **Biryani** | Bismillah, Allauddin's, Zam Zam |
| **Satay** | Lau Pa Sat (some stalls) |
| **Nasi Padang** | Hjh Maimunah, Rumah Makan Minang |

### How to Identify Halal Stalls
- **MUIS certification:** Look for official halal logo (crescent moon)
- **"Muslim-owned":** Often indicated on signage
- **Malay/Indian-Muslim stalls:** Usually halal
- **Ask:** Staff are helpful about halal status

### Top Halal Restaurants

| Restaurant | Cuisine | Price |
|------------|---------|-------|
| **Hjh Maimunah** | Malay, Nasi Padang | $10-20 |
| **Zam Zam** | Indian-Muslim, murtabak | $8-15 |
| **Bismillah Biryani** | Biryani | $10-18 |
| **The Coconut Club** | Nasi Lemak | $15-25 |
| **Padi@Marrison** | Malay | $20-35 |
| **Tipo Pasta Bar** | Italian (halal) | $20-35 |
| **Streats Hong Kong Cafe** | Hong Kong | $15-25 |

### Important Note
- Chinese hawker stalls are generally **not halal** (pork, lard)
- When in doubt, ask before ordering
- Halal food courts exist in malls (look for "Muslim" signage)

---

## 🥬 Vegetarian & Vegan Scene

Singapore's vegetarian scene has grown significantly, with options from hawker to fine dining.

### Vegetarian-Friendly Cuisines
- **Indian:** Many vegetarian restaurants
- **Chinese Buddhist:** "Zhai" (斋) = vegetarian
- **Modern Western:** Many cafes offer veg options

### Dedicated Vegetarian Hawker Stalls

| Stall | Location | Type |
|-------|----------|------|
| **Whole Earth** | Chin Swee Road | Peranakan-Thai | Bib Gourmand |
| **True Blue Cuisine** | Armenian Street | Peranakan | Bib Gourmand |
| **Original Sin** | Holland Village | Mediterranean-veg |
| **Joie** | Orchard Road | Fine dining vegetarian |

### Indian Vegetarian

| Restaurant | Location | Price |
|------------|----------|-------|
| **Komala Vilas** | Little India | $8-15 |
| **Ananda Bhavan** | Various | $8-15 |
| **Saravana Bhavan** | Various | $10-18 |
| **MTR** | Various | $10-18 |
| **Gayatri** | Little India | $10-20 |

### Buddhist Vegetarian (Mock Meat)

| Restaurant | Notes |
|------------|-------|
| **Loving Hut** | Vegan chain |
| **Real Food** | Health-focused |
| **Sufood** | Chinese vegetarian |
| **Genesis Vegan** | Plant-based |

### Tips for Vegetarians
- Say **"wo chi su"** (我吃素) = "I eat vegetarian" (Mandarin)
- Watch for oyster sauce, fish sauce, shrimp paste in sauces
- Indian and Buddhist restaurants safest options
- Many hawker stalls can make dishes without meat if asked
- Check if eggs/dairy are acceptable (varies)

### Vegan-Specific

| Restaurant | Style |
|------------|-------|
| **Afterglow** | Raw, organic |
| **VeganBurg** | Plant-based burgers |
| **Pollen** | Fine dining, vegan options |
| **Native** | Cocktails + vegan bites |

---

## 🍺 Alcohol Regulations

Alcohol is **legal** in Singapore but regulated and expensive due to high taxes.

### Key Rules

| Rule | Details |
|------|---------|
| **Legal drinking age** | 18 years |
| **Retail sale cutoff** | 10:30 PM – 7:00 AM (no sale at supermarkets, convenience stores) |
| **Public drinking ban** | Prohibited in Liquor Control Zones (Geylang, Little India) after certain hours |
| **At restaurants/bars** | No time restrictions |

### Where You CAN Drink After 10:30pm
- Bars and pubs
- Restaurants with liquor license
- Hotels
- Your home

### Where You CANNOT Drink (Public)
- **Geylang:** No public drinking Sat-Sun 7am (Fri night-Sun morning)
- **Little India:** Similar restrictions
- **Public areas generally:** Discouraged after hours

### Alcohol Prices

| Location | Beer (pint) | Wine (glass) | Cocktail |
|----------|-------------|--------------|----------|
| **Hawker centre** | $8-12 | N/A | N/A |
| **Casual bar** | $10-15 | $12-18 | $16-22 |
| **Rooftop bar** | $15-20 | $18-25 | $25-35 |
| **Speakeasy** | $15-20 | $18-25 | $20-30 |
| **Supermarket** | $5-10/can | $15-40/bottle | N/A |

### Cheapest Alcohol Options
- **Happy hours:** 5-8pm at most bars (30-50% off)
- **Hawker centre coffee shops:** Beer from $8
- **7-Eleven/FairPrice:** Before 10:30pm
- **Wine Connection:** Retail + bar

---

## 💰 Service Charge & GST

### Standard Pricing
Most restaurants add:
- **GST (Goods & Services Tax):** 9% (increased from 8% in 2024)
- **Service charge:** 10%
- **Total markup:** ~20% on menu prices

### How It Appears
- **"$30++"** means $30 + GST + service charge = ~$36
- **"$30 nett"** means $30 all-inclusive

### Where Charges Apply
| Venue Type | GST | Service Charge |
|------------|-----|----------------|
| **Hawker centres** | Included in price | No |
| **Food courts** | Usually included | No |
| **Casual restaurants** | Added (++) | Usually added |
| **Fine dining** | Added (++) | Added |
| **Bars** | Added (++) | Usually added |

---

## 💵 Tipping Culture

### The Simple Rule
**Tipping is NOT expected or necessary in Singapore.**

- Service charge (10%) replaces tips
- Staff receive fair wages
- Leaving extra change is appreciated but not obligatory
- No one will be offended if you don't tip

### When You Might Tip
- Exceptional service at fine dining
- Helpful hotel staff
- Good tour guide
- Usually round up the bill

---

## 📱 Reservation Apps

### Chope (Most Popular)
- **Website:** chope.co
- **App:** iOS/Android
- **Coverage:** 3,000+ restaurants in Singapore
- **Features:** Instant booking, deals, Chope-Dollars rewards
- **Best for:** Most restaurants

### Quandoo
- **Website:** quandoo.sg
- **Coverage:** Mid-range to upscale
- **Features:** Similar to Chope
- **Best for:** Alternative if Chope unavailable

### OpenTable
- **Coverage:** International chains, hotels
- **Best for:** Western fine dining, hotel restaurants

### Direct Booking
Many fine dining restaurants prefer direct contact:
- **Website reservations:** Odette, Zén, Les Amis
- **Phone/WhatsApp:** Japanese omakase, small restaurants

### Walk-In Friendly
- **Hawker centres:** No reservation needed
- **Food courts:** No reservation needed
- **Casual dining:** Usually fine without booking
- **Weekday lunches:** Most places available

### When to Book Ahead
| Restaurant Type | Lead Time |
|-----------------|-----------|
| **3-star Michelin** | 1-2 months |
| **2-star Michelin** | 2-4 weeks |
| **1-star Michelin** | 1-2 weeks |
| **Popular restaurants (Fri/Sat)** | 1 week |
| **Sunday brunch spots** | 1 week |
| **Weekday dinner** | 1-2 days or same day |

---

## 💳 Payment Methods

### Widely Accepted
- **Credit/Debit cards:** Visa, Mastercard (most places)
- **Contactless:** Apple Pay, Google Pay, Samsung Pay
- **PayNow/NETS:** Local payment systems
- **GrabPay:** Widely accepted
- **Cash:** Always works, necessary at hawkers

### Cash-Only Spots
- **Most hawker stalls**
- **Some older kopitiam shops**
- **Wet markets**

### ATM Availability
- Everywhere in malls, MRT stations, 7-Elevens
- DBS/POSB, OCBC, UOB are major banks
- Cirrus/Plus networks supported

---

## 🕐 Meal Timing

### Typical Hours

| Meal | Time | Notes |
|------|------|-------|
| **Breakfast** | 6:00-10:00am | Hawkers open early |
| **Lunch** | 11:30am-2:00pm | Peak hawker times |
| **Tea** | 3:00-5:00pm | Dim sum, snacks |
| **Dinner** | 6:00-9:30pm | Restaurants peak 7-8pm |
| **Supper** | 10:00pm-2:00am | Prata, bak kut teh |

### 24-Hour Options
- **Roti prata shops:** Many open 24/7
- **Geylang:** Food stalls, zi char
- **Mustafa Centre:** Food court (24hr)
- **Some bak kut teh:** Open from 4am
- **Swee Choon dim sum:** Till 6am

### Common Closure Days
- **Monday:** Many hawker stalls closed
- **Chinese New Year:** Many closures (3-5 days)
- **Hari Raya:** Muslim restaurants may close

---

## 📍 Quick Reference

### Emergency Phrases

| English | Mandarin | Malay |
|---------|----------|-------|
| "No pork" | "Bu yao zhu rou" (不要猪肉) | "Tak mahu babi" |
| "No beef" | "Bu yao niu rou" (不要牛肉) | "Tak mahu daging" |
| "Vegetarian" | "Chi su" (吃素) | "Sayur sahaja" |
| "Less spicy" | "Shao la" (少辣) | "Kurang pedas" |
| "More spicy" | "Duo la" (多辣) | "Lebih pedas" |
| "No chili" | "Bu yao la jiao" (不要辣椒) | "Tak mahu cili" |
| "Takeaway" | "Da bao" (打包) | "Tapau/Bungkus" |
| "Eat here" | "Zai zhe li chi" (在这里吃) | "Makan sini" |

### Water & Ice
- **Tap water:** Safe to drink in Singapore
- **Ice:** Safe at all establishments
- **Bottled water:** Available everywhere

### Food Safety
- Singapore has strict food safety standards
- Hawker centres inspected regularly
- A/B/C/D hygiene grades posted at stalls
- **A or B** = excellent; **C** = acceptable; **D** = avoid

### Accessibility
- Most malls have accessible restaurants
- Hawker centres often have ramps
- MRT stations all accessible
- Fine dining generally accommodating

---

## 💡 Top Tips Summary

1. **Hawkers are cash-only** — carry small bills
2. **Tissue packets reserve tables** — respect the system
3. **No tipping required** — service charge included
4. **GST + Service = +20%** — watch for "++" pricing
5. **10:30pm alcohol cutoff** — buy beforehand for home
6. **Monday closures** — many hawkers take day off
7. **Use Chope** — for restaurant reservations
8. **Halal is marked** — look for MUIS certification
9. **Ask for "kurang manis"** — less sweet drinks
10. **Explore beyond Tian Tian** — so much more to discover
