# Singapore Local Cuisine Guide

Singapore's local food reflects its multicultural heritage — Chinese, Malay, Indian, and Peranakan flavors blended over centuries. Here are the essential dishes every visitor must try.

---

## 🍗 Hainanese Chicken Rice

**The national dish of Singapore.** Deceptively simple: poached chicken served with fragrant rice cooked in chicken stock, accompanied by chili sauce, ginger paste, and dark soy sauce.

### What Makes It Great
- **The chicken:** Silky, moist, perfectly poached (never dry)
- **The rice:** Aromatic, slightly oily, infused with chicken fat, garlic, ginger, pandan
- **The sauces:** Fresh chili-garlic-lime dip is essential

### Best Stalls

| Stall | Location | Price | Notes |
|-------|----------|-------|-------|
| **Tian Tian Hainanese Chicken Rice** | Maxwell Food Centre #01-10/11 | $5-7 | Michelin Bib Gourmand, Anthony Bourdain approved |
| **Ah Tai Hainanese Chicken Rice** | Maxwell Food Centre #01-07 | $5-6 | Ex-Tian Tian chef, shorter queue |
| **Margaret Drive Sin Kee Chicken Rice** | Holland Drive Market | $5-6 | Michelin Bib Gourmand, Cantonese style |
| **Boon Tong Kee** | Balestier Road | $6-8 | Michelin Selected, multiple outlets |
| **Ji De Lai Hainanese Chicken Rice** | Chong Pang Market | $4.50-5.50 | Michelin Bib Gourmand |
| **Tiong Bahru Hainanese Boneless Chicken Rice** | Tiong Bahru Market | $5-6 | Michelin Bib Gourmand |

**Price range:** $4-8 per plate

---

## 🍜 Laksa

A spicy coconut curry noodle soup that perfectly embodies Peranakan (Straits Chinese) cuisine. Rich, creamy, aromatic, and fiery.

### Components
- **Broth:** Coconut milk + rempah (spice paste with dried shrimp, chilies, galangal, lemongrass)
- **Noodles:** Thick rice vermicelli (sometimes cut into shorter lengths)
- **Toppings:** Prawns, fish cake, tofu puffs, cockles, hard-boiled egg
- **Garnish:** Laksa leaves, sambal

### Best Laksa Stalls

| Stall | Location | Price | Style |
|-------|----------|-------|-------|
| **328 Katong Laksa** | East Coast Road | $6-8 | Singapore-style, rich coconut, cut noodles (spoon only) |
| **Sungei Road Laksa** | Jalan Berseh | $3-5 | Old-school, legendary |
| **Depot Road Zhen Shan Mei Claypot Laksa** | Depot Road | $5-7 | Claypot style, intense |
| **Old Nyonya** | Maxwell Food Centre #01-04 | $5-7 | Creamy, Peranakan heritage |
| **Janggut Laksa** | Queensway Shopping Centre | $5-6 | Classic |

**Price range:** $4-8 per bowl

---

## 🍳 Char Kway Teow

Stir-fried flat rice noodles with dark soy sauce, lard, egg, Chinese sausage, cockles, bean sprouts, and chives. The key is "wok hei" — the smoky char from high-heat wok cooking.

### The Perfect Char Kway Teow
- Glossy noodles coated in dark sweet soy
- Visible char marks (wok hei)
- Lard cracklings for crunch
- Fresh cockles (blood cockles add umami)
- Slightly wet, never dry

### Best Stalls

| Stall | Location | Price | Notes |
|-------|----------|-------|-------|
| **Outram Park Fried Kway Teow Mee** | Hong Lim Food Centre #02-17 | $5-7 | Michelin Bib Gourmand, since 1950s |
| **No.18 Zion Road Fried Kway Teow** | Zion Riverside Food Centre | $5-6 | Michelin Bib Gourmand |
| **Hai Kee Teochew Cha Kuay Teow** | Telok Blangah Crescent | $5-7 | Legendary, 30+ min wait |
| **Hill Street Fried Kway Teow** | Chinatown Complex #02-198 | $4-5 | Local favorite |
| **Lao Fu Zi Fried Kway Teow** | Old Airport Road | $4-5 | Michelin Bib Gourmand 2025 |

**Price range:** $4-7 per plate

---

## 🍖 Bak Kut Teh (Pork Rib Soup)

A peppery, garlicky pork rib soup beloved for breakfast or supper. The Teochew style (clear, peppery) dominates in Singapore, though Hokkien (herbal, dark) versions exist.

### Accompaniments
- Steamed rice
- You tiao (fried dough fritters) for dipping
- Preserved vegetables
- Dark soy sauce on the side

### Best Stalls

| Restaurant | Location | Price | Notes |
|------------|----------|-------|-------|
| **Song Fa Bak Kut Teh** | New Bridge Road (original) | $10-17 | Michelin Bib Gourmand, Teochew style |
| **Founder Bak Kut Teh** | Rangoon Road | $12-18 | Intense pepper, heritage |
| **Ng Ah Sio Bak Kut Teh** | Rangoon Road | $12-18 | Premium ribs |
| **Joo Siah Bak Koot Teh** | Sims Avenue | $8-12 | Michelin Bib Gourmand 2025 |
| **Sin Heng Claypot Bak Koot Teh** | Mosque Street | $9-14 | Michelin Bib Gourmand 2025 |

**Price range:** $8-20 per person

---

## 🦀 Chilli Crab

**Singapore's signature seafood dish.** Whole mud crabs stir-fried in a sweet, savory, spicy tomato-chili gravy thickened with egg. Messy, magnificent, and unmissable.

### How to Eat It
1. Wear the provided bib
2. Use crackers to break claws
3. Suck out the meat
4. MOP UP THE SAUCE with fried mantou buns (essential!)

### Best Restaurants

| Restaurant | Location | Price (per kg) | Notes |
|------------|----------|----------------|-------|
| **Jumbo Seafood** | East Coast, Riverside Point | $90-120+ | Tourist favorite, sweeter sauce |
| **Long Beach Seafood** | East Coast, UDMC | $88-120+ | Invented black pepper crab |
| **No Signboard Seafood** | Geylang, Esplanade | $80-110+ | Known for white pepper crab |
| **Red House Seafood** | Grand Copthorne | $85-120+ | Premium quality |
| **Palm Beach Seafood** | One Fullerton | $100-150+ | Fine dining atmosphere |
| **Mellben Seafood** | Toa Payoh, Ang Mo Kio | $70-100 | Local favorite, crab bee hoon |

**Price range:** $60-150+ per kg (1 crab typically 600g-1kg, feeds 2-3)

---

## 🍢 Satay

Grilled skewered meat served with peanut sauce, ketupat (rice cakes), cucumber, and onion. Originally Malay/Indonesian, now a Singapore staple.

### Types
- **Chicken satay:** Most common
- **Beef satay:** Popular
- **Mutton satay:** Stronger flavor
- **Pork satay:** At non-halal stalls

### Best Spots

| Location | Notes | Price |
|----------|-------|-------|
| **Lau Pa Sat Satay Street** | Boon Tat Street (outdoor, evenings) | $0.80-1 per stick |
| **Old Airport Road** | Multiple stalls | $0.70-0.90 per stick |
| **East Coast Lagoon Food Village** | By the beach | $0.80-1 per stick |
| **Chomp Chomp Food Centre** | Serangoon | $0.80-1 per stick |

**Price range:** $0.70-1 per stick (minimum order usually 10 sticks)

---

## 🥞 Roti Prata

Indian flatbread, crispy outside, soft inside, served with curry for dipping. A beloved breakfast, lunch, dinner, and supper food.

### Variations
- **Plain prata:** Classic, $1.50-2
- **Egg prata:** With egg, $2-2.50
- **Cheese prata:** $3-4
- **Murtabak:** Stuffed with meat, $6-10
- **Plaster prata:** Egg on top, $2.50-3

### Best Stalls

| Stall | Location | Notes |
|-------|----------|-------|
| **Mr and Mrs Mohgan's** | Joo Chiat | Legendary, crispy, fluffy |
| **Casuarina Curry** | Upper Thomson | Open 24 hours |
| **Sin Ming Roti Prata** | Sin Ming Road | Paper-thin, crispy |
| **Al-Azhar Eating Restaurant** | Bugis | Classic |
| **The Roti Prata House** | Upper Thomson | Popular 24/7 |

**Price range:** $1.50-10

---

## 🍚 Nasi Lemak

Coconut rice with sambal chili, fried anchovies (ikan bilis), peanuts, cucumber, and egg. Originally Malay, now enjoyed by all Singaporeans.

### Additions
- Fried chicken wing: +$2-3
- Otah (fish paste): +$1-2
- Fried fish: +$3-5

### Best Stalls

| Stall | Location | Price | Notes |
|-------|----------|-------|-------|
| **The Coconut Club** | Beach Road | $12-20 | Michelin Bib Gourmand, restaurant setting |
| **Selera Rasa Nasi Lemak** | Adam Road Food Centre | $4-7 | Classic, always queues |
| **Ponggol Nasi Lemak** | Various | $5-8 | 24 hours, solid |
| **Boon Lay Power Nasi Lemak** | Boon Lay | $3.50-6 | Legendary among locals |
| **Kitchenman Nasi Lemak** | Boat Quay | $5-8 | Michelin Bib Gourmand 2025 |

**Price range:** $3-15

---

## 🍞 Kaya Toast

**The quintessential Singapore breakfast.** Toast spread with kaya (coconut-egg jam) and butter, served with soft-boiled eggs and kopi.

### How to Eat It
1. Toast should be crispy
2. Season eggs with white pepper and dark soy sauce
3. Dip toast into egg if desired
4. Wash down with traditional kopi

### Best Spots

| Stall | Location | Price | Notes |
|-------|----------|-------|-------|
| **Ya Kun Kaya Toast** | Various (original at Far East Square) | $5-7 set | Institution since 1944 |
| **Toast Box** | Various (mall chain) | $5-7 set | Consistent quality |
| **Chin Mee Chin Confectionery** | East Coast Road | $4-6 set | Heritage charcoal toast |
| **Heap Seng Leong** | North Bridge Road | $4-5 set | Retro kopitiam, kopi gu you |
| **Killiney Kopitiam** | Killiney Road (original) | $5-7 set | Since 1919 |

**Price range:** $4-8 for toast + eggs + coffee set

---

## 🍜 Other Essential Dishes

### Bak Chor Mee (Minced Pork Noodles)
- **Best:** Hill Street Tai Hwa Pork Noodle (Michelin 1-star, $7-10)
- Thin egg noodles with minced pork, liver, vinegar, chili

### Hokkien Mee
- **Best:** Hong Heng Fried Sotong Prawn Mee (Michelin Bib Gourmand)
- Stir-fried yellow and rice noodles in prawn stock

### Fish Soup (Sliced Fish Bee Hoon)
- **Best:** First Street Teochew Fish Soup (Upper Serangoon)
- Fresh batang fish in clear broth with rice vermicelli

### Carrot Cake (Chai Tow Kway)
- **Best:** Chey Sua Carrot Cake (Michelin Bib Gourmand)
- Fried radish cake with egg, white or black (sweet soy)

### Popiah
- **Best:** Ann Chin Handmade Popiah (Michelin Selected)
- Fresh spring rolls with jicama, egg, sweet sauce

### Rojak
- Sweet, spicy fruit/vegetable salad with shrimp paste

### Chwee Kueh
- Steamed rice cakes topped with preserved radish
- **Best:** Jian Bo Tiong Bahru Shui Kueh (Michelin Bib Gourmand)
