# Singapore International Dining Guide

Singapore's position as a global hub brings world-class international cuisine. From authentic Japanese omakase to regional Chinese specialties, the city rivals any culinary capital.

---

## 🍣 Japanese Cuisine

### Overview
Singapore has one of Asia's strongest Japanese food scenes outside Japan. Japanese restaurants range from hawker stall ramen to Michelin-starred sushi.

### Top Areas for Japanese Food

| Area | What to Find |
|------|--------------|
| **Tanjong Pagar** | Sushi bars, izakayas, ramen |
| **Robertson Quay** | Upscale Japanese, teppanyaki |
| **Orchard Road** | Department store food halls (Takashimaya, Isetan) |
| **Boat Quay** | Mid-range Japanese |

### High-End Japanese (Omakase)

| Restaurant | Cuisine | Price | Michelin |
|------------|---------|-------|----------|
| **Waku Ghin** | Japanese Contemporary | $400-600 | ⭐ 1-star |
| **Sushi Sakuta** | Sushi | $350-500 | ⭐⭐ 2-star |
| **Shoukouwa** | Sushi | $400-500 | ⭐⭐ 2-star |
| **Sushi Ichi** | Sushi | $250-350 | ⭐ 1-star |
| **Hamamoto** | Sushi | $280-380 | ⭐ 1-star |
| **Omakase @ Stevens** | Innovative | $300-400 | ⭐ 1-star (New 2025) |

### Mid-Range Japanese

| Restaurant | Specialty | Price | Location |
|------------|-----------|-------|----------|
| **Nanbantei** | Yakitori | $40-60 | Orchard |
| **Tampopo** | Ramen, donburi | $15-25 | Various |
| **Ippudo** | Tonkotsu ramen | $15-20 | Various |
| **Marukyu** | Soba | $20-35 | Robertson Quay |
| **Shimbashi Soba** | Handmade soba | $15-25 | Paragon |

### Budget Japanese

| Restaurant | Specialty | Price |
|------------|-----------|-------|
| **Genki Sushi** | Conveyor belt sushi | $2-4/plate |
| **Sushi Express** | Conveyor belt | $1.80/plate |
| **Don Don Donki** | Food hall, ready meals | $8-15 |
| **Ichiran** | Tonkotsu ramen | $18-25 |

---

## 🇰🇷 Korean Cuisine

### Top Areas
- **Tanjong Pagar** — "Korea Town," densest concentration of Korean restaurants
- **Bukit Timah** — Korean expat community
- **City Hall/Bugis** — Various options

### Korean BBQ

| Restaurant | Price | Notes |
|------------|-------|-------|
| **Wang Dae Bak** | $40-60pp | Multiple outlets, popular |
| **Chang Korean BBQ** | $35-50pp | Tanjong Pagar |
| **Bornga** | $40-55pp | Quality meat, galbi |
| **I'm Kim Korean BBQ** | $30-45pp | Budget-friendly all-you-can-eat |
| **Guiga Korean BBQ** | $35-50pp | Robertson Quay |

### Korean Restaurants

| Restaurant | Specialty | Price |
|------------|-----------|-------|
| **Nae:um** | Korean Contemporary | $180-250 | ⭐ 1-star |
| **Anju** | Modern Korean | $60-100 |
| **Kimchi Xpress** | Casual Korean | $12-20 |
| **Daejeon Express** | Authentic, no frills | $10-18 |

---

## 🍜 Thai Cuisine

### Authentic Thai

| Restaurant | Style | Price | Notes |
|------------|-------|-------|-------|
| **Yhingthai Palace** | Royal Thai | $40-70 | Michelin Bib Gourmand |
| **MP Thai** | Home-style | $15-25 | Michelin Bib Gourmand |
| **Soi 60** | Bangkok street food | $15-25 | Authentic |
| **Sawadee Thai** | Casual | $10-20 | Various locations |
| **Phed Phed** | Thai Isan | $12-20 | Northeastern Thai |

### Thai Street Food

| Location | What to Find |
|----------|--------------|
| **Golden Mile Complex** | "Little Thailand," authentic & cheap |
| **Sisaket Thai Food** | Maxwell Food Centre, $6-10 |

---

## 🇮🇳 Indian Cuisine

### Little India
The heart of Indian food in Singapore. Tekka Centre and surrounding streets offer the most authentic options.

### Must-Visit in Little India

| Restaurant | Specialty | Price | Notes |
|------------|-----------|-------|-------|
| **Muthu's Curry** | Fish head curry | $30-50 | Michelin Bib Gourmand, iconic |
| **Lagnaa** | Banana leaf | $20-35 | Michelin Bib Gourmand |
| **Bismillah Biryani** | Biryani | $10-18 | Michelin Bib Gourmand |
| **Komala Vilas** | South Indian vegetarian | $8-15 | Heritage |
| **Ananda Bhavan** | South Indian vegetarian | $8-15 | Multiple outlets |

### Tekka Centre (Hawker)

| Stall | Specialty | Price |
|-------|-----------|-------|
| **Allauddin's Biryani** | Chicken/mutton biryani | $6-10 |
| **AR-Rahman** | Prata, murtabak | $2-8 |
| **Azmi Restaurant** | Nasi Briyani | $5-8 |

### North Indian & Fine Dining

| Restaurant | Style | Price |
|------------|-------|-------|
| **Punjab Grill** | North Indian | $60-100 |
| **The Song of India** | Contemporary Indian | $80-150 |
| **Rang Mahal** | Classic North Indian | $70-120 |
| **Yantra** | Regional Indian | $60-100 |

### South Indian

| Restaurant | Notes |
|------------|-------|
| **Saravana Bhavan** | Chennai chain, dosai, idli |
| **MTR** | Bangalore institution |
| **Jaggi's Northern Indian Cuisine** | North meets South |

---

## 🥢 Chinese Regional Cuisine

Singapore's Chinese population hails from various provinces, creating diverse regional options.

### Cantonese

| Restaurant | Specialty | Price | Michelin |
|------------|-----------|-------|----------|
| **Lei Garden** | Dim sum, Cantonese | $50-100 | ⭐ 1-star |
| **Summer Palace** | Traditional Cantonese | $80-150 | ⭐ 1-star |
| **Summer Pavilion** | Cantonese fine dining | $100-200 | ⭐ 1-star |
| **Imperial Treasure Fine Teochew** | Teochew/Cantonese | $80-150 | ⭐ 1-star |
| **Crystal Jade** | Various | $30-60 | Various outlets |

### Sichuan

| Restaurant | Notes | Price |
|------------|-------|-------|
| **Shisen Hanten** | Michelin 1-star, Chen Kenichi's son | $80-150 |
| **Si Chuan Dou Hua** | Sichuan/Cantonese | $50-90 |
| **Birds of a Feather** | Modern Sichuan | $40-70 |

### Teochew

| Restaurant | Specialty |
|------------|-----------|
| **Teochew Lao Er** | Cold crab, braised goose |
| **Chui Huay Lim Teochew Cuisine** | Traditional |
| **Swatow Seafood** | Teochew porridge |

### Beijing/Northern

| Restaurant | Specialty |
|------------|-----------|
| **Imperial Treasure Peking Duck** | Peking duck |
| **Beijing Xiao Wang** | Dumplings, Beijing cuisine |
| **Si Wei Lou** | Northern Chinese |

---

## 🍴 Western Fine Dining

### French

| Restaurant | Price | Michelin | Notes |
|------------|-------|----------|-------|
| **Odette** | $350-500 | ⭐⭐⭐ 3-star | National Gallery |
| **Les Amis** | $350-450 | ⭐⭐⭐ 3-star | Classic French |
| **Jag** | $200-300 | ⭐ 1-star | Modern French |
| **Ma Cuisine** | $150-250 | ⭐ 1-star | French bistro |
| **Lerouy** | $180-280 | ⭐ 1-star | Contemporary |
| **Whitegrass** | $200-300 | ⭐ 1-star | French Contemporary |

### European Contemporary

| Restaurant | Price | Michelin | Notes |
|------------|-------|----------|-------|
| **Zén** | $400-600 | ⭐⭐⭐ 3-star | Swedish fine dining |
| **Cloudstreet** | $280-400 | ⭐⭐ 2-star | Innovative |
| **Meta** | $200-350 | ⭐⭐ 2-star | Korean-European |
| **Jaan by Kirk Westaway** | $250-350 | ⭐⭐ 2-star | British Contemporary |
| **Iggy's** | $200-300 | ⭐ 1-star | Wine-focused |

### Italian

| Restaurant | Price | Michelin | Notes |
|------------|-------|----------|-------|
| **Buona Terra** | $180-280 | ⭐ 1-star | Modern Italian |
| **Fico** | $40-70 | Bib Gourmand | Casual Italian |
| **Cicheti** | $60-100 | — | Venetian |
| **Pasta Bar** | $40-60 | — | Fresh pasta |

### Steakhouse

| Restaurant | Price | Notes |
|------------|-------|-------|
| **CUT** | $200-350 | Michelin 1-star, Wolfgang Puck |
| **Burnt Ends** | $150-250 | Michelin 1-star, barbecue |
| **Morton's** | $150-250 | Classic American |
| **Ruth's Chris** | $120-200 | USDA Prime |

---

## 🌏 Other International

### Mexican
- **Lucha Loco** — Casual tacos, $15-30
- **Super Loco** — Robertson Quay, $25-45

### Middle Eastern
- **Artichoke** — Modern Middle Eastern, $60-100
- **Beirut Grill** — Lebanese, $25-45

### Spanish
- **Catalunya** — Tapas, paella, $60-100
- **FOC** — Modern Spanish, $50-80

### Vietnamese
- **Mrs Pho** — Authentic pho, $10-15
- **Hello Banh Mi** — Maxwell Food Centre, $6-8

### Peruvian
- **Nikkei Nama** — Peruvian-Japanese, $50-80

---

## Key International Food Hubs

| Location | Best For |
|----------|----------|
| **Tanjong Pagar** | Japanese, Korean |
| **Robertson Quay** | European, Japanese |
| **Dempsey Hill** | Western fine dining |
| **Little India (Tekka)** | Indian |
| **Golden Mile Complex** | Thai |
| **Orchard Road** | Department store food halls |
| **Holland Village** | Cafes, Western |
| **Tiong Bahru** | Hipster cafes, brunch |
| **Keong Saik** | Modern Asian, bars |
