# Singapore Fine Dining & Nightlife Guide

Singapore boasts one of Asia's most celebrated fine dining scenes, with 42 Michelin-starred restaurants (2025), world-renowned cocktail bars, and speakeasies that rank among the globe's best.

---

## ⭐ Michelin Guide Singapore 2025

### Summary
- **Total starred restaurants:** 42
- **3-star:** 3 restaurants
- **2-star:** 7 restaurants
- **1-star:** 32 restaurants
- **Bib Gourmand:** 89 eateries
- **Green Star (sustainability):** 2 restaurants

---

## ⭐⭐⭐ Three Michelin Stars
*Exceptional cuisine, worth a special journey*

| Restaurant | Cuisine | Price | Chef |
|------------|---------|-------|------|
| **Les Amis** | French | $350-450 | Sebastien Lepinoy |
| **Odette** | French Contemporary | $350-500 | Julien Royer |
| **Zén** | European Contemporary | $400-600 | Tristin Farmer |

### Les Amis
- **Location:** Shaw Centre, Orchard Road
- **Style:** Classic French fine dining
- **Highlights:** Extensive wine cellar (2,500+ labels), white tablecloth service
- **Reservations:** 2-4 weeks in advance

### Odette
- **Location:** National Gallery Singapore
- **Style:** Modern French with seasonal produce
- **Highlights:** Beautiful gallery setting, artistic plating
- **Reservations:** 4-6 weeks in advance recommended

### Zén
- **Location:** Bukit Pasoh Road
- **Style:** Swedish-influenced European
- **Highlights:** 8-course tasting menu, intimate 24-seat space
- **Reservations:** Often booked 1-2 months ahead

---

## ⭐⭐ Two Michelin Stars
*Excellent cooking, worth a detour*

| Restaurant | Cuisine | Price | Notes |
|------------|---------|-------|-------|
| **Cloudstreet** | Innovative | $280-400 | Amoy Street |
| **Jaan by Kirk Westaway** | British Contemporary | $250-350 | Swissôtel, 70th floor views |
| **Meta** | Innovative (Korean-European) | $200-350 | Keong Saik Road |
| **Saint Pierre** | French Contemporary | $250-350 | One Fullerton |
| **Shoukouwa** | Sushi | $400-500 | Omakase, small counter |
| **Sushi Sakuta** | Sushi | $350-500 | *Promoted 2025*, all-Japanese team |
| **Thevar** | Innovative (Indian) | $150-250 | Keong Saik Road |

---

## ⭐ One Michelin Star (Selected Highlights)

### Innovative/Contemporary

| Restaurant | Cuisine | Price |
|------------|---------|-------|
| **Alma** | European Contemporary | $150-250 |
| **Araya** | Innovative | $180-280 |
| **Born** | Innovative | $200-300 |
| **Chaleur** | Innovative | $180-280 |
| **Esora** | Innovative | $250-350 |
| **Euphoria** | Innovative | $200-300 |
| **Labyrinth** | Innovative (Singaporean) | $180-280 |
| **Nouri** | Innovative | $200-300 |
| **Omakase @ Stevens** | Innovative | $300-400 | *New 2025* |
| **Willow** | Asian Contemporary | $150-250 |

### Japanese

| Restaurant | Price | Notes |
|------------|-------|-------|
| **Hamamoto** | $280-380 | Sushi |
| **Sushi Ichi** | $250-350 | Sushi |
| **Waku Ghin** | $400-600 | Tetsuya Wakuda |

### Chinese

| Restaurant | Cuisine | Price |
|------------|---------|-------|
| **Imperial Treasure Fine Teochew Cuisine** | Teochew | $80-150 |
| **Lei Garden** | Cantonese | $50-100 |
| **Shisen Hanten** | Sichuan | $80-150 |
| **Summer Palace** | Cantonese | $80-150 |
| **Summer Pavilion** | Cantonese | $100-200 |

### Local/Peranakan

| Restaurant | Cuisine | Price |
|------------|---------|-------|
| **Candlenut** | Peranakan | $80-150 |
| **Pangium** | Peranakan | $100-180 |
| **Seroja** | Malaysian | $100-180 | Also Green Star |
| **Hill Street Tai Hwa Pork Noodle** | Street Food | $7-10 |

### Western

| Restaurant | Cuisine | Price |
|------------|---------|-------|
| **Burnt Ends** | Barbecue | $150-250 |
| **CUT** | Steakhouse | $200-350 |
| **Jag** | French Contemporary | $200-300 |
| **Ma Cuisine** | French | $150-250 |
| **Marguerite** | European Contemporary | $180-280 |
| **Whitegrass** | French Contemporary | $200-300 |

---

## 🌿 Green Stars (Sustainability)

| Restaurant | Cuisine | Notes |
|------------|---------|-------|
| **Fiz** | Malaysian | Zero-waste focus |
| **Seroja** | Malaysian | Local sourcing, minimal waste |

---

## 🍺 Michelin Bib Gourmand Highlights

89 eateries recognized for "good quality, good value cooking" (under $45 per person).

### Hawker Stalls

| Stall | Dish | Location |
|-------|------|----------|
| **Tian Tian Hainanese Chicken Rice** | Chicken rice | Maxwell |
| **Outram Park Fried Kway Teow Mee** | Char kway teow | Hong Lim |
| **Lian He Ben Ji Claypot Rice** | Claypot rice | Chinatown Complex |
| **Song Fa Bak Kut Teh** | Bak kut teh | New Bridge Road |
| **Hill Street Tai Hwa Pork Noodle** | Bak chor mee | Crawford Lane |

### Restaurants

| Restaurant | Cuisine |
|------------|---------|
| **The Coconut Club** | Nasi Lemak |
| **Muthu's Curry** | Indian |
| **Kok Sen** | Zi Char |
| **True Blue Cuisine** | Peranakan |
| **The Blue Ginger** | Peranakan |

---

## 🥂 Rooftop Bars

Singapore's skyline demands rooftop drinking. Most open late afternoon.

### Top Rooftop Bars

| Bar | Location | View | Price (cocktails) |
|-----|----------|------|-------------------|
| **CÉ LA VI** | Marina Bay Sands (57F) | Marina Bay, city | $28-35 |
| **Smoke & Mirrors** | National Gallery (6F) | Padang, Marina Bay | $25-32 |
| **Atico** | ION Orchard (56F) | Orchard Road | $25-30 |
| **Lavo** | Marina Bay Sands (57F) | Marina Bay | $28-35 |
| **1-Altitude** | One Raffles Place (63F) | 360° city view | $28-38 |
| **LeVeL33** | Marina Bay (33F) | Marina Bay | $18-25 (craft beer) |
| **Artemis Grill** | CapitaGreen (40F) | CBD | $22-28 |
| **Southbridge** | Boat Quay (5F) | Singapore River | $22-28 |

### Marina Bay Sands Tips
- **CÉ LA VI:** Cover charge ~$25 (redeemable)
- **Dress code:** Smart casual (no flip-flops, shorts)
- **Best time:** Sunset (6-7pm) for views

---

## 🍸 Best Cocktail Bars (2024-2025)

### World-Ranked Bars

| Bar | World Rank 2024 | Asia Rank 2025 | Style |
|-----|-----------------|----------------|-------|
| **Jigger & Pony** | #5 World | #3 Asia | Classic cocktails, Amara Hotel |
| **Nutmeg & Clove** | #24 World | #7 Asia | Singapore-inspired |
| **Sago House** | — | #15 Asia | Intimate, 25-seat |
| **Atlas** | — | — | Art Deco gin palace |
| **Native** | — | — | Foraged, local ingredients |

### Jigger & Pony
- **Location:** Amara Hotel, Tanjong Pagar
- **Known for:** Meticulous classics, "menuzine"
- **Price:** $25-35 per cocktail
- **Reservations:** Recommended

### Atlas
- **Location:** Parkview Square
- **Known for:** 1,300+ gins, Art Deco grandeur
- **Price:** $26-38 per cocktail
- **Must-try:** Gin tower experience

---

## 🔒 Speakeasies & Hidden Bars

Singapore excels at secretive, hard-to-find drinking dens.

### Top Speakeasies

| Bar | Hidden Behind | Style | Price |
|-----|---------------|-------|-------|
| **28 Hong Kong Street** | Unmarked door | Award-winning cocktails | $24-30 |
| **Cat Bite Club** | Behind The Spiffy Dapper | Agave/rice spirits | $22-28 |
| **Horatio** | Shop front | Small, intimate | $20-26 |
| **The Spiffy Dapper** | Barber shop entrance | Classic cocktails | $22-28 |
| **Operation Dagger** | Basement door | Molecular | $28-35 |
| **Mama Diam** | Coffee shop facade | Singaporean themes | $18-24 |
| **Taylor Adam** | Inside Fortune Centre | Quirky | $20-26 |
| **Stay Gold Flamingo** | Pink door | Tiki-inspired | $20-26 |
| **Chandu** | Chinatown | Opium-den aesthetic | $20-26 |

### 28 Hong Kong Street
- **Address:** 28 Hong Kong Street (no sign)
- **Access:** Walk in, ring bell
- **Known for:** Impeccable classics
- **Price:** $24-30

### How to Find Speakeasies
1. Research addresses beforehand
2. Look for unmarked doors or false fronts
3. Ring bells confidently
4. Some require passwords (check social media)
5. Dress smart casual

---

## 🍷 Wine Bars

| Bar | Style | Price (glass) |
|-----|-------|---------------|
| **Wine Connection** | Various | $8-15 |
| **Les Bouchons** | French bistro + wine | $12-25 |
| **Praelum Wine Bistro** | Natural wines | $15-30 |
| **Bottles & Labels** | Wine shop + bar | $12-20 |

---

## 🍺 Craft Beer

| Bar | Notes |
|-----|-------|
| **Smith Street Taps** | Chinatown Complex, hawker + beer |
| **Druggists** | Craft cocktails + beer |
| **Little Island Brewing Co.** | Local brewery |
| **LeVeL33** | Brewery in the sky |
| **Good Luck Beerhouse** | Jalan Besar |

---

## 💡 Fine Dining Tips

### Reservations
- **3-star restaurants:** Book 1-2 months ahead
- **2-star restaurants:** Book 2-4 weeks ahead
- **1-star restaurants:** Book 1-2 weeks ahead
- **Popular bars:** Walk-in possible, but reservations help on weekends

### Booking Platforms
- **Chope** — Most restaurants
- **Quandoo** — Alternative
- **OpenTable** — Some Western restaurants
- **Restaurant websites** — Often required for fine dining

### Dress Code
- **Fine dining:** Smart casual to formal
- **Rooftop bars:** Smart casual (no shorts, flip-flops)
- **Speakeasies:** Smart casual
- **Hawkers:** Anything goes

### Tipping
- **Not expected** in Singapore
- Service charge (10%) usually included
- Extra tip appreciated but not obligatory

### Price Expectations
- **Fine dining tasting menu:** $200-500+ per person
- **Wine pairing:** +$100-200
- **Rooftop cocktails:** $25-35
- **Speakeasy cocktails:** $20-30
