# Singapore Driving & COE System Guide

## Why Driving in Singapore is Different

Singapore is one of the most expensive places in the world to own a car. This is **intentional government policy** to:
- Control traffic congestion
- Manage limited land (roads take space)
- Encourage public transport use
- Reduce emissions
- Fund transport infrastructure

### The Result
- **Only ~12% of households own a car** (vs 90%+ in USA)
- A Toyota Corolla costs ~S$150,000+ (vs ~S$25,000 in USA)
- Most expats and locals don't drive
- Excellent public transport alternatives exist

---

## Certificate of Entitlement (COE) Explained

### What is COE?
A **Certificate of Entitlement** is essentially a license to own and operate a vehicle in Singapore for **10 years**. It's obtained through a bidding system.

### How the System Works

1. **Government sets quota** (Vehicle Quota System)
   - Based on deregistrations + allowed growth
   - Since Feb 2018: 0% growth for cars/motorcycles
   
2. **Bidding twice monthly**
   - First and third Monday of each month
   - Sealed-bid, uniform price auction
   - All winners pay the lowest successful bid

3. **After 10 years**
   - Renew COE at prevailing rate (5 or 10 years)
   - OR deregister/scrap/export the vehicle
   - 5-year renewal cannot be further renewed

### COE Categories

| Category | Vehicle Type | Recent Prices (Oct 2025) |
|----------|--------------|-------------------------|
| **Cat A** | Cars ≤1,600cc and ≤97kW (130bhp) | ~S$100,000-128,000 |
| **Cat B** | Cars >1,600cc or >97kW | ~S$140,000-150,000 |
| **Cat C** | Goods vehicles & buses | ~S$80,000-91,000 |
| **Cat D** | Motorcycles | ~S$10,000-13,000 |
| **Cat E** | Open (any vehicle except motorcycles) | ~S$150,000-158,000 |

### Historical COE Prices

| Year | Cat A | Cat B |
|------|-------|-------|
| 2008 (crisis low) | S$2 | S$200 |
| 2013 | S$92,000 | S$95,000 |
| 2019 | S$35,000 | S$40,000 |
| 2023 | S$106,000 | S$150,001 (record) |
| 2025 | S$100,000-128,000 | S$140,000-150,000 |

**Key insight**: COE prices are driven by supply (government quota) and demand (people wanting cars). They swing wildly.

---

## True Cost of Car Ownership

### Buying a New Car: Cost Breakdown

Using example of a **Toyota Corolla 1.6L** (Cat A):

| Component | Cost |
|-----------|------|
| **Open Market Value (OMV)** | S$25,000 |
| **Additional Registration Fee (ARF)** | S$25,000 (100% of OMV) |
| **COE** | S$100,000+ |
| **Excise duty + GST** | S$8,000 |
| **Registration fee** | S$220 |
| **Road tax (first year)** | S$800 |
| **Total purchase price** | ~S$160,000+ |

**A "cheap" economy car in Singapore costs more than a luxury car elsewhere.**

### Luxury/Premium Cars

| Car (new) | Approx. Price in SG |
|-----------|---------------------|
| Toyota Corolla | S$150,000-170,000 |
| Honda Civic | S$170,000-200,000 |
| BMW 3 Series | S$250,000-350,000 |
| Mercedes C-Class | S$250,000-350,000 |
| BMW 5 Series | S$350,000-500,000 |
| Mercedes S-Class | S$500,000-700,000 |
| Porsche 911 | S$600,000-1,000,000+ |

### Monthly Running Costs

| Item | Monthly Cost |
|------|--------------|
| **Car loan repayment** | S$1,500-3,000 |
| **Insurance** | S$150-400 |
| **Road tax** | S$50-200 |
| **Petrol** | S$200-400 |
| **Parking (condo)** | S$100-300 |
| **Parking (office)** | S$200-500 |
| **ERP (Electronic Road Pricing)** | S$50-200 |
| **Maintenance** | S$100-300 |
| **Total** | **S$2,500-5,000+** |

### 10-Year Total Cost of Ownership

For a mid-range car (S$180,000 purchase):
- Purchase: S$180,000
- Running costs (10 years): S$300,000-500,000
- **Total**: S$480,000-680,000

**That's S$4,000-5,700/month for 10 years**

---

## Electronic Road Pricing (ERP)

### What is ERP?
- Congestion pricing system
- Gantries charge vehicles during peak hours
- Rates vary by location, time, vehicle type
- In-vehicle unit (IU) required

### ERP Rates
- Range: S$0.50 - S$6.00 per gantry
- Peak hours: 7:30-9:30 AM, 5:30-8:00 PM
- Major expressways and CBD have most gantries
- Off-peak: often S$0 or minimal charges

### Coming Soon: ERP 2.0
- Satellite-based (no gantries)
- Distance-based charging
- More flexible pricing
- Rollout delayed multiple times

---

## Other Taxes and Fees

### Road Tax (Annual)
Based on engine capacity:
| Engine Size | Annual Road Tax |
|-------------|-----------------|
| 600cc | S$374 |
| 1,000cc | S$578 |
| 1,600cc | S$782 |
| 2,000cc | S$1,442 |
| 3,000cc | S$2,674 |

Electric vehicles have different calculation based on power output.

### Additional Registration Fee (ARF)
Progressive tax based on OMV:
| OMV Range | ARF Rate |
|-----------|----------|
| First S$20,000 | 100% |
| S$20,001-50,000 | 140% |
| Above S$50,000 | 180% |

### PARF (Preferential ARF) Rebate
- Rebate received when deregistering car before 10 years
- Incentive to scrap/export early
- Declines by 25% every 2 years

---

## Alternatives to Owning

### Public Transport

**MRT (Mass Rapid Transit)**
- 6 lines, 140+ stations
- Operating hours: 5:30 AM - midnight
- Cost: S$0.90-2.40 per trip
- Frequency: 2-5 minutes peak, 5-10 minutes off-peak

**Buses**
- Comprehensive network
- Similar pricing to MRT
- Less predictable timing

**Monthly Transport Costs**
- MRT/Bus commuter: S$80-150/month
- Compare to: S$2,500-5,000/month car ownership

### Ride-Hailing

| Service | Base Fare | Per KM | Notes |
|---------|-----------|--------|-------|
| **Grab** | S$2.50-4.00 | S$0.50-0.80 | Market leader |
| **Gojek** | S$2.30-3.50 | S$0.45-0.75 | Often cheaper |
| **TADA** | S$2.20-3.00 | S$0.40-0.70 | Commission-free |
| **Comfort/CityCab** | S$3.90+ | S$0.65-0.75 | Traditional taxis |

**Typical rides:**
- Airport to CBD: S$25-45
- Cross-island: S$20-35
- Within district: S$8-15

### Car Sharing

| Service | Type | Cost |
|---------|------|------|
| **BlueSG** | Electric car sharing | S$0.50/min (driving) + S$0.25/min (parking) |
| **GetGo** | Per-minute/hourly | S$0.33/min or from S$7/hour |
| **Tribecar** | Hourly/daily | From S$4.80/hour |
| **Drive lah** | Peer-to-peer | Varies |

**Weekend car sharing**: S$80-150/day (full day rental)

### Car Rental

For occasional use:
| Duration | Cost Range |
|----------|------------|
| Daily | S$100-200 |
| Weekly | S$500-1,000 |
| Monthly | S$1,500-3,000 |

---

## When Car Ownership Makes Sense

### Good Candidates for Car Ownership

✅ **High earners** (S$300K+ annual) where cost is trivial
✅ **Multiple kids** with different school drop-offs
✅ **Elderly care** with frequent medical appointments
✅ **Sales/client-facing roles** requiring frequent visits
✅ **Living in areas** poorly served by MRT
✅ **Hobbies requiring transport** (golf, diving, etc.)
✅ **Expats with car in package** (employer pays)

### Better Without a Car

❌ Most CBD workers (MRT is faster)
❌ Small family in central location
❌ Those who WFH frequently
❌ Cost-conscious individuals
❌ Environmental priorities
❌ Short-term stays (< 3 years)

---

## Off-Peak Car Scheme

### What is OPC?
- Reduced COE rebate for cars that:
  - Cannot drive during peak hours (7-9:30 AM on weekdays)
  - Must display OPC decal
  - Can pay for day license to use during peak (S$20/day)

### Savings
- ~S$17,000 rebate on COE
- Best for retirees, those who don't commute

### Weekend Car (Discontinued)
- Historical scheme that allowed driving only weekends/holidays
- No longer offered for new registrations

---

## Electric Vehicles (EVs) in Singapore

### Government Push
- Target: All new vehicles electric by 2030
- EV Early Adoption Incentive (EEAI): Up to S$45,000 rebate

### EV Considerations

**Pros:**
- ARF rebate for EVs
- Lower running costs (electricity cheaper than petrol)
- Road tax benefits
- Growing charging network

**Cons:**
- Still need COE (same high prices)
- Charging infrastructure still developing
- Higher upfront cost for vehicles
- Range anxiety (though Singapore is small)

### Popular EVs in Singapore
| Model | Price Range |
|-------|-------------|
| Tesla Model 3 | S$120,000-180,000 |
| Tesla Model Y | S$150,000-200,000 |
| BYD Atto 3 | S$150,000-170,000 |
| Hyundai Ioniq 6 | S$200,000-250,000 |
| BMW iX3 | S$300,000+ |

---

## Practical Tips

### If You Must Drive

1. **Buy used** - 3-5 year old cars with COE remaining
2. **Cat A car** - Lower COE than Cat B
3. **Off-peak scheme** - If you don't commute
4. **Japanese reliability** - Toyota, Honda for lower maintenance
5. **EV incentives** - Check current rebates
6. **Time your purchase** - COE prices fluctuate

### Maximum Savings: No Car

Comparison over 10 years:

| Transport Method | 10-Year Cost |
|------------------|--------------|
| Car ownership | S$500,000-700,000 |
| Grab/taxi heavy use | S$72,000-120,000 |
| Public transport + occasional Grab | S$36,000-60,000 |
| Public transport only | S$15,000-25,000 |

**Savings without car: S$400,000-600,000+**

That's enough for:
- Private education for 2 kids
- Retirement fund boost
- Investment portfolio
- Regular business class travel

---

## For New Arrivals: Recommendations

### Short-Term Expats (< 3 years)
- **Don't buy a car**
- Use MRT, Grab, occasional rental
- Employer car benefit? Great, but negotiate cash equivalent if possible

### Long-Term Expats (3+ years)
- **Still probably don't need a car**
- Consider car sharing for weekends
- Buy only if lifestyle genuinely requires it

### Families with Kids
- **MRT + Grab usually sufficient**
- School buses available at international schools
- Domestic helper can manage kids' transport
- Rent car for weekend activities if needed

### If You Must Buy
1. Wait 3-6 months to understand your needs
2. Buy used (2-4 years old)
3. Cat A vehicle
4. Factor in ALL costs before deciding
5. Be prepared to sell before COE expires

---

## Summary: The Singapore Car Reality

| Factor | Rating for Car Ownership |
|--------|-------------------------|
| Cost | ⭐ (extremely expensive) |
| Necessity | ⭐⭐ (rarely needed) |
| Convenience | ⭐⭐⭐⭐ (if you can afford it) |
| Alternatives | ⭐⭐⭐⭐⭐ (excellent) |
| Status symbol | ⭐⭐⭐⭐ (cars still impress) |

### Final Verdict
For most people in Singapore, car ownership is a **luxury, not a necessity**. The money saved can fund:
- Better housing
- Premium education
- Investment returns
- Retirement security
- Regular travel

Unless you have specific needs that genuinely require a car, **embrace public transport and ride-hailing**. You'll be wealthier and only slightly less convenient.

---

## Quick Reference: Transport Options

| Need | Best Option |
|------|-------------|
| Daily commute | MRT + Bus |
| Night out | Grab/Taxi |
| Airport | Grab or MRT (direct lines) |
| Weekend beach trip | Car share or Grab |
| Grocery run | Walk, bus, or delivery |
| Kids' activities | Arrange with helper, Grab |
| Urgent travel | Grab Premium or Taxi |
| Regional trip (JB) | Rent car for the day |
