# Singapore Culture Guide

## Overview: A Multiracial Society

Singapore is one of the world's most successful multiracial societies, with a carefully maintained ethnic balance that shapes every aspect of daily life.

### Ethnic Composition (2024-2025)
| Ethnicity | Percentage | Main Languages |
|-----------|------------|----------------|
| Chinese | ~74% | Mandarin, Hokkien, Cantonese, Teochew |
| Malay | ~13% | Malay (Bahasa Melayu) |
| Indian | ~9% | Tamil, Hindi, Malayalam, Punjabi |
| Others | ~4% | Various (Eurasian, Filipino, etc.) |

### Government Policy on Racial Harmony
- **Ethnic Integration Policy (EIP)**: HDB estates have quotas for each ethnic group to prevent ethnic enclaves
- **Racial Harmony Day** (July 21): Schools celebrate with cultural dress and performances
- All four official languages (English, Mandarin, Malay, Tamil) are represented on signage
- National anthem sung in Malay (the "national language") regardless of ethnicity

---

## Singlish: The Unofficial National Language

While English is the official language of business, Singlish is what Singaporeans actually speak in daily life.

### What is Singlish?
An English-based creole mixing:
- English (base language)
- Hokkien/Teochew (Chinese dialects)
- Malay
- Tamil
- Mandarin

### Essential Singlish Vocabulary

| Word/Phrase | Meaning | Origin | Example |
|-------------|---------|--------|---------|
| **Lah** | Emphasis particle | Hokkien | "No problem lah!" |
| **Lor** | Resigned acceptance | Hokkien | "Like that lor" (It is what it is) |
| **Leh** | Softening/questioning | Hokkien | "You sure or not leh?" |
| **Meh** | Doubt/disbelief | Cantonese | "Like that also can meh?" |
| **Shiok** | Great/awesome | Malay | "This food damn shiok!" |
| **Kiasu** | Fear of losing out | Hokkien | "So kiasu, queue 2 hours for free gift" |
| **Kiasi** | Fear of death/overly cautious | Hokkien | "Don't be so kiasi lah" |
| **Sabo** | Sabotage | Malay | "Don't sabo me!" |
| **Chope** | Reserve (with tissue packets) | Unknown | "I chope the table already" |
| **Paiseh** | Embarrassed/shy | Hokkien | "Paiseh to ask for help" |
| **Can** | Yes/okay | English | "Can lah, no problem" |
| **Atas** | High-class/pretentious | Malay | "This restaurant very atas" |
| **Blur** | Confused/clueless | English | "Sorry, I very blur today" |
| **Alamak** | Oh no!/Oh dear! | Malay | "Alamak, I forgot!" |
| **Bojio** | Didn't invite | Hokkien | "Bojio! You all go without me" |

### Singlish Sentence Structure Examples

**Standard English:** "Why didn't you tell me about this earlier?"
**Singlish:** "Why you never tell me earlier ah?"

**Standard English:** "This is unbelievable!"
**Singlish:** "Wah, like that also can ah!"

**Standard English:** "That's too expensive"
**Singlish:** "So ex! Don't want lah"

### Government Stance on Singlish
- **Speak Good English Movement** (since 2000): Government campaign to promote Standard English
- Singlish officially discouraged in media and schools
- In practice: widely embraced as national identity; Oxford English Dictionary added 19 Singlish words in 2016

---

## Kiasu Culture

### Understanding Kiasu
From Hokkien "kiaⁿ-su" (驚輸) meaning "fear of losing"

**Definition:** A competitive attitude driven by fear of missing out or being left behind

### How Kiasu Manifests in Singapore

| Context | Kiasu Behavior | Why It Happens |
|---------|----------------|----------------|
| **Education** | Tuition from age 3, stacking multiple enrichment classes | Fear child will fall behind peers |
| **Sales/Promotions** | Queuing hours for free gifts or discounts | Cannot miss "good deal" |
| **Food** | Arriving early to hawker centers, "choping" tables | Best dishes sell out |
| **Buffets** | Piling plates high immediately | Must maximize value |
| **Jobs** | Collecting degrees/certifications | Need more qualifications than competitors |
| **Property** | Rushing to buy during cooling measures | Fear prices will rise more |

### Positive vs Negative Kiasu

**Kiasu-Positive:**
- Hardworking, prepared, diligent
- Drives Singapore's economic success
- Early adopters of efficiency measures

**Kiasu-Negative:**
- Selfish, hoarding behaviors
- Creating unnecessary competition
- Stress and anxiety in society

### The "Tissue Packet" Culture
Singaporeans famously reserve tables at food courts using tissue packets. This is so normalized that leaving items is considered culturally acceptable reservation.

---

## National Holidays (2025-2026)

Singapore has 11 gazetted public holidays reflecting its multiracial society:

| Holiday | 2025 Date | 2026 Date | Significance |
|---------|-----------|-----------|--------------|
| **New Year's Day** | Jan 1 | Jan 1 | Gregorian new year |
| **Chinese New Year** | Jan 29-30 | Feb 17-18 | Lunar new year (2 days) |
| **Good Friday** | Apr 18 | Apr 3 | Christian |
| **Labour Day** | May 1 | May 1 | Workers' rights |
| **Vesak Day** | May 12 | May 31 | Buddha's birth/enlightenment |
| **Hari Raya Puasa** | Mar 31 | Mar 21 | End of Ramadan |
| **Hari Raya Haji** | Jun 7 | May 27 | Festival of Sacrifice |
| **National Day** | Aug 9 | Aug 9 | Independence (1965) |
| **Deepavali** | Oct 20 | Nov 8 | Hindu festival of lights |
| **Christmas** | Dec 25 | Dec 25 | Christian |

### Holiday Culture Tips

**Chinese New Year (CNY):**
- Most significant holiday for 74% of population
- Many businesses close for 2+ days
- Give red packets (ang bao) with even-numbered amounts
- Avoid black/white clothing
- Exchange of mandarin oranges

**Hari Raya Puasa:**
- End of Ramadan fasting month
- Open house culture: visiting friends/relatives
- Geylang Serai bazaar runs for weeks before

**Deepavali:**
- Little India comes alive with lights
- Shop for traditional clothing and sweets

---

## Work-Life Balance Reality

### The Honest Picture

**Working Hours:**
- Official: 44 hours/week
- Reality: 47-50+ hours common in corporate jobs
- Singapore ranked among most overworked countries globally
- "Face time" culture: leaving on time can be seen negatively

**Commute:**
- Average: 45-60 minutes each way
- MRT system is efficient but crowded during peak hours (7:30-9:30 AM, 5:30-8 PM)

### Statistics (2024-2025)
- Average weekly working hours: ~45 hours
- Only 40% of employees say they have good work-life balance
- Annual leave: 14-21 days (increases with seniority)
- Sick leave: 14 days outpatient, 60 days hospitalization

### Corporate Culture
- Hierarchical: respect for seniority
- Meetings often run over; punctuality expected for start, not end
- Email after hours is normal
- Flexibility improving post-COVID but varies by company

### Tips for Maintaining Balance
1. **Set boundaries early** - establish expectations in first months
2. **Use your leave** - it's earned, and unused leave culture is changing
3. **Find expat communities** - shared understanding of challenges
4. **Embrace efficiency** - lunch near office, use delivery apps
5. **Weekend planning** - Singapore has plenty of activities despite small size

---

## Social Norms and Etiquette

### Business Settings
- Exchange business cards with both hands, study the card respectfully
- Senior person speaks first
- Indirect communication preferred; reading between the lines matters
- "Face" is important: avoid public criticism

### Daily Life
- Queue for everything (MRT, food, ATMs)
- Don't eat or drink on MRT (S$500 fine)
- Give up reserved seats for elderly/pregnant/disabled
- Holding doors, escalator etiquette (stand left, walk right)

### Dining Etiquette
- Host typically pays entire bill (no splitting)
- Wait for eldest to start eating
- Leave some food on plate (shows host provided abundance)
- Chopsticks: never point, never stick upright in rice (resembles funeral incense)

### What NOT to Do
- **Chewing gum**: Import banned, sale prohibited (S$100,000 fine for dealers)
- **Littering**: S$300-1,000 fine
- **Jaywalking**: S$50 fine (within 50m of crossing)
- **Vandalism**: Caning possible
- **Drugs**: Death penalty for trafficking

### Religion and Respect
- Don't touch someone's head (sacred in some cultures)
- Remove shoes when entering homes or temples
- Dress modestly at religious sites
- Friday prayers: expect some Muslim colleagues unavailable 12-2pm

---

## Cultural Events Calendar

| Month | Event | Description |
|-------|-------|-------------|
| Jan/Feb | Chinese New Year | River Hongbao, Chingay Parade |
| Feb | Thaipusam | Hindu festival at Sri Thendayuthapani Temple |
| Mar/Apr | Hari Raya Puasa | Geylang Serai lights up |
| May | Vesak Day | Processions at Buddhist temples |
| Jul | Singapore Food Festival | Month-long culinary celebration |
| Aug | National Day | Major parade, fireworks at Marina Bay |
| Sep | Mid-Autumn Festival | Mooncakes, Gardens by the Bay displays |
| Oct/Nov | Deepavali | Little India illuminated |
| Dec | Christmas | Orchard Road light-up |

---

## Practical Cultural Tips for Expats

### Making Friends
1. **Join interest groups**: Running clubs, photography groups, etc.
2. **Food is bonding**: Sharing hawker food breaks barriers
3. **Be patient**: Singaporeans can be reserved initially but warm up
4. **Learn some Singlish**: Shows effort and brings smiles
5. **Don't criticize Singapore publicly**: Sensitive topic for locals

### Understanding Complaints
Singaporeans are known for complaining (called "kpkb" - Hokkien for incessant complaints) but:
- It's a bonding activity
- Doesn't mean they want to leave
- Topics: weather (hot), prices (expensive), government (everything)

### The Expat Bubble Warning
- Easy to stay in expat circles
- Miss out on authentic Singapore experience
- Make effort to befriend locals
- Try local food beyond hawker center "safe" options

---

## Summary: Cultural Integration Tips

1. **Learn key Singlish phrases** - instant rapport builder
2. **Embrace the food culture** - it's the social glue
3. **Respect the rules** - they're strictly enforced
4. **Understand kiasu** - it's not personal, it's cultural
5. **Appreciate multiracialism** - Singapore's greatest achievement
6. **Adjust work expectations** - long hours are normal
7. **Participate in holidays** - attend open houses, buy mooncakes
8. **Be patient with integration** - it takes time but rewards effort
