# Singapore Cost of Living Guide 2024-2026
## Detailed Breakdown with City Comparisons

---

## 1. Overview

Singapore consistently ranks as one of the world's most expensive cities, BUT this is largely driven by:
- **Cars** (5-10x more expensive than elsewhere)
- **Alcohol** (heavily taxed)
- **International schools** (for expat families)

For daily essentials, Singapore can be very affordable if you adapt to local lifestyle.

---

## 2. Housing (The Biggest Expense)

### Rental Prices (February 2026)

#### HDB (Public Housing)
| Unit Type | Location | Monthly Rent |
|-----------|----------|--------------|
| Room (common) | Anywhere | S$800-1,200 |
| Room (master) | Anywhere | S$1,000-1,500 |
| 2-room flat | Outskirts | S$1,500-2,000 |
| 3-room flat | Central | S$2,500-3,500 |
| 3-room flat | Outskirts | S$2,000-2,800 |
| 4-room flat | Central | S$3,000-4,000 |
| 4-room flat | Outskirts | S$2,500-3,500 |
| 5-room flat | Anywhere | S$3,000-4,500 |

#### Private Condominiums
| Unit Type | Location | Monthly Rent |
|-----------|----------|--------------|
| Studio | City fringe | S$2,500-3,500 |
| 1-bedroom | CBD/Orchard | S$3,500-5,000 |
| 1-bedroom | Outside central | S$2,600-3,500 |
| 2-bedroom | CBD/Orchard | S$5,000-7,500 |
| 2-bedroom | Outside central | S$3,500-5,000 |
| 3-bedroom | CBD/Orchard | S$7,000-10,000 |
| 3-bedroom | Outside central | S$4,500-6,500 |

#### Landed Property
| Type | Monthly Rent |
|------|--------------|
| Terrace house | S$8,000-15,000 |
| Semi-detached | S$12,000-25,000 |
| Bungalow | S$20,000-50,000+ |
| Good Class Bungalow | S$50,000-100,000+ |

### Additional Housing Costs
- **Security deposit:** 2 months' rent (refundable)
- **Agent fee:** 1 month's rent (2-year lease)
- **Stamp duty:** ~0.4% of total rent
- **Maintenance fee:** Usually included in condo
- **Utilities:** S$100-300/month

---

## 3. Utilities

### Monthly Utility Costs (85m² apartment)

| Utility | With AC | Without AC |
|---------|---------|------------|
| Electricity | S$150-250 | S$80-120 |
| Water | S$30-50 | S$30-50 |
| Gas | S$20-40 | S$20-40 |
| **Total** | **S$200-350** | **S$130-210** |

### Internet & Phone
| Service | Monthly Cost |
|---------|--------------|
| Fibre broadband (1Gbps) | S$35-50 |
| Mobile (postpaid, 50-100GB) | S$20-40 |
| Mobile (SIM-only budget) | S$10-20 |

---

## 4. Food

### Eating Options

#### Hawker Centres (Local Food Courts)
The most affordable and uniquely Singaporean way to eat:

| Meal | Price |
|------|-------|
| Chicken rice | S$4-6 |
| Nasi lemak | S$4-6 |
| Laksa | S$5-7 |
| Char kway teow | S$4-6 |
| Roti prata + curry | S$3-5 |
| Drink (kopi/teh) | S$1.50-2.50 |
| **Full meal** | **S$5-8** |

#### Food Courts (Air-conditioned)
| Meal | Price |
|------|-------|
| Asian dishes | S$7-12 |
| Western food | S$10-15 |

#### Casual Dining
| Type | Price per person |
|------|------------------|
| Fast food (McDonald's, KFC) | S$8-12 |
| Cafe lunch | S$15-25 |
| Casual restaurant | S$20-35 |

#### Mid-Range Restaurant
| Meal | Price |
|------|-------|
| Main course | S$25-45 |
| Meal with drinks | S$40-70 |
| Two people, 3 courses | S$90-150 |

#### Fine Dining
| Experience | Price per person |
|------------|------------------|
| Good restaurant | S$100-200 |
| Michelin-starred | S$200-500 |
| Omakase | S$200-400 |

### Groceries (Monthly Budget)

#### Budget Shopping (FairPrice, Sheng Siong)
| Item | Price |
|------|-------|
| Rice (5 kg) | S$12-18 |
| Eggs (30) | S$5-8 |
| Chicken breast (1 kg) | S$8-12 |
| Milk (1 L) | S$3-5 |
| Bread (loaf) | S$2-4 |
| Vegetables (per day) | S$3-5 |
| Fruits (per day) | S$3-5 |

**Monthly grocery budget:**
- Single person: S$300-500
- Couple: S$500-800
- Family (4): S$800-1,200

#### Premium Shopping (Cold Storage, Market Place)
Add 30-50% to above prices

### Alcohol (Expensive!)
Singapore heavily taxes alcohol:

| Drink | Hawker/Kopitiam | Bar/Club |
|-------|-----------------|----------|
| Local beer (330ml) | S$6-8 | S$12-18 |
| Craft beer | S$10-14 | S$18-25 |
| Wine (glass) | N/A | S$15-25 |
| Cocktail | N/A | S$20-30 |

**Supermarket prices:**
- Beer (6-pack) | S$18-25
- Wine (bottle) | S$20-50
- Spirits (bottle) | S$60-120

---

## 5. Transport

### Public Transport (Monthly)
| Usage | Cost |
|-------|------|
| Light user (WFH) | S$50-80 |
| Daily commuter | S$80-130 |
| Heavy user | S$130-180 |

### Grab/Taxi (Monthly)
| Usage | Cost |
|-------|------|
| Occasional (4-8 trips) | S$80-150 |
| Regular (12-16 trips) | S$200-350 |
| Frequent | S$400-700 |

### Car Ownership (See transport guide for details)
| Expense | Monthly |
|---------|---------|
| Total car ownership | S$1,500-3,000 |

---

## 6. Healthcare

### Public Healthcare
Singapore Citizens and PRs get heavy subsidies. Foreigners pay more but still reasonable:

| Service | Cost (Foreigner) |
|---------|------------------|
| Polyclinic visit | S$50-80 |
| GP visit | S$30-60 |
| Specialist (public) | S$100-200 |
| Emergency (A&E) | S$150-300 |

### Private Healthcare
| Service | Cost |
|---------|------|
| GP visit | S$50-100 |
| Specialist | S$150-400 |
| Full health screening | S$500-2,000 |

### Health Insurance
Most EP holders must have insurance. Typical costs:

| Coverage | Annual Premium |
|----------|----------------|
| Basic (hospitalization) | S$500-1,500 |
| Comprehensive | S$1,500-3,500 |
| Premium (private hospitals) | S$3,000-6,000 |

### Dental
| Service | Cost |
|---------|------|
| Checkup + cleaning | S$80-150 |
| Filling | S$80-200 |
| Extraction | S$100-300 |
| Root canal | S$500-1,500 |

---

## 7. Education

### Public Schools (Citizens/PRs only)
| Level | Monthly Fee (PR) |
|-------|------------------|
| Primary | S$230 |
| Secondary | S$440 |
| Junior College | S$560 |

### International Schools (Foreigners)
| School Type | Annual Fee |
|-------------|------------|
| International (average) | S$25,000-45,000 |
| Top-tier (UWC, SAS, TTS) | S$40,000-55,000 |
| Premium (Dulwich, ISS) | S$35,000-50,000 |

Additional costs:
- Registration fee: S$2,000-5,000
- Building fund: S$3,000-10,000
- Bus: S$200-400/month

### Childcare
| Type | Monthly |
|------|---------|
| Government childcare (citizen) | S$300-700 |
| Private childcare | S$1,200-2,500 |
| Premium infant care | S$2,000-3,500 |

---

## 8. Entertainment & Lifestyle

### Activities
| Activity | Cost |
|----------|------|
| Cinema | S$12-18 |
| Cinema (premium, IMAX) | S$20-30 |
| Gym membership | S$100-200/month |
| Yoga class (drop-in) | S$25-40 |
| Swimming (public) | S$2-3 |
| Golf (public) | S$50-100/round |
| Golf (private club) | S$200-400/round |

### Domestic Help
Common for families:

| Helper | Monthly |
|--------|---------|
| Full-time live-in helper | S$600-800 (salary) |
| + levy | S$300 |
| + food/lodging | S$300-500 |
| **Total cost** | **S$1,200-1,600** |

Part-time cleaner: S$20-35/hour

---

## 9. Monthly Budget Examples

### Single Professional (comfortable)
| Category | Monthly S$ |
|----------|------------|
| Rent (room in condo) | 2,000 |
| Utilities (share) | 100 |
| Food (mix hawker/restaurant) | 800 |
| Transport | 150 |
| Phone + internet | 60 |
| Entertainment | 300 |
| Gym | 120 |
| Personal care | 150 |
| **Total** | **3,680** |

### Single Professional (budget)
| Category | Monthly S$ |
|----------|------------|
| Rent (HDB room) | 1,000 |
| Utilities (share) | 80 |
| Food (mostly hawker) | 500 |
| Transport | 100 |
| Phone | 30 |
| Entertainment | 150 |
| **Total** | **1,860** |

### Couple (no kids, comfortable)
| Category | Monthly S$ |
|----------|------------|
| Rent (2-bed condo) | 4,500 |
| Utilities | 250 |
| Food | 1,500 |
| Transport | 250 |
| Phone + internet | 100 |
| Entertainment | 500 |
| Gym (2 people) | 200 |
| Personal | 400 |
| **Total** | **7,700** |

### Family with 2 Kids (International School)
| Category | Monthly S$ |
|----------|------------|
| Rent (3-bed condo) | 6,500 |
| Utilities | 350 |
| Food | 2,500 |
| Transport | 400 |
| Helper | 1,400 |
| School fees (2 kids) | 6,000 |
| Healthcare/insurance | 500 |
| Entertainment | 600 |
| Kids activities | 500 |
| **Total** | **18,750** |

---

## 10. City Comparisons (February 2026)

### Singapore vs London

| Category | Singapore | London | Difference |
|----------|-----------|--------|------------|
| 1-bed (city centre) | S$3,509 | S$3,997 | -12% |
| 1-bed (outside centre) | S$2,614 | S$2,966 | -12% |
| Meal (cheap restaurant) | S$12.33 | S$34.21 | -64% |
| McDonald's meal | S$10.00 | S$14.54 | -31% |
| Monthly transport pass | S$128 | S$308 | -58% |
| Utilities (85m²) | S$204 | S$491 | -58% |
| Cappuccino | S$6.07 | S$6.79 | -11% |
| Gym membership | S$141 | S$96 | +47% |
| Taxi (per km) | S$1.00 | S$4.25 | -76% |
| New car (Toyota Corolla) | S$170,000 | S$52,000 | +227% |

**Summary:** Singapore is MUCH cheaper for food, transport, and dining out. Rent is similar. Cars are absurdly expensive.

### Singapore vs New York City

| Category | Singapore | NYC | Difference |
|----------|-----------|-----|------------|
| 1-bed (city centre) | S$3,509 | S$5,675 | -38% |
| 1-bed (outside centre) | S$2,614 | S$3,509 | -26% |
| Meal (cheap restaurant) | S$12.33 | S$31.68 | -61% |
| McDonald's meal | S$10.00 | S$17.74 | -44% |
| Monthly transport pass | S$128 | S$170 | -25% |
| Mobile plan (10GB+) | S$17.97 | S$85.13 | -79% |
| Broadband | S$37.41 | S$86.17 | -57% |
| Private kindergarten | S$1,849 | S$4,306 | -57% |
| International school | S$40,085 | S$74,425 | -46% |

**Summary:** Singapore is significantly cheaper than NYC across almost all categories except cars.

### Singapore vs Dubai

| Category | Singapore | Dubai | Notes |
|----------|-----------|-------|-------|
| 1-bed (city centre) | S$3,509 | S$3,200 | Similar |
| Food (hawker/street) | S$5-8 | S$5-10 | Similar |
| Fine dining | High | Higher | Dubai more expensive |
| Public transport | Excellent | Limited | SG wins |
| Car ownership | Extremely expensive | Affordable | Dubai wins |
| Alcohol | Expensive | Very expensive | Both high |
| Domestic help | S$1,400 | S$1,000 | Dubai cheaper |
| Taxes | 0% income (with conditions) | 0% income | Similar |

---

## 11. Money-Saving Tips

### Housing
- Live in mature HDB estates (Tampines, Bedok, Toa Payoh)
- Consider sharing apartment/flat
- Look for "no agent" listings on Carousell

### Food
- Eat at hawker centres (S$5-8 vs S$20+ restaurants)
- Cook at home using FairPrice/Sheng Siong
- Avoid alcohol at bars (buy from supermarket)

### Transport
- Use MRT + bus, avoid Grab during peak
- Walk - Singapore is compact
- GrabShare saves 20-30%

### Shopping
- Wait for Great Singapore Sale (June-August)
- Use Shopee/Lazada for better prices
- Join FB groups for second-hand items

### Healthcare
- Use polyclinics (even foreigners can)
- Buy insurance via employer if possible
- Dental tourism to JB Malaysia (30 mins away)

---

## 12. Taxes (The Good News!)

Singapore has LOW taxes:

### Income Tax (Residents)
| Income (S$) | Tax Rate |
|-------------|----------|
| First 20,000 | 0% |
| 20,001-30,000 | 2% |
| 30,001-40,000 | 3.5% |
| 40,001-80,000 | 7% |
| 80,001-120,000 | 11.5% |
| 120,001-160,000 | 15% |
| 160,001-200,000 | 18% |
| 200,001-320,000 | 19% |
| 320,001-500,000 | 20% |
| 500,001-1,000,000 | 22% |
| >1,000,000 | 24% |

**Effective rate example:**
- S$100,000 income → ~8% effective tax
- S$200,000 income → ~13% effective tax

### No Taxes On:
- Capital gains
- Dividends (from Singapore companies)
- Interest income (usually)
- Inheritance

### GST (Sales Tax)
- 9% on most goods and services
- Tourist refunds available

---

*Last updated: February 2026*
*Exchange rates: S$1 = ~US$0.79 = ~£0.58 = ~€0.69*
