# Singapore Climate Guide 2024-2026
## Surviving and Thriving in the Tropics

---

## 1. Climate Overview

Singapore has a **tropical rainforest climate** (Köppen: Af) - hot, humid, and wet year-round.

### Key Climate Facts
| Parameter | Value |
|-----------|-------|
| Latitude | 1.3°N (85 km north of equator) |
| Average Temperature | 27.5°C (81.5°F) |
| Daily High | 31-33°C (88-91°F) |
| Daily Low | 24-25°C (75-77°F) |
| Annual Rainfall | 2,113 mm (83 inches) |
| Rainy Days | 171 days/year |
| Humidity | 80-90% |
| UV Index | Very high (10-12) |

**TL;DR:** It's always summer, always humid, and rain can happen any day.

---

## 2. No Seasons (But Two Monsoons)

Unlike temperate countries, Singapore doesn't have spring/summer/autumn/winter. Instead, weather patterns are governed by **monsoons**.

### The Two Monsoon Seasons

#### Northeast Monsoon (December - Early March)
**Characteristics:**
- Winds from north/northeast
- **Wet phase** (December - January): Heavy, prolonged rain
- **Dry phase** (February - March): Less rain, more wind
- Cooler temperatures (still 25-31°C)
- Occasional "cold" nights (24°C feels cold after acclimatizing!)

**What to Expect:**
- December-January: Monsoon surges bring continuous rain
- Rain can last hours (not just short bursts)
- Flooding in low-lying areas possible
- Christmas often wet

#### Southwest Monsoon (June - September)
**Characteristics:**
- Winds from south/southeast
- Generally drier than NE monsoon
- **Sumatra Squalls:** Pre-dawn to midday thunderstorms
- Hot afternoons

**What to Expect:**
- Early morning squalls (3-9 AM)
- Afternoons often clear
- Regional haze possible (Indonesian fires)
- Hottest period of year

### Inter-Monsoon Periods

#### April - May (Pre-SW)
- Light, variable winds
- Frequent afternoon thunderstorms
- **Hottest months** - temperatures can hit 35°C+
- Dramatic thunderstorms (impressive!)

#### October - November (Pre-NE)
- Transitional weather
- Afternoon thunderstorms
- Generally wetter than April-May
- Flash floods more common

---

## 3. Temperature Details

### Monthly Averages

| Month | Avg High (°C) | Avg Low (°C) | Rain Days |
|-------|---------------|--------------|-----------|
| January | 30.1 | 23.3 | 13 |
| February | 31.1 | 23.6 | 8 |
| March | 31.6 | 24.0 | 11 |
| April | 31.7 | 24.4 | 15 |
| May | 31.6 | 24.8 | 15 |
| June | 31.3 | 24.8 | 13 |
| July | 31.0 | 24.5 | 14 |
| August | 31.1 | 24.5 | 14 |
| September | 31.2 | 24.3 | 14 |
| October | 31.4 | 24.1 | 16 |
| November | 30.8 | 23.8 | 18 |
| December | 30.0 | 23.5 | 17 |

**Key Takeaway:** Temperature barely varies (30-32°C highs year-round). The difference is rainfall and humidity.

### Extreme Temperatures
- **Record high:** 37.0°C (May 1998, Tengah)
- **Record low:** 19.4°C (January 1934, rarely below 21°C now)
- **Modern cold:** 21-22°C occasionally in Dec-Jan mornings

---

## 4. Rainfall Patterns

### When It Rains

**By Time of Day:**
- Morning showers: More common during SW monsoon (Sumatra squalls)
- Afternoon thunderstorms: Year-round, especially inter-monsoon
- Evening clearing: Usually dries out by evening
- Night rain: Common during NE monsoon

**Duration:**
- Afternoon thunderstorms: 30 mins - 2 hours
- Monsoon rain: Can last 4-8 hours
- Sumatra squalls: 1-3 hours

### Rainfall Distribution
- **Wettest:** November-January (monsoon rain)
- **Driest:** February (dry phase of NE monsoon)
- **Heaviest single events:** Thunderstorms (can dump 50+ mm in hours)

### Flash Floods
Low-lying areas prone to localized flooding:
- Orchard Road (yes, the shopping street)
- Some HDB estates
- Underground roads

Usually drains within 1-2 hours.

---

## 5. Humidity (The Real Challenge)

### Understanding Singapore Humidity

| Time | Relative Humidity |
|------|-------------------|
| Morning (6 AM) | 90-95% |
| Afternoon (3 PM) | 60-70% |
| After rain | 95%+ |
| Average | 82% |

**What This Means:**
- Sweat doesn't evaporate efficiently
- You will feel hotter than the temperature suggests
- "Feels like" temperature often 38-42°C
- Mold grows easily (especially in closed wardrobes)

### Heat Index
When it's 32°C with 80% humidity:
- **Feels like:** 41°C
- **Heat risk:** High

This is normal daily conditions in Singapore!

---

## 6. Dealing with the Heat

### Acclimatization
**Timeline:**
- Week 1-2: Exhaustion, excessive sweating
- Week 3-4: Starting to adjust
- Month 2-3: Reasonably comfortable
- 6+ months: Fully acclimatized (24°C feels "cold")

### Practical Tips

#### Clothing
- **Wear:** Light, breathable fabrics (cotton, linen, technical fabrics)
- **Avoid:** Dark colors, synthetic materials that trap heat
- **Essential:** Umbrella (for sun AND rain)

#### Hydration
- Drink 2-3 liters of water daily
- Don't wait until thirsty
- Sports drinks for heavy exercise
- Avoid excessive caffeine/alcohol (dehydrating)

#### Managing Daily Life
| Challenge | Solution |
|-----------|----------|
| Hot commute | Use MRT (air-conditioned) |
| Outdoor activities | Schedule for early morning or evening |
| Midday heat | Stay indoors, malls, offices |
| Sleeping | Use AC or fan at night |
| Exercising | Go before 8 AM or after 6 PM |

#### Home Tips
- Run air-con at 24-25°C (efficient + comfortable)
- Use dehumidifier for wardrobes/storage
- Keep windows ventilated when AC off
- Anti-mold products for bathrooms

### Heat-Related Illness

**Warning Signs of Heat Exhaustion:**
- Heavy sweating
- Weakness, nausea
- Headache, dizziness
- Cool, pale skin

**What to Do:**
1. Move to cool area
2. Drink water
3. Apply cool water to skin
4. Seek medical help if symptoms persist

**Heat Stroke (Emergency):**
- Hot, red, dry skin
- Confusion
- Loss of consciousness
- Call 995 immediately

---

## 7. The Haze Problem

### What Is Haze?
Smoke from agricultural fires (primarily in Sumatra and Kalimantan, Indonesia) blown to Singapore by winds.

### When Does It Occur?
- **Primary season:** June - October (dry season in Indonesia)
- **Worst years:** 1997, 2013, 2015, 2019
- **Better years:** When Indonesia has good enforcement

### PSI (Pollutant Standards Index)

| PSI Level | Category | Guidance |
|-----------|----------|----------|
| 0-50 | Good | Normal activities |
| 51-100 | Moderate | Normal activities |
| 101-200 | Unhealthy | Reduce outdoor activity |
| 201-300 | Very Unhealthy | Avoid outdoor activity |
| 300+ | Hazardous | Stay indoors |

### Dealing with Haze
- Check PSI at **nea.gov.sg** or Singpass app
- Keep N95 masks handy
- Air purifier recommended for home
- Stay indoors when PSI >100
- Schools may cancel outdoor activities

### Air Quality Apps
- **myENV** (official NEA app)
- **Air Quality SG**
- **IQAir**

---

## 8. UV and Sun Protection

### UV Index in Singapore
| Level | Rating | Time |
|-------|--------|------|
| 7-9 | Very High | Most of day |
| 10-12 | Extreme | 11 AM - 3 PM |

Singapore has some of the **highest UV levels in the world** due to equatorial location.

### Sun Protection Essentials
- **SPF 30-50** sunscreen (reapply every 2 hours)
- Sunglasses with UV protection
- Hat or umbrella
- Seek shade during peak hours (11 AM - 3 PM)

### Vitamin D
Despite intense sun, many Singaporeans are Vitamin D deficient (everyone stays indoors to avoid heat). Consider:
- 10-15 mins sun exposure before 10 AM
- Vitamin D supplements if needed

---

## 9. What to Pack

### Essential Items
| Item | Why |
|------|-----|
| Umbrella | Rain + sun protection |
| Light cotton clothes | Breathable |
| Sandals/flip-flops | Everyday wear |
| Closed shoes | Office, some restaurants |
| Light cardigan | Aggressive AC everywhere |
| Swimwear | Pools, beaches |
| Sunglasses | High UV |
| Sunscreen SPF 30+ | Essential |
| Portable fan | Nice-to-have |

### What NOT to Bring
- Heavy coats (you'll never use them)
- Too many jeans (too hot)
- Dark colored clothes
- Heavy sweaters

### The Air-Con Dilemma
Singapore has AGGRESSIVE air conditioning:
- Offices: 20-22°C (cold!)
- Malls: 22-24°C
- Restaurants: 20-24°C
- MRT: 22-24°C

**Solution:** Always carry a light jacket/cardigan. You'll freeze indoors and sweat outside.

---

## 10. Monthly Guide

### January
- NE Monsoon wet phase
- 24-30°C
- Frequent rain
- Good for: Indoor activities, museum visits

### February
- Driest month
- 24-31°C
- Chinese New Year (hot + crowded)
- Good for: Outdoor activities

### March
- Transitioning
- 25-32°C
- Occasional rain
- Good for: Beach, outdoor events

### April
- Inter-monsoon
- 25-32°C (can hit 35°C)
- Dramatic thunderstorms
- Good for: Stay hydrated!

### May
- Hottest month
- 25-32°C (feels like 40°C)
- Afternoon storms
- Good for: Indoor activities, pools

### June
- SW Monsoon starts
- 25-31°C
- Early morning squalls
- Good for: School holiday activities

### July-August
- SW Monsoon continues
- 25-31°C
- Haze risk begins
- Good for: Indoor activities if hazy

### September
- Haze risk peaks
- 25-31°C
- Check air quality daily
- Good for: Indoor activities, F1 race!

### October
- Inter-monsoon
- 25-31°C
- Afternoon storms
- Good for: Outdoor activities (watch for rain)

### November
- Wettest month
- 24-31°C
- Heavy rain common
- Good for: Indoor activities

### December
- NE Monsoon wet phase
- 24-30°C
- Christmas can be wet
- Good for: Festive events, indoor activities

---

## 11. Climate Change Impact

### Observed Changes
- Temperature: Rising ~0.25°C per decade
- More extreme rainfall events
- Sea level rise (threat to low-lying island)
- More frequent hot days (>35°C)

### Singapore's Response
- Coastal protection infrastructure
- Urban heat island mitigation
- Green building requirements
- Tree planting initiatives

### What Residents Notice
- Hotter summers
- More intense but shorter rain
- AC usage increasing
- Flash floods more common

---

## 12. Useful Resources

### Weather Information
- **weather.gov.sg** - Official forecasts
- **nea.gov.sg** - Air quality, haze
- **myENV app** - Real-time environmental data

### Forecasting Tips
- Weather forecasts are typically accurate 3-5 days ahead
- Afternoon rain is assumed, not always predicted
- Check hourly forecasts for outdoor planning

---

## Quick Reference Card

| Parameter | Value |
|-----------|-------|
| It's always | Hot (30-33°C) |
| Humidity | Very high (80%+) |
| Rain | Possible any day |
| Best hours outside | 7-10 AM, 5-7 PM |
| AC temperature | 20-24°C (bring jacket!) |
| UV | Extreme (wear sunscreen) |
| Worst haze months | Aug-Oct |
| Wettest months | Nov-Jan |
| Hottest months | Apr-May |

---

*Last updated: February 2026*
