# Singapore Business Setup Guide 2024-2026

## Overview

Singapore is consistently ranked as one of the easiest places in the world to do business:
- **Ease of Doing Business**: Top 2 globally (World Bank)
- **Company registration**: Can be completed in 15 minutes online
- **Corporate tax**: Flat 17% (with exemptions for startups)
- **No capital gains tax, no dividend tax**
- **100% foreign ownership** allowed for most businesses
- **Strong IP protection** and rule of law

---

## ACRA (Accounting and Corporate Regulatory Authority)

### What is ACRA?
- National regulator of business entities in Singapore
- Handles company registration, filing, and compliance
- Online portal: **BizFile+** (bizfile.gov.sg)

### Registration Timeline
| Step | Duration |
|------|----------|
| Name reservation | 15 minutes (instant if available) |
| Company incorporation | 15 minutes - 1 day |
| Bank account opening | 1-4 weeks |
| Total setup | 2-6 weeks |

---

## Company Types

### 1. Private Limited Company (Pte Ltd) ⭐ RECOMMENDED

**Best for**: Most tech startups, SMEs, foreign entrepreneurs

#### Characteristics
- Separate legal entity from owners
- Limited liability (shareholders' personal assets protected)
- Can raise funding, issue shares
- Professional image for B2B
- Can apply for government grants

#### Requirements
| Requirement | Details |
|-------------|---------|
| **Shareholders** | Min 1, max 50 (individuals or corporate) |
| **Directors** | Min 1 local (Singapore citizen, PR, or EP holder) |
| **Company Secretary** | Required within 6 months, must be local resident |
| **Registered Address** | Singapore physical address (cannot be PO Box) |
| **Paid-up Capital** | Min $1 (can be any amount) |
| **Financial Year End** | Choose any date |

#### Formation Costs (Pte Ltd)
| Item | Cost (SGD) |
|------|-----------|
| **ACRA registration fee** | $315 |
| **Name reservation (optional)** | $15 |
| **Corporate secretary (annual)** | $300-800 |
| **Registered address (if needed)** | $200-500/year |
| **Constitution (standard template)** | Free |
| **Professional incorporation service** | $300-800 |
| **Total DIY** | $315-515 |
| **Total with service provider** | $600-1,500 |

### 2. Sole Proprietorship

**Best for**: Freelancers, simple single-owner businesses

#### Characteristics
- Simplest structure
- Owner personally liable for all debts
- Profits taxed as personal income
- Cannot raise equity funding
- Less professional image

#### Requirements
| Requirement | Details |
|-------------|---------|
| **Owner** | Must be Singapore citizen, PR, or EntrePass holder (EP not eligible) |
| **Manager** | If foreigner, need local manager |
| **Registered Address** | Singapore address |

#### Costs (Sole Prop)
| Item | Cost (SGD) |
|------|-----------|
| **ACRA registration fee** | $115/year |
| **Name reservation** | $15 |
| **Annual renewal** | $115 |

### 3. Partnership / LLP (Limited Liability Partnership)

**Best for**: Professional services firms, co-founders who want liability protection

#### LLP Characteristics
- Partners have limited liability
- Tax-transparent (partners taxed individually)
- Good for professional services (law, accounting)
- Registration fee: $115-165

### 4. Subsidiary / Branch Office

**Best for**: Foreign companies expanding to Singapore

| Type | Characteristics |
|------|-----------------|
| **Subsidiary (Pte Ltd)** | Separate legal entity, fully liable locally, can access grants |
| **Branch Office** | Extension of parent company, parent fully liable, limited grants |
| **Representative Office** | Non-trading, market research only, limited duration |

---

## Step-by-Step: Register a Pte Ltd

### Pre-requisites
1. **Company name**: Unique, approved by ACRA
2. **At least 1 local director**: Citizen, PR, or work pass holder residing in Singapore
3. **Registered address**: Physical Singapore address
4. **Company secretary**: Appoint within 6 months
5. **Constitution**: Standard template or custom

### Registration Process

#### Step 1: Reserve Company Name
- Go to BizFile+ (bizfile.gov.sg)
- Search for name availability
- Pay $15, valid for 120 days
- **Naming rules**: Cannot be identical/similar to existing names, offensive, or suggest government connection

#### Step 2: Prepare Documents
- Shareholder details (passport, address)
- Director details (local director required)
- Registered address proof
- Constitution (can use standard template)
- Consent letters from directors/shareholders

#### Step 3: Submit Incorporation
- Complete BizFile+ application
- Upload documents
- Pay $315 incorporation fee
- **Processing**: Usually instant, may take 1-3 days for manual review

#### Step 4: Receive Incorporation Documents
- Certificate of Incorporation
- Business Profile
- Company Registration Number (UEN)

#### Step 5: Post-Incorporation
- Open corporate bank account
- Appoint company secretary (within 6 months)
- Set up accounting system
- Register for GST if revenue > $1M/year

---

## Corporate Tax

### Tax Rate Structure

| Income | Tax Rate |
|--------|----------|
| Standard corporate tax | **17%** (flat) |
| First $10,000 | 75% exemption |
| Next $190,000 | 50% exemption |
| Above $200,000 | 17% (no exemption) |

### Effective Tax Rate Examples

| Chargeable Income | Tax Payable | Effective Rate |
|-------------------|-------------|----------------|
| $100,000 | $5,525 | 5.5% |
| $200,000 | $22,100 | 11.1% |
| $300,000 | $39,100 | 13.0% |
| $500,000 | $73,100 | 14.6% |
| $1,000,000 | $158,100 | 15.8% |

### Startup Tax Exemption Scheme (First 3 Years)

**For qualifying new companies:**

| Chargeable Income | Exemption | Tax Savings |
|-------------------|-----------|-------------|
| First $100,000 | 75% exempt | Up to $12,750 |
| Next $100,000 | 50% exempt | Up to $8,500 |
| **Maximum benefit** | | $21,250/year |

**Eligibility**:
- Incorporated in Singapore
- Tax resident in Singapore
- No more than 20 shareholders
- At least 1 individual shareholder holds ≥10% shares
- NOT investment holding or property development

### CIT Rebate (2024-2026)

| Year of Assessment | Rebate | Cap |
|--------------------|--------|-----|
| YA 2024 | 50% | $40,000 |
| YA 2025 | 50% | $40,000 |
| YA 2026 | 40% | $30,000 |

**Cash Grant**: Companies with at least 1 local employee receive additional $1,500-2,000 cash grant.

### Other Tax Benefits
- **No capital gains tax**: Sell shares/assets tax-free
- **No dividend tax**: Shareholders receive dividends without withholding
- **No foreign income tax**: Foreign-sourced income not taxed if not remitted
- **R&D tax incentives**: 250% deduction on qualifying R&D expenditure
- **IP incentives**: 5-10% concessionary tax rates on qualifying IP income

---

## Bank Account Opening

### Major Banks for Businesses

| Bank | Pros | Cons | Opening Time |
|------|------|------|--------------|
| **DBS** | Largest, good digital services | Higher scrutiny | 1-2 weeks |
| **OCBC** | SME-friendly, good rates | Slightly slower | 1-3 weeks |
| **UOB** | Strong in region | Conservative | 1-2 weeks |
| **Standard Chartered** | International focus | Higher fees | 2-4 weeks |
| **HSBC** | Global network | Highest scrutiny | 2-4 weeks |

### Digital/Fintech Banks
- **Aspire**: Fast opening, SME-focused, expense management
- **Airwallex**: Multi-currency, good for cross-border
- **Wise Business**: Low FX fees, virtual accounts

### Documents Required
1. Board resolution to open account
2. Certificate of Incorporation
3. Company Constitution
4. Business Profile (ACRA)
5. Directors' and shareholders' IDs (passport, proof of address)
6. Description of business activities
7. Expected transaction volumes

### Tips for Foreign Directors
- Singapore bank account opening requires at least 1 director to visit Singapore in person
- Some banks accept video KYC for foreign directors
- Prepare detailed business plan and source of funds documentation
- Be ready to explain business model clearly

---

## EntrePass (Entrepreneur Pass)

### Overview
Work pass for foreign entrepreneurs starting/operating innovative businesses in Singapore.

### Eligibility Criteria (Meet at least 1)

| Criterion | Requirement |
|-----------|-------------|
| **Venture Funding** | Raised ≥$100,000 SGD from recognized VC/investor |
| **Incubator/Accelerator** | Supported by government-recognized or renowned program |
| **Serial Entrepreneur** | Founded and sold a venture-backed/innovative company |
| **Intellectual Property** | Business owns registered IP from approved institution |
| **Research Collaboration** | Ongoing research partnership with Singapore IHL/RI |

### Company Requirements
- Private Limited Company registered with ACRA
- Applicant holds ≥30% shares
- Company < 12 months old at application (or renewal criteria apply)
- **NOT eligible**: Food stalls, bars, massage parlors, traditional medicine, employment agencies, geomancy

### Processing & Fees
| Item | Details |
|------|---------|
| Processing time | 8 weeks |
| Application fee | $105 |
| Issuance fee | $225 |
| Pass validity | 1 year (first pass), 2 years (renewal) |

### Renewal Criteria
After first year, must meet hiring/business milestones:
- Create local jobs
- Meet revenue targets
- Meet capital raised targets

### Family
- **After 6 months**: Can apply for Dependant's Pass (spouse, children) and LTVP (parents)
- **Requirement**: Company meets renewal criteria

---

## Ongoing Compliance

### Annual Requirements

| Requirement | Deadline | Cost |
|-------------|----------|------|
| **Annual Return (AR)** | Within 7 months of FYE | $60 |
| **AGM** | Within 6 months of FYE | Internal |
| **Financial Statements** | File with AR | $0 |
| **Tax Filing (Form C-S)** | By Nov 30 | $0 |
| **Company Secretary renewal** | Annual | $300-800/year |
| **Registered address** | Keep updated | $200-500/year |

### Small Company Exemption
Companies can file simplified accounts if they meet 2 of 3:
- Revenue ≤ $10 million
- Assets ≤ $10 million
- Employees ≤ 50

### GST (Goods and Services Tax)
- **Rate**: 9% (as of 2024)
- **Registration threshold**: Annual revenue > $1 million
- **Voluntary registration**: Optional for smaller companies

---

## Cost Summary

### Startup Costs (Pte Ltd)

| Item | Min Cost | Typical | Notes |
|------|----------|---------|-------|
| ACRA registration | $315 | $315 | One-time |
| Name reservation | $15 | $15 | Optional |
| Corporate secretary | $300 | $500 | Annual |
| Registered address | $0 | $300 | If using service |
| Incorporation service | $0 | $500 | Optional professional help |
| Bank account | $0 | $0 | Usually free |
| **Total Year 1** | **$315** | **$1,000-1,500** | |

### Annual Operating Costs

| Item | Cost Range |
|------|-----------|
| Corporate secretary | $300-800 |
| Registered address | $200-500 |
| Accounting/bookkeeping | $1,200-3,600 |
| Annual Return | $60 |
| Audit (if required) | $2,000-5,000 |
| **Total (small company)** | **$1,800-3,000/year** |
| **Total (audit required)** | **$4,000-8,000/year** |

---

## Useful Resources

### Government
- **ACRA**: acra.gov.sg
- **BizFile+**: bizfile.gov.sg
- **IRAS** (taxes): iras.gov.sg
- **Enterprise Singapore**: enterprisesg.gov.sg

### Tools
- **GoBusiness**: gobusiness.gov.sg (one-stop government services)
- **Startup SG**: startupsg.gov.sg

### Service Providers (Examples)
- Incorporate online services
- Corporate secretarial firms
- Accounting firms familiar with tech startups

---

*Last Updated: February 2026*
*Sources: ACRA, IRAS, MOM, Enterprise Singapore*
