---
name: Singapore
slug: singapore
version: 1.0.0
homepage: https://clawic.com/skills/singapore
description: Navigate Singapore as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🦁","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Singapore for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| CBD, Marina Bay, Raffles | `neighborhoods-central.md` |
| Orchard, Newton, River Valley | `neighborhoods-orchard.md` |
| Katong, East Coast, Bedok | `neighborhoods-east.md` |
| Novena, Toa Payoh, Bishan | `neighborhoods-suburbs.md` |
| Holland Village, Clementi, Jurong | `neighborhoods-west.md` |
| Woodlands, Yishun, Punggol | `neighborhoods-north.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & hawker culture | `food-overview.md` |
| Local cuisine (chicken rice, laksa) | `food-local.md` |
| International & fine dining | `food-international.md` |
| Michelin stars & speakeasies | `food-fine-dining.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, alcohol, practical | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (MRT, buses, Grab) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & survival tips | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & ACRA | `business.md` |
| Visas (EP, S Pass, PR) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Driving & COE system | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. City-State Reality
Singapore is a city-state with unique characteristics:
- **Size**: 733 km² — everything is accessible within 1 hour by MRT
- **Population**: 5.9 million (74% Chinese, 13% Malay, 9% Indian)
- **Language**: English is primary business language; Singlish widely spoken
- **Government**: Highly efficient, strict laws, low corruption

### 3. Visa Categories
Employment requires proper visa sponsorship:
- **EP (Employment Pass)**: S$5,600+ salary, COMPASS framework (40 points)
- **S Pass**: S$3,300+ salary, quota-limited
- **Dependent Pass**: Requires S$6,000+ sponsor salary
- **PR pathway**: Typically 2-5 years with stable employment
See `visas.md` for current requirements (Feb 2026).

### 4. Weather Reality
Singapore is tropical year-round:
- **Temperature**: 27-32°C constant, no seasons
- **Humidity**: 80%+ average — acclimatization takes 2-4 weeks
- **Rain**: Afternoon thunderstorms common, carry umbrella always
- **Monsoons**: NE (Dec-Mar), SW (Jun-Sep) — affects outdoor activities
See `climate.md` for monthly breakdown.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (CBD) | S$3,000-5,000/month |
| 1BR rent (suburbs) | S$2,000-3,500/month |
| HDB room rental | S$800-1,500/month |
| Senior SWE salary | S$12,000-20,000/month |
| MRT monthly pass | S$128 (adult) |
| Hawker meal | S$4-8 |
| Restaurant dinner | S$30-100/person |
| International school | S$30,000-55,000/year |

### 6. Cost Reality
Singapore is expensive but tax-efficient:
- **No capital gains tax, no inheritance tax**
- **Income tax**: 0-24% progressive (most pay 7-15%)
- **Housing**: 30-50% of budget typical for expats
- **COE (car permit)**: S$100,000-150,000 for 10 years — most don't drive
- **Hidden costs**: Agent fees (1 month rent), security deposits (2 months)
- **Hawker centres**: Affordable meals (S$4-8) offset restaurant costs

### 7. Transit Excellence
Unlike most cities, Singapore has world-class public transport:
- **MRT**: 6 lines, 140+ stations, S$1-2.50 per trip
- **Buses**: Extensive network, same EZ-Link/SimplyGo card
- **Grab**: Primary ride-hailing, S$8-25 for most trips
- **No car needed**: 90%+ of residents don't own cars
See `transport.md` for complete guide.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Tiong Bahru, Tanjong Pagar, Robertson Quay |
| Families | East Coast, Bukit Timah, Holland Village |
| Budget-conscious | Woodlands, Jurong, Tampines |
| Tech workers | One-north, CBD, Tanjong Pagar |
| Beach lifestyle | East Coast, Katong, Sentosa Cove |
| Food lovers | Tiong Bahru, Jalan Besar, Katong |

## Food Culture Context

Singapore is a UNESCO-recognized hawker food destination:
- **Hawker centres**: 100+ centres, 6,000+ stalls, heritage status
- **Must-try dishes**: Chicken rice, laksa, char kway teow, bak kut teh, chili crab
- **Michelin**: 3 three-star, 7 two-star, 32 one-star restaurants
- **Speakeasies**: Jigger & Pony (#3 Asia), 28 Hong Kong Street
- **Halal**: Widely available, MUIS certification

See `food-overview.md` for complete guide.

## Singapore-Specific Traps

- **Chewing gum ban** — Importing gum for personal use is illegal. Don't bring it.
- **Drug laws** — Zero tolerance. Death penalty for trafficking. Even trace amounts = prison.
- **Vandalism** — Criminal offense including caning. Don't graffiti anything.
- **Jaywalking** — S$50 fine within 50m of crossing. Police do enforce.
- **Smoking** — Banned in most public areas. S$200+ fines.
- **Littering** — S$300 first offense, S$1,000+ repeat. Very enforced.
- **Public intoxication** — Liquor control areas 10:30pm-7am in some zones.
- **LGBTQ+** — 377A repealed (2022) but limited protections. Discretion advised.
- **Criticism of government** — Defamation laws strict. Avoid public criticism.
- **Photography** — No photos at government/military installations.
- **Overstaying visa** — Criminal offense, caning possible. Don't overstay.

## Legal Awareness

Key laws every visitor/resident must know:
- **Drugs**: Zero tolerance. Death penalty for 15g heroin, 500g cannabis.
- **Weapons**: Strictly prohibited including pocket knives.
- **Alcohol**: Legal at 18+, retail sales end 10:30pm.
- **Public order**: Unlicensed gatherings >1 person in public can be illegal.
- **Internet**: VPNs legal but bypassing government blocks is not.
- **Employment**: Working without valid pass = deportation + ban.

See `safety.md` for comprehensive legal guidance.
