---
name: singapore-location-helper
description: "🇸🇬 新加坡租房选址专家：精确到楼栋的推荐、通勤分析、避坑指南，帮你找到最适合的居住区域"
metadata:
  {
    "openclaw":
      {
        "emoji": "🇸🇬",
        "requires": { "bins": [] },
        "homepage": "https://github.com/gisellekokkok/WhereToLeave_SG",
        "author": "gisellekokkok",
        "version": "1.0.0",
        "tags": ["singapore", "housing", "rental", "location", "expat"],
        "pricing": "free"
      }
  }
---

# 🏠 新加坡选址助手

**专为来新加坡工作、留学、定居的人群设计**

## 💡 为什么选择这个 Skill？

- ✅ **精确到楼栋**：不只是区域，具体到哪个公寓、哪条街
- ✅ **真实数据**：基于 2025-2026 年最新租金和交通信息
- ✅ **避坑指南**：噪音、朝向、施工等中介不会告诉你的事
- ✅ **个性化推荐**：根据你的预算、工作地点、生活方式定制

## 🎯 适合谁用？

- 刚来新加坡的留学生
- 拿到 offer 准备 relocate 的打工人
- 带孩子来新加坡上学的家庭
- 想换房但不知道选哪里的在住居民

## 📦 包含内容

1. **区域概览**：7大区域详细分析（租金、特点、适合人群）
2. **交通评估**：MRT距离、shelter覆盖、通勤时间计算
3. **生活便利**：超市、食阁、诊所覆盖度评估
4. **看房清单**：噪音、朝向、设施等20+检查项
5. **楼盘推荐**：Tanjong Pagar、One-North 等热门区域具体公寓
6. **避坑指南**：常见陷阱和应对方法

## 💬 使用示例

```
用户：我在金沙上班，预算4000新币，喜欢安静

Skill 会分析：
- 工作地点：Marina Bay Sands (Bayfront MRT)
- 推荐区域：Tanjong Pagar（1站MRT）、Outram Park（2站MRT）
- 具体楼盘：Icon、Duo Residences 等
- 避坑提醒：注意朝向、噪音、周边配套
```

## 📊 数据来源

- PropertyGuru、99.co（租金数据）
- LTA（交通数据）
- MOE（学校数据）
- URA（规划数据）

*数据定期更新，确保准确性*

---

# 新加坡选址助手

帮助用户在新加坡选择最适合的居住或办公区域，基于预算、通勤需求、生活方式等维度提供建议。

## 核心功能

### 1. 区域概览与对比

新加坡主要区域分类：

**市中心/商务区 (CBD)**
- 区域：Raffles Place, Marina Bay, Tanjong Pagar
- 特点：高端公寓、步行上班、夜生活丰富
- 租金：$4,000-8,000/月 (1-2房)
- 适合：金融从业者、喜欢都市生活

**东海岸/滨海 (East Coast/Marine Parade)**
- 区域：Katong, Joo Chiat, Marine Parade
- 特点：本地美食、海滩休闲、家庭友好
- 租金：$3,000-5,500/月
- 适合：家庭、喜欢本地文化

**荷兰村/武吉知马 (Holland Village/Bukit Timah)**
- 特点：国际学校集中、绿树成荫、外籍社区
- 租金：$4,500-7,000/月
- 适合：有孩子的外国家庭

**诺维娜/汤申 (Novena/Thomson)**
- 特点：医疗中心、适中租金、交通便利
- 租金：$3,500-6,000/月
- 适合：医疗从业者、预算敏感

**纬壹/港湾 (One-North/Harbourfront)**
- 特点：科技园区、创业氛围、靠近圣淘沙
- 租金：$3,500-5,500/月
- 适合：科技从业者、初创公司

**裕廊湖/西部 (Jurong Lake/West)**
- 特点：第二CBD发展中、租金较低、工业配套
- 租金：$2,500-4,500/月
- 适合：制造业、预算优先

### 2. 选址决策框架

根据以下维度评估：

| 维度 | 问题 |
|------|------|
| 预算 | 月租金预算范围？ |
| 通勤 | 工作地点在哪？MRT/bus偏好？ |
| 家庭 | 有孩子吗？需要国际学校？ |
| 生活方式 | 喜欢热闹/安静？需要夜生活？ |
| 餐饮 | 偏好本地美食/国际料理？ |
| 租期 | 短期(1年内)/长期？ |

### 3. 实用工具

**租金参考查询**
```
PropertyGuru: https://www.propertyguru.com.sg
99.co: https://www.99.co
EdgeProp: https://www.edgeprop.sg
```

**MRT线路规划**
- 使用官方 MRT 地图判断通勤时间
- 高峰期 (7-9am, 6-8pm) 避开东西线拥堵段

**学区查询**
- 政府学校：MOE 官网查询学额
- 国际学校：SAS, UWC, Tanglin Trust 集中在武吉知马/裕廊

---

### 3.1 交通可达性评估（关键！）

**到地铁站距离标准：**

| 距离 | 步行时间 | 评价 | 对租金影响 |
|------|----------|------|------------|
| ≤ 300m | 3-4分钟 | 🟢 极优 | +10-15% |
| 300-500m | 5-7分钟 | 🟡 良好 | 基准 |
| 500-800m | 8-10分钟 | 🟠 可接受 | -5-10% |
| > 800m | >10分钟 | 🔴 偏远 | -15-20% |

**Sheltered Walkway（有盖走廊）重要性：**
- 新加坡多雨，有 shelter 大幅提升居住体验
- 无 shelter 路段：雨天需带伞，夏天暴晒
- 查看方式：Google Maps Street View 或实地踩点

**交通评估检查清单：**
- [ ] 到最近 MRT 步行距离 ___ 米（实测，非广告距离）
- [ ] 是否有 sheltered walkway 全程覆盖？
- [ ] 夜间步行安全性（路灯、人流）
- [ ] 到工作地点 MRT 站数 ___ 站，换乘 ___ 次
- [ ] 早高峰拥挤程度（东西线 vs 环线 vs 市区线）
- [ ] 是否有直达 bus（有时比 MRT 更快）

**常用工具：**
- Google Maps：测步行距离和时间
- Citymapper/SG Buses：查公交路线
- LTA MyTransport：官方交通 app，查实时拥挤度

**实地踩点建议：**
1. 从房源走到 MRT，记录实际步数和时间
2. 观察是否有 shelter（注意：有些路段只有部分覆盖）
3. 雨天和晴天各走一次，体验差异
4. 晚上 9-10 点走一次，评估安全性

### 4. 生活便利程度评估

**超市覆盖标准：**

| 距离 | 步行时间 | 便利程度 | 评价 |
|------|----------|----------|------|
| ≤ 300m | 3-4分钟 | 🟢 极便利 | 下楼即达，日常无忧 |
| 300-500m | 5-7分钟 | 🟡 便利 | 步行可达，适合日常采购 |
| 500-800m | 8-10分钟 | 🟠 一般 | 需规划采购，大件建议网购 |
| > 800m | >10分钟 | 🔴 不便 | 依赖网购或周末集中采购 |

**主要超市类型及特点：**

| 超市 | 定位 | 特点 | 适合购买 |
|------|------|------|----------|
| **FairPrice** | 平价大众 | 分布最广，价格亲民，24小时店多 | 日常食材、日用品 |
| **Cold Storage** | 中高端 | 进口商品多，品质好，价格较高 | 进口食材、西餐原料 |
| **Giant** | 大卖场 | 量大价优，适合周末集中采购 | 囤货、家庭装商品 |
| **Sheng Siong** | 平价华人 | 华人食材齐全，价格最低 | 中式调料、蔬菜肉类 |
| **Don Don Donki** | 日式 | 日本进口商品，24小时营业 | 日式食材、零食 |
| **Marks & Spencer** | 英式高端 | 进口食品，品质高 | 西餐食材、熟食 |

**生活便利检查清单：**
- [ ] 500m 内是否有超市？___家（FairPrice/Cold Storage/Sheng Siong）
- [ ] 1km 内是否有食阁/Hawker Centre？
- [ ] 楼下是否有便利店（7-11/Cheers）？
- [ ] 附近是否有诊所/药店（Guardian/Watsons）？
- [ ] 周边餐饮选择是否丰富？
- [ ] 是否有洗衣店/干洗店？
- [ ] 是否有健身房/运动设施？
- [ ] 快递自提点是否方便？

**各区域生活便利度参考：**

| 区域 | 超市覆盖 | 食阁密度 | 生活便利度 | 适合人群 |
|------|----------|----------|------------|----------|
| **Tanjong Pagar** | 🟢 多（多个FairPrice+CS） | 🟢 高（多个食阁） | ⭐⭐⭐⭐⭐ | 追求便利的上班族 |
| **Outram Park** | 🟢 多（Tiong Bahru Plaza） | 🟢 高（红山市场） | ⭐⭐⭐⭐⭐ | 喜欢本地美食 |
| **Novena** | 🟢 多（Velocity, Square 2） | 🟡 中 | ⭐⭐⭐⭐ | 医疗便利优先 |
| **Holland Village** | 🟡 中（CS为主） | 🟡 中 | ⭐⭐⭐⭐ | 外籍社区氛围 |
| **One-North** | 🟠 少（依赖附近） | 🟠 少 | ⭐⭐⭐ | 科技园区，需开车/网购 |
| **Jurong East** | 🟢 多（JEM, Westgate） | 🟢 高 | ⭐⭐⭐⭐⭐ | 家庭居住，配套成熟 |
| **Sengkang/Punggol** | 🟡 中（新组屋配套） | 🟡 中 | ⭐⭐⭐⭐ | 预算优先 |

**实用工具：**
- Google Maps：搜索 "supermarket near [地址]" 查看分布
- FairPrice/Cold Storage app：查最近门店及营业时间
- GrabMart/PandaMart：应急采购，30分钟送达

---

### 5. 看房必查清单（容易被遗漏的关键点）

**噪音评估：**
- [ ] **MRT 轨道噪音**：靠近高架轨道的单位（如 Icon 靠近 Tanjong Pagar MRT）
- [ ] **马路噪音**：低楼层面向主干道的单位
- [ ] **中庭回音**：大型公寓（如 Marina One）中庭户型可能有回音
- [ ] **空调外机**：确认邻居/楼下空调外机位置，是否靠近卧室窗户
- [ ] **施工噪音**：周边是否有工地（可在 URA 官网查周边开发计划）

**检测方法：**
- 关窗和开窗各待 5 分钟对比
- 晚上 9-10 点去一次（夜间噪音更明显）
- 下载手机噪音检测 app（如 Sound Meter）

**朝向与采光：**
- [ ] **朝向**：南北通透最佳，朝西下午西晒严重（空调费高 20-30%）
- [ ] **遮挡**：周边是否有高楼遮挡采光
- [ ] **楼层**：低楼层采光差但等电梯快，高楼层采光好但等电梯久

**实用设施检查：**
- [ ] **洗衣晾晒**：是否有 yard/utility room？多数公寓禁止外晒
- [ ] **停车位**：如有车，确认停车位是否包含，额外费用多少（$200-400/月）
- [ ] **网络覆盖**：确认宽带供应商选择（部分公寓有独家合约）
- [ ] **访客停车**：是否方便？门禁是否严格（影响外卖/快递）
- [ ] **电梯数量**：30层以上公寓，2部电梯以下高峰期等待时间长

**费用相关：**
- [ ] **管理费**：通常房东付，但高管理费（$400+/月）可能意味着房东更易涨租
- [ ] **水电费**：确认是否包含在租金内
- [ ] **空调清洗**：明确维修责任方（通常租客负责日常清洗）

**租约条款：**
- [ ] **提前解约**：是否允许？违约金多少？
- [ ] **续租涨幅**：是否有涨幅上限条款？
- [ ] **押金退还**：什么情况下扣押金？
- [ ] **入住时间**：确认前任租客搬出时间，避免空等

**周边施工查询：**
- URA 官网：https://www.ura.gov.sg
- 查 "Development Projects" 看周边是否有新工地
- 新工地 = 未来 2-3 年噪音+灰尘

---

### 6. 避坑指南

**租房注意事项：**
- 中介费：通常房东付，租客无需支付
- 印花税：租客承担，约租金的 0.4%
- 押金：通常 2 个月租金
- 空调维护：明确维修责任方
- 提前解约：通常需支付剩余租期租金

**区域避坑：**
- 芽笼 (Geylang)：部分区域红灯区，注意街道号码
- 小印度 (Little India)：周末拥挤，噪音较大
- 工业区附近：注意工厂噪音和货车通行

**生活便利避坑：**
- 不要被 "附近有很多餐厅" 迷惑，确认是否有平价食阁
- CBD 区域周末可能变成 "死城"，餐饮选择大幅减少
- 新开发区（如 Punggol）配套可能不完善，需确认超市开业情况
- 高层公寓（30楼以上）等电梯时间长，赶时间时要算进去

**看房必带工具：**
- 卷尺（确认实际面积，广告面积可能有水分）
- 指南针（确认朝向）
- 手机噪音检测 app
- 充电宝（看房一天手机容易没电）

---

### 7. 快速推荐

**场景化推荐：**

**金融从业者**
→ 推荐：Tanjong Pagar, Marina Bay, Raffles Place
→ 理由：步行或1-2站MRT到办公室

**科技/创业**
→ 推荐：One-North, Buona Vista, Tiong Bahru
→ 理由：靠近Fusionopolis, 创业氛围

**带娃家庭**
→ 推荐：Holland Village, Bukit Timah, Serangoon
→ 理由：国际学校集中，社区安全

**预算敏感**
→ 推荐：Sengkang, Punggol, Jurong East
→ 理由：新组屋多，租金相对低

**喜欢夜生活**
→ 推荐：Clarke Quay, Robertson Quay, Orchard
→ 理由：酒吧餐厅集中

---

## 使用示例

**场景1：基础需求分析**
```
用户：我在金沙上班，预算4000新币，喜欢安静

分析：
- 工作地点：Marina Bay Sands (Bayfront MRT)
- 预算：$4,000/月
- 偏好：安静

推荐：
1. **Tanjong Pagar** - 1站MRT，既有便利又有居民区安静
2. **Outram Park** - 2站MRT，交通枢纽，租金略低
3. **Telok Ayer** - 步行可达，保留娘惹建筑特色
```

**场景2：看房检查清单**
```
用户：明天去看 Icon 的房子，要注意什么？

检查清单：
- [ ] 到 MRT 实际步行时间（带秒表）
- [ ] 关窗/开窗噪音对比（靠近轨道的单位）
- [ ] 朝向（避免西晒）
- [ ] 楼层（中高层较好，但等电梯时间）
- [ ] 周边超市（最近的 FairPrice 在哪）
- [ ] 晚上 9 点后再去一次（评估夜间噪音）
```

**场景3：楼盘对比**
```
用户：Icon vs Duo Residences 怎么选？

对比：
| 维度 | Icon | Duo |
|------|------|-----|
| 租金 | 较低 | 较高 |
| 楼龄 | 2010年（较旧） | 2014年（较新） |
| 面积 | 较大 | 较小 |
| 通勤 | 极优（1-2站到CBD） | 良好（3-4站） |
| 周边 | 食阁多，生活便利 | 商场多，设计感强 |
| 噪音 | 靠近轨道，需注意 | 靠近马路，需注意 |

建议：预算敏感选 Icon，追求品质选 Duo
```

---

## 数据来源

- 租金数据：PropertyGuru, 99.co (2026年2月)
- 交通：Land Transport Authority (LTA)
- 学校：Ministry of Education (MOE)
- 开发规划：Urban Redevelopment Authority (URA)

*提示：租金随市场波动，建议多渠道比价*
