---
name: sina-stock
description: 获取 A 股实时股票行情数据（上证指数、深证成指、创业板指等），使用新浪财经 API。无需 API Key。
---

# Sina Stock - A 股实时行情

通过新浪财经 API 获取 A 股市场实时行情数据，包括大盘指数和个股行情。

## 功能特性

- 📈 **实时行情** - 获取当前价格、涨跌幅、成交量、成交额
- 📊 **大盘指数** - 上证指数、深证成指、创业板指、沪深 300 等
- 📉 **个股行情** - 支持任意 A 股股票代码查询
- 💰 **详细数据** - 开盘价、收盘价、最高价、最低价、振幅
- 🆓 **免费使用** - 无需 API Key，直接调用

## 支持的大盘指数

| 名称 | 代码 | 市场 |
|------|------|------|
| 上证指数 | sh000001 | 沪市 |
| 深证成指 | sz399001 | 深市 |
| 创业板指 | sz399006 | 创业板 |
| 沪深 300 | sh000300 | 跨市场 |
| 上证 50 | sh000016 | 沪市 |
| 中证 500 | sh000905 | 跨市场 |

## 快速开始

### 获取大盘行情

```bash
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh000001,sz399001,sz399006
```

### 获取个股行情

```bash
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh600519,sz000858
```

### 格式化输出（JSON）

```bash
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh000001 --json
```

## 脚本参数

| 参数 | 说明 | 默认值 |
|------|------|--------|
| `codes` | 股票代码（逗号分隔） | 必填 |
| `--json` | 输出 JSON 格式 | false |
| `--simple` | 简化输出 | false |

## 输出示例

### 标准输出
```
============================================================
           A 股股市大盘实时数据
           更新时间：2026-03-02 15:00
============================================================

【上证指数】
  当前价：  4151.80
  涨跌幅：  +0.00 (+0.00%)
  开盘价：  4162.88
  最高价：  4188.77
  最低价：  4131.37
  成交量：  861,579,218 手
  成交额：  1,345,892,469,395 元

============================================================
数据来源：新浪财经 API
```

### JSON 输出
```json
{
  "time": "2026-03-02 15:00:00",
  "data": [
    {
      "code": "sh000001",
      "name": "上证指数",
      "current": 4151.80,
      "change": 0.00,
      "change_pct": 0.00,
      "open": 4162.88,
      "high": 4188.77,
      "low": 4131.37,
      "volume": 861579218,
      "turnover": 1345892469395
    }
  ]
}
```

## 股票代码格式

- **沪市股票**：`sh` + 6 位代码（如 `sh600519`）
- **深市股票**：`sz` + 6 位代码（如 `sz000858`）
- **大盘指数**：同上（如 `sh000001`）

## 数据字段说明

| 字段 | 说明 |
|------|------|
| current | 当前价格 |
| change | 涨跌额（当前价 - 昨收价） |
| change_pct | 涨跌幅（百分比） |
| open | 开盘价 |
| high | 最高价 |
| low | 最低价 |
| prev_close | 昨收价 |
| volume | 成交量（手） |
| turnover | 成交额（元） |

## 使用示例

### 示例 1：查看大盘整体情况
```bash
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh000001 sz399001 sz399006
```

### 示例 2：监控自选股
```bash
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh600519,sz000858,sz300750 --simple
```

### 示例 3：获取数据用于程序处理
```bash
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh000001 --json
```

## 技术实现

### API 接口
```
https://hq.sinajs.cn/list=[股票代码]
```

### 响应格式（GBK 编码）
```
var hq_str_sh000001="指数名称，当前价，开盘价，昨收价，最高价，最低价，涨跌额，涨跌幅，成交量，成交额，..."
```

### 数据解析
脚本自动处理：
1. GBK 编码解码
2. CSV 格式解析
3. 数值格式化
4. 涨跌幅计算

## 注意事项

1. **交易时间**：
   - 上午：9:30-11:30
   - 下午：13:00-15:00
   - 非交易时间返回最后收盘价

2. **数据延迟**：实时数据，可能有秒级延迟

3. **编码处理**：API 返回 GBK 编码，脚本已自动处理

4. **请求频率**：建议间隔 1 秒以上，避免被限流

## 常见问题

**Q: 为什么涨跌幅是 0？**
A: 非交易时间或刚开盘时，数据可能未更新

**Q: 可以获取港股/美股吗？**
A: 不支持，此技能仅限 A 股。港股美股需用其他 API

**Q: 数据准确吗？**
A: 数据来自新浪财经，与官网一致

## 扩展开发

如需添加功能，可修改脚本中的 `format_output()` 函数：

```python
def format_output(data, fmt='text'):
    if fmt == 'json':
        return json.dumps(data, ensure_ascii=False, indent=2)
    elif fmt == 'simple':
        # 自定义简化格式
        ...
    else:
        # 标准文本格式
        ...
```

## 许可证

MIT License

## 数据来源

新浪财经 (https://finance.sina.com.cn/)
