# sina-stock Skill

获取 A 股实时股票行情数据，使用新浪财经 API。

## 快速使用

```bash
# 获取大盘指数
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh000001 sz399001 sz399006

# 获取个股行情
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh600519 sz000858

# JSON 格式输出
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh000001 --json

# 简化输出
python3 "$SKILLS_ROOT/sina-stock/scripts/get_stock.py" sh000001 sz399001 --simple
```

## 支持的指数

| 名称 | 代码 |
|------|------|
| 上证指数 | sh000001 |
| 深证成指 | sz399001 |
| 创业板指 | sz399006 |
| 沪深 300 | sh000300 |
| 上证 50 | sh000016 |
| 中证 500 | sh000905 |

## 输出示例

```
============================================================
           A 股股市大盘实时数据
           更新时间：2026-03-02 15:00
============================================================

【上证指数 (sh000001)】
  当前价：   4151.80
  涨跌幅：   -30.79 (-0.74%)
  开盘价：   4162.88
  最高价：   4188.77
  最低价：   4131.37
  成交量：   861,579,218 手
  成交额：   1,345,892,469,395 元

============================================================
数据来源：新浪财经 API
```

## 注意事项

1. 交易时间：工作日 9:30-11:30, 13:00-15:00
2. 非交易时间返回最后收盘价
3. 建议请求间隔 1 秒以上

## 数据来源

新浪财经 (https://finance.sina.com.cn/)
