# SignalRadar Configuration Reference

## Precedence (High to Low)

1. CLI args (current run)
2. `config.json` (via `--config` or `SIGNALRADAR_CONFIG`)
3. `DEFAULT_CONFIG` in `scripts/config_utils.py`

## Config Path Resolution

- First: `--config /path/to/signalradar_config.json`
- Then: env `SIGNALRADAR_CONFIG`
- Fallback: `<workspace>/config/signalradar_config.json`

## Minimum Config Shape

```json
{
  "profile": {
    "timezone": "Asia/Shanghai",
    "language": "zh"
  },
  "threshold": {
    "abs_pp": 5.0,
    "rel_pct": 5.0,
    "rel_pct_enabled": false,
    "per_category_abs_pp": {
      "AI Releases": 4.0,
      "Crypto": 8.0
    },
    "per_entry_abs_pp": {
      "polymarket:12345:example-slug:evt_12345": 3.0
    }
  },
  "dedup": {
    "enabled": false,
    "window_minutes": 0
  },
  "delivery": {
    "primary": {
      "channel": "openclaw",
      "target": "direct"
    }
  },
  "source": {
    "retries": 2
  },
  "digest": {
    "frequency": "off"
  },
  "baseline": {
    "cleanup_expired": true,
    "cleanup_ttl_days": 45
  }
}
```

## Watchlist Extended Columns

`polymarket_watchlist_2026.md` supports two optional columns:

- `WatchLevel`: `normal` (default) or `important`
- `ThresholdPP`: per-entry abs threshold override

Table shape:

- `| 分类 | 问题 | Yes概率 | 24h成交额 | 总成交额 | 截止日 | WatchLevel | ThresholdPP |`

## Digest Rules

- `digest.frequency`: `off` (default) / `daily` / `weekly` / `biweekly`
- Digest only summarizes entries where `WatchLevel=important`
- If all entries are `normal`, digest is not sent even when frequency is not `off`
- Digest includes stable entries (`important`) even when there is no hit

## Baseline Cleanup

- `baseline.cleanup_expired=true` enables cleanup in decide step
- Cleanup removes baseline files when:
  - entry is no longer active in current snapshot set, or
  - baseline age exceeds `baseline.cleanup_ttl_days`

CLI flags:

- `--cleanup-expired`
- `--cleanup-ttl-days 45`

## Notes

- `.env.example` contains deployment hints only.
- Runtime behavior is controlled by CLI/config; do not assume `SIGNALRADAR_*` env vars are auto-applied unless script explicitly reads them.
