---
name: signalhire
description: Prospect and enrich contacts via the SignalHire API (Search, Person and Credits)
metadata:
  openclaw:
    # The skill only loads when a valid API key and callback URL are provided.  The
    # primary environment variable is used to inject the secret without ever
    # exposing it in the instructions.  The callback URL should point to the
    # connector service exposed publicly via a tunnel or reverse proxy.
    requires:
      env: SIGNALHIRE_API_KEY,SIGNALHIRE_CALLBACK_URL
    primaryEnv: SIGNALHIRE_API_KEY
---

# SignalHire skill instructions

This skill exposes three high‑level capabilities to an OpenClaw agent.  Each
capability corresponds to one of the REST endpoints documented by SignalHire.
The agent should never call these endpoints directly; instead it must invoke
one of the defined skill actions.  The following guidance summarises how the
API works, including rate limits, concurrency limits and the asynchronous
callback workflow.  All factual statements below are supported by the official
SignalHire API documentation.

## 1. Check remaining credits

Use this action to determine how many credits remain on the account.  The
SignalHire API exposes a dedicated endpoint `GET /api/v1/credits` which returns
the number of available credits as a JSON payload.  A valid API key must be
included in the request headers.  When invoked successfully, the response
contains a field called `credits` with the number of credits remaining【821841938681143†L505-L529】.  If the
account is configured for “profiles without contacts”, the same endpoint can
be called with a `withoutContacts=true` query parameter【821841938681143†L559-L566】.  Credits are also
returned in the `X-Credits-Left` response header for every Person API call【821841938681143†L559-L566】.

The agent **must call this action** before launching large enrichment jobs to
avoid running out of credits mid‑operation.  If the number of remaining
credits is lower than the number of items to be enriched, the job should be
split or aborted gracefully.

## 2. Search for profiles

Use this action to find prospective candidates in the SignalHire database
without consuming contact credits.  The Search API endpoint is
`POST /api/v1/candidate/searchByQuery`【21055727237259†L100-L109】 and returns a list of profile summaries
along with a `scrollId`.  The scrollId can be used to fetch additional pages
via the Scroll Search endpoint (not shown here) until all results are
exhausted.  Access to the Search API is granted only after contacting
SignalHire support and is subject to a strict concurrency limit of **three
simultaneous requests**【21055727237259†L110-L116】.  The agent must ensure that no more than three
searchByQuery calls are inflight at any time.

When performing a search, the request body should include fields such as
`currentTitle`, `location`, `keywords`, `industry` and other filters as
described in the documentation【21055727237259†L120-L177】.  The `size` parameter controls how many
profiles are returned per page (default 10, maximum 100).  After retrieving the
first page, the agent should immediately follow up with a scroll request
within 15 seconds to avoid expiration of the `scrollId`.  The response from
search is synchronous and will return immediately; no callback is needed.

## 3. Enrich contacts (Person API)

This action retrieves full contact information (emails, phones and social
profiles) for up to 100 items per request.  The endpoint is
`POST /api/v1/candidate/search`【821841938681143†L126-L134】.  Each item may be a LinkedIn profile URL,
an email address, a phone number or a SignalHire profile UID【821841938681143†L120-L124】.  The
request body **must** include a `callbackUrl` parameter; once the data is
processed the API posts the results to this URL【821841938681143†L126-L134】.  A valid server
listening on the callbackUrl must return HTTP status 200 to acknowledge
successful receipt.  SignalHire retries up to three times if the callback
endpoint cannot be reached or if it does not respond within a ten‑second
timeout【821841938681143†L187-L198】.  Processing is complete only when all callback payloads have
been received.

The callback payload contains an array of objects, each with a `status` field
indicating the outcome for that item: `success`, `failed`, `credits_are_over`,
`timeout_exceeded` or `duplicate_query`【821841938681143†L239-L249】.  When the status is
`success`, the payload also includes a `candidate` object with fields such as
`fullName`, `emails`, `phones`, `location`, etc.  These results are
persisted by the connector service into a CSV file; the agent should wait
until the connector reports that the job is ready before consuming the data.

The Person API is subject to rate limits: a maximum of **600 elements
processed per minute**【821841938681143†L490-L503】.  The agent must implement throttling to ensure that the
combined number of items in all Person API calls does not exceed this limit.
Requests exceeding the limit will be rejected with HTTP status 429
`Too Many Requests`【821841938681143†L500-L503】.  To maximise throughput, batch up to 100 items per
request but do not exceed the global per‑minute quota.

## General guidance for agents

1. **Do not hard‑code the API key or callback URL.**  Use the environment
   variables injected by OpenClaw: `SIGNALHIRE_API_KEY` for authentication and
   `SIGNALHIRE_CALLBACK_URL` for the Person API.  These values are supplied at
   runtime and must not be echoed or leaked.

2. **Always check remaining credits** before starting a large enrichment job.
   Abort or split the job if credits are insufficient.

3. **Respect rate and concurrency limits.**  No more than three concurrent
   Search API requests【21055727237259†L110-L116】.  Do not send more than 600 items through the
   Person API per minute【821841938681143†L490-L503】.  Implement exponential backoff on HTTP 429
   responses.

4. **Always include a valid callbackUrl** when calling the Person API and
   ensure the connector service is reachable and responsive.  The callback
   must return HTTP 200 within ten seconds or the result may be discarded【821841938681143†L187-L198】.

5. **Wait for job completion**.  After submitting a Person API request, the
   agent should poll the connector’s job endpoint (described in the README)
   until it indicates that all results have been received.  Only then should
   the agent proceed to process the CSV data.

6. **Handle all status values** from the callback.  For `failed`, `credits_are_over`,
   `timeout_exceeded` and `duplicate_query`, no candidate data will be
   available; log these cases and move on.

7. **Comply with legal and privacy requirements.**  SignalHire ties API usage to
   their Terms, Privacy and GDPR pages.  Always respect data‑subject rights
   and opt‑out requests when storing or using contact data【821841938681143†L559-L566】.

By following the above instructions, the agent can safely integrate SignalHire’s
prospecting and enrichment capabilities into an OpenClaw workflow.