# SignalHire OpenClaw skill

This repository contains everything needed to run a complete SignalHire
integration as an OpenClaw skill.  It includes a concise set of agent
instructions (`SKILL.md`) and a small **connector** service that handles
asynchronous callbacks from the SignalHire Person API.  The connector writes
results into CSV files on the local filesystem so you can import them into
your CRM or analysis pipeline.

## Prerequisites

* **Operating system:** Ubuntu or any Linux distribution with Python 3.8+.
* **Python packages:** The connector depends on `flask` only.  Install it with
  `pip install flask`.
* **Environment variables:**
  * `SIGNALHIRE_API_KEY` – your SignalHire API key.  Required for all API
    calls.
  * `SIGNALHIRE_CALLBACK_URL` – a publicly reachable HTTPS endpoint that
    forwards to the local connector.  SignalHire posts results to this
    address after processing Person API requests.  It must respond with HTTP
    status 200 within ten seconds to be considered successful【821841938681143†L187-L198】.
  * `SIGNALHIRE_OUTPUT_DIR` – the directory where CSV files will be written.
    Defaults to `./data/signalhire` if not set.

You will also need a way to expose your local connector to the internet.  A
free Cloudflare Tunnel is the simplest option: it creates a secure public URL
and forwards requests to your local machine without opening firewall ports.

## Running the connector

1. **Install dependencies:**

   ```bash
   python3 -m pip install flask
   ```

2. **Start the connector:**

   ```bash
   export SIGNALHIRE_OUTPUT_DIR=/opt/openclaw/data/signalhire
   python3 -m signalhire.connector.main --port 8787
   ```

   The connector listens on the port you specify (default 8787) and exposes
   two endpoints:

   * `POST /signalhire/callback` – receives callback payloads from
     SignalHire.  It writes or appends rows to a CSV file named
     `results_<requestId>.csv` in the output directory.  The callback
     endpoint must be mapped to your public `SIGNALHIRE_CALLBACK_URL` (e.g.,
     via a Cloudflare Tunnel or reverse proxy).  SignalHire will retry up
     to three times if the callback fails or times out【821841938681143†L187-L198】.
   * `GET /signalhire/jobs/<requestId>` – returns a JSON object describing
     whether the job has produced any rows and how many.  Once the row
     count matches the number of items you submitted, the job is ready and
     the CSV can be processed.

3. **Expose the callback:**

   If you use Cloudflare Tunnel, run something like:

   ```bash
   cloudflared tunnel run my-signalhire
   # This prints a public URL such as https://red-example.trycloudflare.com
   ```

   Set `SIGNALHIRE_CALLBACK_URL` to `https://red-example.trycloudflare.com/signalhire/callback`.

## CSV output schema

The connector writes one CSV per Person API request.  A consolidated
`results_all.csv` is also maintained in the same directory.  Each row in the
CSV includes the following fields:

| column          | description |
|-----------------|-------------|
| `request_id`    | Unique ID returned by the Person API and sent back in the callback header【821841938681143†L200-L208】. |
| `input_type`    | Type of the input: `linkedin`, `email`, `phone` or `uid`. |
| `input_value`   | The identifier you requested. |
| `status`        | One of `success`, `failed`, `credits_are_over`, `timeout_exceeded` or `duplicate_query`【821841938681143†L239-L249】. |
| `full_name`     | Candidate’s full name (empty if status is not `success`). |
| `title`         | Current job title (if available). |
| `company_name`  | Current company (if available). |
| `location`      | Candidate’s primary location. |
| `linkedin_url`  | LinkedIn profile URL (if present). |
| `emails`        | Semicolon‑separated list of email addresses. |
| `phones`        | Semicolon‑separated list of phone numbers. |
| `source`        | Always set to `signalhire`. |
| `received_at_utc` | Timestamp when the callback was processed. |

The per‑request CSV is named `results_<requestId>.csv`, where `<requestId>`
comes from the Person API response.  A global file `results_all.csv` is
updated with every callback for convenience.

## Usage in an OpenClaw workflow

1. **Agent loads the skill:** When OpenClaw starts, it reads `SKILL.md`.  If
   `SIGNALHIRE_API_KEY` and `SIGNALHIRE_CALLBACK_URL` are present in the
   environment, the skill is enabled and the agent can call its actions.

2. **Check credits:** The agent calls `signalhire_check_credits` to determine
   how many credits remain【821841938681143†L505-L529】.  If the account has too few credits for the
   upcoming job, it should warn the user or split the job.

3. **Search:** To identify prospects without spending credits, the agent
   invokes `signalhire_search_by_query` with filters such as job title,
   location and keywords【21055727237259†L120-L177】.  Only three concurrent search requests are
   allowed【21055727237259†L110-L116】, so the agent must throttle itself.  The search action returns a
   list of UIDs or LinkedIn URLs that can be passed to the Person API.

4. **Enrich:** The agent invokes `signalhire_enrich_contacts` with up to 100
   identifiers and waits for a `requestId` response【821841938681143†L126-L134】.  The agent then polls
   `GET /signalhire/jobs/<requestId>` until the CSV is ready.  Once ready,
   the agent reads the CSV from disk and uses it to populate leads in your
   downstream system.

5. **Respect rate limits:** Do not submit more than 600 items per minute
   through the Person API【821841938681143†L490-L503】 and no more than three concurrent Search API
   requests【21055727237259†L110-L116】.  Implement exponential backoff on HTTP 429 responses.

## Legal and privacy considerations

SignalHire ties API usage to its Terms, Privacy Policy and GDPR pages.
Retrieved contact information must be handled responsibly and used only for
legitimate purposes.  Always honour opt‑out and removal requests.  The
documentation emphasises the importance of a valid callback server and a
prompt 200 OK response to avoid data loss【821841938681143†L187-L198】.

## Contact

For more information about the SignalHire API, please refer to the official
documentation at <https://www.signalhire.com/api/person>.  If you require
assistance integrating this skill into your OpenClaw deployment, please open
an issue or contact your system administrator.