# Discovery & Recommendations

## Finding New Content

### Based on Taste
When user asks "what should I watch?" or "recommend something":
1. Check their completed list for patterns (genres, ratings)
2. Check what they've enjoyed recently
3. Consider mood cues ("something light", "intense thriller")
4. Factor in time available ("I have 2 hours" vs "need a short watch")

### Similar Content
When user asks for "more like X":
- Consider: genre, tone, director, themes, pacing
- Check what they've already seen to avoid repeats
- Surface from watchlist first if matches exist

---

## Blind Spot Detection

For cinephiles especially:
- Track directors/genres they haven't explored
- "You've never watched a Kurosawa film"
- "You love thrillers but haven't tried Korean cinema"

Gentle nudges, not prescriptive—some blind spots are intentional.

---

## Tracking Recommendations from Others

When someone recommends something:
```
## The Wire (2002)
- Recommended by: Carlos
- Date added: 2026-02-13
- Why: "Best show ever made"
- Priority: high
```

Use this to:
- Surface "Carlos recommended this 3 months ago—still haven't started"
- Remember context when finally watching

---

## Release Tracking

### Anticipated Releases
Track films/shows user is waiting for:
- Title, expected release date, platform if known
- Alert when release date announced or arrives

### New Seasons
For shows user has watched:
- Track if renewed/cancelled
- Alert when new season premieres
- "Severance S3 drops tomorrow"

---

## Event Tracking

### Award Season
- Oscar nominations: "You've seen 4/10 Best Picture noms"
- Emmy nominees in their genre preferences
- Golden Globes, etc.

### Festivals
- Cannes, Venice, Sundance highlights
- Alert if favorite directors have films premiering

---

## Quick Suggestions Format

When suggesting what to watch:

**For quick picks:**
```
Based on your mood (light, 2 hours):
1. The Grand Budapest Hotel — whimsical, 99 min, on HBO
2. Knives Out — fun mystery, 130 min, on Prime
3. Palm Springs — romcom, 90 min, on Hulu
```

**For intentional viewing:**
```
From your watchlist (high priority):
- Oppenheimer — you've been meaning to watch, 3 hours
- The Zone of Interest — Oscar winner, 105 min
```

---

## Year-End Stats

If user asks or at year end, compile:
- Total films/episodes watched
- Average rating
- Top genres
- Top-rated items
- Most-watched platform
- Viewing trends over time
