#!/bin/bash
# Update a comment on a Shortcut story
# Usage: ./shortcut-update-comment.sh <story-id> <comment-id> "new text"

set -euo pipefail

TOKEN="${SHORTCUT_API_TOKEN:-$(cat ~/.config/shortcut/api-token 2>/dev/null | tr -d '\n')}"
BASE_URL="https://api.app.shortcut.com/api/v3"

STORY_ID="${1:-}"
COMMENT_ID="${2:-}"
TEXT="${3:-}"

if [ -z "$STORY_ID" ] || [ -z "$COMMENT_ID" ] || [ -z "$TEXT" ]; then
  echo "Usage: $0 <story-id> <comment-id> \"new text\""
  exit 1
fi

# Build payload
PAYLOAD=$(jq -n --arg text "$TEXT" '{
  text: $text
}')

# Update comment
RESPONSE=$(curl -s -X PUT \
  -H "Content-Type: application/json" \
  -H "Shortcut-Token: $TOKEN" \
  -d "$PAYLOAD" \
  "$BASE_URL/stories/$STORY_ID/comments/$COMMENT_ID")

# Output
TEXT_OUT=$(echo "$RESPONSE" | jq -r '.text')

if [ "$TEXT_OUT" != "null" ]; then
  echo "✅ Updated comment #$COMMENT_ID: $TEXT_OUT"
else
  echo "❌ Failed to update comment"
  echo "$RESPONSE" | jq .
  exit 1
fi
