#!/bin/bash
# Edit a checklist task's description in a Shortcut story
# Usage: ./shortcut-edit-task.sh <story-id> <task-id> "new description"

set -euo pipefail

TOKEN="${SHORTCUT_API_TOKEN:-$(cat ~/.config/shortcut/api-token 2>/dev/null | tr -d '\n')}"
BASE_URL="https://api.app.shortcut.com/api/v3"

STORY_ID="${1:-}"
TASK_ID="${2:-}"
DESCRIPTION="${3:-}"

if [ -z "$STORY_ID" ] || [ -z "$TASK_ID" ] || [ -z "$DESCRIPTION" ]; then
  echo "Usage: $0 <story-id> <task-id> \"new description\""
  exit 1
fi

# Build payload
PAYLOAD=$(jq -n --arg desc "$DESCRIPTION" '{
  description: $desc
}')

# Update task
RESPONSE=$(curl -s -X PUT \
  -H "Content-Type: application/json" \
  -H "Shortcut-Token: $TOKEN" \
  -d "$PAYLOAD" \
  "$BASE_URL/stories/$STORY_ID/tasks/$TASK_ID")

# Output
DESC_OUT=$(echo "$RESPONSE" | jq -r '.description')

if [ "$DESC_OUT" != "null" ]; then
  echo "✅ Updated task #$TASK_ID: $DESC_OUT"
else
  echo "❌ Failed to update task"
  echo "$RESPONSE" | jq .
  exit 1
fi
