#!/bin/bash
# Delete a checklist task from a Shortcut story
# Usage: ./shortcut-delete-task.sh <story-id> <task-id>

set -euo pipefail

TOKEN="${SHORTCUT_API_TOKEN:-$(cat ~/.config/shortcut/api-token 2>/dev/null | tr -d '\n')}"
BASE_URL="https://api.app.shortcut.com/api/v3"

STORY_ID="${1:-}"
TASK_ID="${2:-}"

if [ -z "$STORY_ID" ] || [ -z "$TASK_ID" ]; then
  echo "Usage: $0 <story-id> <task-id>"
  exit 1
fi

# Delete task
HTTP_CODE=$(curl -s -w "%{http_code}" -o /tmp/shortcut-delete-response.json \
  -X DELETE \
  -H "Shortcut-Token: $TOKEN" \
  "$BASE_URL/stories/$STORY_ID/tasks/$TASK_ID")

if [ "$HTTP_CODE" = "204" ]; then
  echo "✅ Deleted task #$TASK_ID"
else
  echo "❌ Failed to delete task (HTTP $HTTP_CODE)"
  cat /tmp/shortcut-delete-response.json | jq . 2>/dev/null || cat /tmp/shortcut-delete-response.json
  exit 1
fi
