#!/bin/bash
# Delete a comment from a Shortcut story
# Usage: ./shortcut-delete-comment.sh <story-id> <comment-id>

set -euo pipefail

TOKEN="${SHORTCUT_API_TOKEN:-$(cat ~/.config/shortcut/api-token 2>/dev/null | tr -d '\n')}"
BASE_URL="https://api.app.shortcut.com/api/v3"

STORY_ID="${1:-}"
COMMENT_ID="${2:-}"

if [ -z "$STORY_ID" ] || [ -z "$COMMENT_ID" ]; then
  echo "Usage: $0 <story-id> <comment-id>"
  exit 1
fi

# Delete comment
HTTP_CODE=$(curl -s -w "%{http_code}" -o /tmp/shortcut-delete-comment-response.json \
  -X DELETE \
  -H "Shortcut-Token: $TOKEN" \
  "$BASE_URL/stories/$STORY_ID/comments/$COMMENT_ID")

if [ "$HTTP_CODE" = "204" ]; then
  echo "✅ Deleted comment #$COMMENT_ID"
else
  echo "❌ Failed to delete comment (HTTP $HTTP_CODE)"
  cat /tmp/shortcut-delete-comment-response.json | jq . 2>/dev/null || cat /tmp/shortcut-delete-comment-response.json
  exit 1
fi
