#!/bin/bash
# Create a new checklist task in a Shortcut story
# Usage: ./shortcut-create-task.sh <story-id> "task description"

set -euo pipefail

TOKEN="${SHORTCUT_API_TOKEN:-$(cat ~/.config/shortcut/api-token 2>/dev/null | tr -d '\n')}"
BASE_URL="https://api.app.shortcut.com/api/v3"

STORY_ID="${1:-}"
DESCRIPTION="${2:-}"

if [ -z "$STORY_ID" ] || [ -z "$DESCRIPTION" ]; then
  echo "Usage: $0 <story-id> \"task description\""
  exit 1
fi

# Build payload
PAYLOAD=$(jq -n --arg desc "$DESCRIPTION" '{
  description: $desc,
  complete: false
}')

# Create task
RESPONSE=$(curl -s -X POST \
  -H "Content-Type: application/json" \
  -H "Shortcut-Token: $TOKEN" \
  -d "$PAYLOAD" \
  "$BASE_URL/stories/$STORY_ID/tasks")

# Output
TASK_ID=$(echo "$RESPONSE" | jq -r '.id')
DESC_OUT=$(echo "$RESPONSE" | jq -r '.description')

if [ "$TASK_ID" != "null" ]; then
  echo "✅ Created task #$TASK_ID: $DESC_OUT"
else
  echo "❌ Failed to create task"
  echo "$RESPONSE" | jq .
  exit 1
fi
