#!/bin/bash
# Add a comment to a Shortcut story
# Usage: ./shortcut-add-comment.sh <story-id> "comment text"

set -euo pipefail

TOKEN="${SHORTCUT_API_TOKEN:-$(cat ~/.config/shortcut/api-token 2>/dev/null | tr -d '\n')}"
BASE_URL="https://api.app.shortcut.com/api/v3"

STORY_ID="${1:-}"
TEXT="${2:-}"

if [ -z "$STORY_ID" ] || [ -z "$TEXT" ]; then
  echo "Usage: $0 <story-id> \"comment text\""
  exit 1
fi

# Build payload
PAYLOAD=$(jq -n --arg text "$TEXT" '{
  text: $text
}')

# Create comment
RESPONSE=$(curl -s -X POST \
  -H "Content-Type: application/json" \
  -H "Shortcut-Token: $TOKEN" \
  -d "$PAYLOAD" \
  "$BASE_URL/stories/$STORY_ID/comments")

# Output
COMMENT_ID=$(echo "$RESPONSE" | jq -r '.id')
TEXT_OUT=$(echo "$RESPONSE" | jq -r '.text')

if [ "$COMMENT_ID" != "null" ]; then
  echo "✅ Added comment #$COMMENT_ID: $TEXT_OUT"
else
  echo "❌ Failed to add comment"
  echo "$RESPONSE" | jq .
  exit 1
fi
